/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import java.util.Iterator;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.PatternInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.RedundancyResult;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectRedundantActionCheck
extends SingleCheck {
    private PatternInspector patternInspector;
    private RedundancyResult<ObjectField, ActionInspector> result;

    public DetectRedundantActionCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        Iterator iterator = this.ruleInspector.getPatternsInspector().iterator();
        while (iterator.hasNext()) {
            PatternInspector patternInspector;
            this.patternInspector = patternInspector = (PatternInspector)iterator.next();
            this.result = patternInspector.getActionsInspector().hasRedundancy();
            if (!this.result.isTrue()) continue;
            this.hasIssues = true;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, this.getMessage(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsP1()).startNote().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsNote1P1(((ActionInspector)DetectRedundantActionCheck.this.result.get(0)).toHumanReadableString(), ((ActionInspector)DetectRedundantActionCheck.this.result.get(1)).toHumanReadableString())).end().toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }

    private String getMessage() {
        if (this.patternInspector.getPattern().getBoundName() != null) {
            return AnalysisConstants.INSTANCE.ValueForFactFieldIsSetTwice(this.patternInspector.getPattern().getBoundName(), this.result.getParent().getName());
        }
        return AnalysisConstants.INSTANCE.ValueForAnActionIsSetTwice();
    }
}

