/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectRedundantRowsCheck {
    public static Issue check(RuleInspector ruleInspector, RuleInspector other) {
        if (other.atLeastOneActionHasAValue()) {
            boolean subsumes = ruleInspector.subsumes(other);
            if (subsumes && other.subsumes(ruleInspector)) {
                return DetectRedundantRowsCheck.getIssue(ruleInspector, other, Status.REDUNDANT);
            }
            if (subsumes) {
                return DetectRedundantRowsCheck.getIssue(ruleInspector, other, Status.SUBSUMES);
            }
        }
        return Issue.EMPTY;
    }

    public static Issue getIssue(RuleInspector ruleInspector, RuleInspector other, final Status status) {
        Issue issue = new Issue(Severity.WARNING, DetectRedundantRowsCheck.getMessage(status), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return DetectRedundantRowsCheck.getExplanation(status).toHTML();
            }
        }, ruleInspector, other);
        return issue;
    }

    private static String getMessage(Status status) {
        switch (status) {
            case REDUNDANT: {
                return AnalysisConstants.INSTANCE.RedundantRows();
            }
            case SUBSUMES: {
                return AnalysisConstants.INSTANCE.SubsumptantRows();
            }
        }
        return "";
    }

    private static Explanation getExplanation(Status status) {
        switch (status) {
            case REDUNDANT: {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP1()).addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP2()).addParagraph(AnalysisConstants.INSTANCE.RedundantRowsP3());
            }
            case SUBSUMES: {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.SubsumptantRowsP1()).addParagraph(AnalysisConstants.INSTANCE.SubsumptantRowsP2());
            }
        }
        return new Explanation();
    }

    static enum Status {
        REDUNDANT,
        SUBSUMES;

    }
}

