/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.LeafInspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.OneToManyCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.SubsumptionResolver;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class RangeCheck
extends OneToManyCheck {
    private InspectorList<RuleInspector> otherRows;

    public RangeCheck(final RuleInspector ruleInspector) {
        super(ruleInspector, new RuleInspectorCache.Filter(){

            @Override
            public boolean accept(RuleInspector other) {
                return !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey());
            }
        });
    }

    @Override
    public void check() {
        this.otherRows = this.getOtherRows();
        if (this.otherRows.size() == 0) {
            this.hasIssues = false;
        } else {
            RuleInspectorClone evilClone = this.makeClone();
            this.hasIssues = evilClone.containsInvertedItems && !this.isSubsumedByOtherRows(evilClone);
        }
    }

    private boolean isSubsumedByOtherRows(RuleInspectorClone evilClone) {
        if (this.otherRows.isEmpty()) {
            return true;
        }
        return !SubsumptionResolver.isSubsumedByAnObjectInThisList(this.otherRows, evilClone).foundIssue();
    }

    private FieldCondition invert(FieldCondition condition) {
        return new FieldCondition<Comparable>(condition.getField(), condition.getColumn(), this.invert(condition.getOperator()), condition.getValues());
    }

    private String invert(String operator) {
        switch (operator) {
            case "==": {
                return "!=";
            }
            case "!=": {
                return "==";
            }
            case ">": {
                return "<=";
            }
            case "<": {
                return ">=";
            }
            case ">=": {
                return "<";
            }
            case "<=": {
                return ">";
            }
        }
        return operator;
    }

    private RuleInspectorClone makeClone() {
        return new RuleInspectorClone(this.ruleInspector.getRule(), this.ruleInspector.getCache());
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.NOTE, AnalysisConstants.INSTANCE.MissingRangeTitle(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.MissingRangeP1(RangeCheck.this.ruleInspector.getRowIndex() + 1)).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }

    private class RuleInspectorClone
    extends RuleInspector {
        private final InspectorList<ConditionsInspectorMultiMap> conditionsInspectors;
        boolean containsInvertedItems;

        public RuleInspectorClone(Rule rule, RuleInspectorCache cache) {
            super(rule, new CheckManager(), cache);
            this.conditionsInspectors = new InspectorList();
            this.containsInvertedItems = false;
            this.makeConditionsInspectors();
        }

        @Override
        public InspectorList<ConditionsInspectorMultiMap> getConditionsInspectors() {
            return this.conditionsInspectors;
        }

        private void makeConditionsInspectors() {
            this.conditionsInspectors.clear();
            for (ConditionsInspectorMultiMap original : super.getConditionsInspectors()) {
                ConditionsInspectorMultiMap clone = new ConditionsInspectorMultiMap();
                for (ObjectField field : original.keySet()) {
                    LeafInspectorList originalConditionInspectors = original.get(field);
                    if (originalConditionInspectors.isEmpty()) {
                        clone.putAllValues(field, originalConditionInspectors);
                        continue;
                    }
                    for (ConditionInspector originalInspector : originalConditionInspectors) {
                        clone.put(field, this.resolveInspector(originalInspector));
                    }
                }
                this.conditionsInspectors.add(clone);
            }
        }

        private ConditionInspector resolveInspector(ConditionInspector originalInspector) {
            if (originalInspector.getCondition() instanceof FieldCondition) {
                FieldCondition fieldCondition = (FieldCondition)originalInspector.getCondition();
                if (fieldCondition.getField().getFieldType().equals("Integer")) {
                    this.containsInvertedItems = true;
                    return new NumericIntegerConditionInspector((FieldCondition<Integer>)RangeCheck.this.invert(fieldCondition));
                }
                if (DataType.isNumeric((String)fieldCondition.getField().getFieldType())) {
                    this.containsInvertedItems = true;
                    return new ComparableConditionInspector(RangeCheck.this.invert(fieldCondition));
                }
                if (fieldCondition.getField().getFieldType().equals("Boolean")) {
                    this.containsInvertedItems = true;
                    return new BooleanConditionInspector((FieldCondition<Boolean>)RangeCheck.this.invert(fieldCondition));
                }
            }
            return originalInspector;
        }

        @Override
        public boolean subsumes(Object other) {
            return other instanceof RuleInspector && this.getBrlConditionsInspectors().subsumes(((RuleInspector)other).getBrlConditionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
        }
    }
}

