/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base;

import java.util.ArrayList;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class ChecksRepeatingCommand
implements CancellableRepeatingCommand {
    private static final int BLOCK_SIZE = 50;
    private boolean isCancelled = false;
    private int currentStartIndex = 0;
    private ArrayList<Check> checksToRun = new ArrayList();
    private ParameterizedCommand<Status> onStatus;
    private Command onCompletion;

    public ChecksRepeatingCommand(Set<Check> checksToRun, ParameterizedCommand<Status> onStatus, Command onCompletion) {
        this.checksToRun.addAll(checksToRun);
        this.onStatus = onStatus;
        this.onCompletion = onCompletion;
    }

    public boolean execute() {
        int endIndex = Math.min(this.checksToRun.size(), this.currentStartIndex + 50);
        this.informAboutStatus(endIndex);
        for (int index = this.currentStartIndex; index < endIndex; ++index) {
            if (this.isCancelled()) {
                return false;
            }
            if (this.isCancelled()) {
                return false;
            }
            this.checksToRun.get(index).check();
        }
        this.currentStartIndex += 50;
        if (endIndex > this.checksToRun.size() - 1) {
            this.complete();
            return false;
        }
        return true;
    }

    private void informAboutStatus(int endIndex) {
        if (this.onStatus != null) {
            this.onStatus.execute((Object)new Status(this.currentStartIndex, endIndex, this.checksToRun.size()));
        }
    }

    private boolean isCancelled() {
        if (this.isCancelled) {
            this.complete();
        }
        return this.isCancelled;
    }

    private void complete() {
        if (this.onCompletion != null) {
            this.onCompletion.execute();
        }
        this.checksToRun.clear();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }
}

