/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiSet;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;

public class PairChecks {
    private final MultiSet<RuleInspector, PairCheck> pairChecks = new MultiSet();
    private final Map<RuleInspector, MultiSet<RuleInspector, PairCheck>> pairChecksByOtherRowInspector = new HashMap<RuleInspector, MultiSet<RuleInspector, PairCheck>>();

    public void add(PairCheck pairCheck) {
        this.pairChecks.put(pairCheck.getRuleInspector(), pairCheck);
        this.addByOther(pairCheck);
    }

    private void addByOther(PairCheck pairCheck) {
        MultiSet<RuleInspector, PairCheck> multiSet = this.getByOther(pairCheck.getOther());
        Collection<PairCheck> collection = multiSet.get(pairCheck.getRuleInspector());
        if (collection == null) {
            multiSet.put(pairCheck.getRuleInspector(), pairCheck);
        } else {
            collection.add(pairCheck);
        }
    }

    private MultiSet<RuleInspector, PairCheck> getByOther(RuleInspector other) {
        MultiSet<RuleInspector, PairCheck> multiSet = this.pairChecksByOtherRowInspector.get(other);
        if (multiSet == null) {
            MultiSet<RuleInspector, PairCheck> result = new MultiSet<RuleInspector, PairCheck>();
            this.pairChecksByOtherRowInspector.put(other, result);
            return result;
        }
        return multiSet;
    }

    public Collection<PairCheck> remove(RuleInspector ruleInspector) {
        HashSet<PairCheck> result = new HashSet<PairCheck>();
        Collection<PairCheck> removedPairChecks = this.pairChecks.remove(ruleInspector);
        if (removedPairChecks != null) {
            result.addAll(removedPairChecks);
        }
        result.addAll(this.removeByOther(ruleInspector));
        return result;
    }

    private List<PairCheck> removeByOther(RuleInspector ruleInspector) {
        MultiSet<RuleInspector, PairCheck> removedMap = this.pairChecksByOtherRowInspector.remove(ruleInspector);
        if (removedMap != null) {
            for (RuleInspector inspector : removedMap.keys()) {
                Collection<PairCheck> collection = removedMap.get(inspector);
                this.pairChecks.get(inspector).removeAll(collection);
                this.getByOther(inspector).remove(ruleInspector);
            }
            return removedMap.allValues();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<PairCheck> get(RuleInspector ruleInspector) {
        Collection<PairCheck> pairChecks = this.pairChecks.get(ruleInspector);
        MultiSet<RuleInspector, PairCheck> multiSet = this.getByOther(ruleInspector);
        HashSet<PairCheck> result = new HashSet<PairCheck>();
        if (pairChecks != null) {
            result.addAll(pairChecks);
        }
        result.addAll(multiSet.allValues());
        return result;
    }

    public void remove(Collection<PairCheck> checks) {
        for (PairCheck check : checks) {
            this.get(check.getOther()).remove(check);
        }
    }
}

