/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasIndex;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.BRLAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.RetractAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Utils;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class ActionBuilder {
    private final Index index;
    private final GuidedDecisionTable52 model;
    private final Rule rule;
    private final List<DTCellValue52> row;
    private final ColumnUtilities utils;
    private final ActionCol52 actionCol;

    public ActionBuilder(Index index, GuidedDecisionTable52 model, Rule rule, List<DTCellValue52> row, ColumnUtilities utils, ActionCol52 actionCol) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"index", (Object)model);
        this.rule = (Rule)PortablePreconditions.checkNotNull((String)"rule", (Object)rule);
        this.row = (List)PortablePreconditions.checkNotNull((String)"row", row);
        this.utils = (ColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.actionCol = (ActionCol52)PortablePreconditions.checkNotNull((String)"actionCol", (Object)actionCol);
    }

    public void build() {
        if (this.actionCol instanceof BRLActionColumn) {
            this.addBRLAction((BRLActionColumn)this.actionCol);
        } else if (this.actionCol instanceof ActionRetractFactCol52) {
            this.addRetractAction((ActionRetractFactCol52)this.actionCol);
        } else {
            int columnIndex = this.model.getExpandedColumns().indexOf(this.actionCol);
            if (Utils.rowHasIndex(columnIndex, this.row)) {
                this.addAction(this.actionCol, this.row.get(columnIndex));
            }
        }
    }

    private void addRetractAction(ActionRetractFactCol52 actionCol) {
        int columnIndex = this.model.getExpandedColumns().indexOf(actionCol);
        this.rule.getActions().add(new RetractAction(this.getColumn((ActionCol52)actionCol), this.getValues(this.row.get(columnIndex))));
    }

    private void addBRLAction(BRLActionColumn brlActionColumn) {
        for (BRLActionVariableColumn brlActionVariableColumn : brlActionColumn.getChildColumns()) {
            int columnIndex = this.model.getExpandedColumns().indexOf(brlActionVariableColumn);
            this.rule.getActions().add(new BRLAction(this.getColumn((ActionCol52)brlActionVariableColumn), this.getValues(this.row.get(columnIndex))));
        }
    }

    private void addAction(ActionCol52 actionCol, DTCellValue52 visibleCellValue) {
        Field field = this.resolveField(actionCol);
        if (field != null) {
            Action action = this.buildAction(field, visibleCellValue);
            field.getActions().add(action);
            this.rule.getActions().add(action);
        }
    }

    private Field resolveField(ActionCol52 actionCol) {
        if (actionCol instanceof ActionSetFieldCol52) {
            Pattern pattern = (Pattern)this.rule.getPatterns().where(Pattern.boundName().is((Comparable)((Object)((ActionSetFieldCol52)actionCol).getBoundName()))).select().first();
            if (pattern == null) {
                return null;
            }
            return this.getField(pattern.getBoundName(), pattern.getName(), ((ActionSetFieldCol52)actionCol).getType(), ((ActionSetFieldCol52)actionCol).getFactField());
        }
        if (actionCol instanceof ActionInsertFactCol52) {
            return this.getField(((ActionInsertFactCol52)actionCol).getBoundName(), ((ActionInsertFactCol52)actionCol).getFactType(), ((ActionInsertFactCol52)actionCol).getType(), ((ActionInsertFactCol52)actionCol).getFactField());
        }
        return null;
    }

    private Field getField(String boundName, String factType, String fieldType, String factField) {
        return Utils.resolveField(Utils.resolvePattern(this.index, this.rule, boundName, factType), fieldType, factField);
    }

    private Action buildAction(Field field, DTCellValue52 visibleCellValue) {
        return new FieldAction(field, this.getColumn(this.actionCol), visibleCellValue.getDataType(), this.getValues(visibleCellValue));
    }

    private Values getValues(DTCellValue52 visibleCellValue) {
        Comparable value = ActionBuilder.getValue(Utils.getRealCellValue((DTColumnConfig52)this.actionCol, visibleCellValue));
        if (value == null) {
            return new Values();
        }
        return new Values(value);
    }

    private Column getColumn(ActionCol52 actionCol52) {
        return (Column)this.index.columns.where(HasIndex.index().is(Integer.valueOf(this.model.getExpandedColumns().indexOf(actionCol52)))).select().first();
    }

    public static Comparable getValue(DTCellValue52 dtCellValue52) {
        switch (dtCellValue52.getDataType()) {
            case NUMERIC_BIGDECIMAL: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigDecimal(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BIGINTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigInteger(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BYTE: {
                return new Byte(dtCellValue52.getStringValue());
            }
            case NUMERIC_DOUBLE: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Double(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_FLOAT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Float(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_INTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Integer(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_LONG: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Long(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_SHORT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Short(dtCellValue52.getNumericValue().toString());
            }
            case DATE: {
                return dtCellValue52.getDateValue();
            }
            case BOOLEAN: {
                return dtCellValue52.getBooleanValue();
            }
        }
        String stringValue = dtCellValue52.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }
}

