/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ActionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.BRLConditionsBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldConditionsBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Utils;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class CellBuilder {
    private final Index index;
    private final GuidedDecisionTable52 model;
    private final int columnIndex;
    private final ColumnUtilities utils;
    private final BaseColumn baseColumn;

    public CellBuilder(Index index, GuidedDecisionTable52 model, int columnIndex, ColumnUtilities utils, BaseColumn baseColumn) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.columnIndex = (Integer)PortablePreconditions.checkNotNull((String)"columnIndex", (Object)columnIndex);
        this.utils = (ColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.baseColumn = (BaseColumn)PortablePreconditions.checkNotNull((String)"baseColumn", (Object)baseColumn);
    }

    public void build(Rule rule, List<DTCellValue52> row) {
        if (this.baseColumn instanceof ActionCol52) {
            new ActionBuilder(this.index, this.model, rule, row, this.utils, (ActionCol52)this.baseColumn).build();
        } else if (this.baseColumn instanceof ConditionCol52) {
            if (this.baseColumn instanceof BRLConditionVariableColumn) {
                new BRLConditionsBuilder(this.index, this.model, rule, row, this.utils).buildCondition((BRLConditionVariableColumn)this.baseColumn, this.columnIndex);
            } else {
                new FieldConditionsBuilder(this.index, this.model, rule, row, this.utils, this.getPattern(rule)).buildCondition((ConditionCol52)this.baseColumn, this.columnIndex);
            }
        }
    }

    private Pattern getPattern(Rule rule) {
        return Utils.resolvePattern(this.index, rule, this.model.getPattern((ConditionCol52)this.baseColumn));
    }
}

