/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasIndex;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldConditionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Utils;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class FieldConditionsBuilder {
    private final Index index;
    private final GuidedDecisionTable52 model;
    private final ColumnUtilities utils;
    private final List<DTCellValue52> row;
    private final Pattern pattern;
    private final Rule rule;

    public FieldConditionsBuilder(Index index, GuidedDecisionTable52 model, Rule rule, List<DTCellValue52> row, ColumnUtilities utils, Pattern pattern) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.rule = (Rule)PortablePreconditions.checkNotNull((String)"rule", (Object)rule);
        this.utils = (ColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.row = (List)PortablePreconditions.checkNotNull((String)"row", row);
        this.pattern = (Pattern)PortablePreconditions.checkNotNull((String)"pattern", (Object)pattern);
    }

    public void buildConditions(List<ConditionCol52> childColumns) {
        for (ConditionCol52 conditionCol52 : childColumns) {
            this.buildCondition(conditionCol52, this.model.getExpandedColumns().indexOf(conditionCol52));
        }
    }

    public void buildCondition(ConditionCol52 conditionCol52, int columnIndex) {
        if (Utils.rowHasIndex(columnIndex, this.row)) {
            Field field = this.resolveField(conditionCol52);
            Condition condition = this.buildCondition(field, conditionCol52, this.row.get(columnIndex));
            field.getConditions().add(condition);
            this.rule.getConditions().add(condition);
        }
    }

    private Field resolveField(ConditionCol52 conditionCol52) {
        return Utils.resolveField(this.pattern, conditionCol52.getFieldType(), conditionCol52.getFactField());
    }

    private Condition buildCondition(Field field, ConditionCol52 conditionColumn, DTCellValue52 visibleCellValue) {
        Column column = (Column)this.index.columns.where(HasIndex.index().is(Integer.valueOf(this.model.getExpandedColumns().indexOf(conditionColumn)))).select().first();
        return new FieldConditionBuilder(field, this.utils, column, conditionColumn, Utils.getRealCellValue((DTColumnConfig52)conditionColumn, visibleCellValue)).build();
    }
}

