/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectFields;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Where;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Listen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Select;

public class ObjectTypes {
    public final KeyTreeMap<ObjectType> typesMap = new KeyTreeMap(ObjectType.keyDefinitions());

    public ObjectTypes(Collection<ObjectType> typesMap) {
        for (ObjectType objectType : typesMap) {
            this.add(objectType);
        }
    }

    public ObjectTypes(ObjectType[] typesMap) {
        this(Arrays.asList(typesMap));
    }

    public ObjectTypes() {
    }

    public void merge(ObjectTypes patterns) {
        this.typesMap.merge(patterns.typesMap);
    }

    public Where<ObjectTypesSelect, ObjectTypesListen> where(final Matcher matcher) {
        return new Where<ObjectTypesSelect, ObjectTypesListen>(){

            @Override
            public ObjectTypesSelect select() {
                return new ObjectTypesSelect(matcher);
            }

            @Override
            public ObjectTypesListen listen() {
                return new ObjectTypesListen(matcher);
            }
        };
    }

    void add(ObjectType ... objectTypes) {
        for (ObjectType objectType : objectTypes) {
            this.typesMap.put(objectType);
        }
    }

    public class ObjectTypesListen
    extends Listen<ObjectType> {
        public ObjectTypesListen(Matcher matcher) {
            super(ObjectTypes.this.typesMap.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ObjectTypesSelect
    extends Select<ObjectType> {
        public ObjectTypesSelect(Matcher matcher) {
            super(ObjectTypes.this.typesMap.get(matcher.getKeyDefinition()), matcher);
        }

        public ObjectFields fields() {
            ObjectFields fields = new ObjectFields();
            MultiMap subMap = this.asMap();
            if (subMap != null) {
                Collection objectTypes = subMap.allValues();
                for (ObjectType objectType : objectTypes) {
                    fields.merge(objectType.getFields());
                }
            }
            return fields;
        }
    }
}

