/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Fields;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Where;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Listen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Select;

public class Patterns {
    public final KeyTreeMap<Pattern> patternsMap = new KeyTreeMap(Pattern.keyDefinitions());

    public Patterns(Collection<Pattern> patternsMap) {
        for (Pattern pattern : patternsMap) {
            this.add(pattern);
        }
    }

    public Patterns(Pattern[] patternsMap) {
        this(Arrays.asList(patternsMap));
    }

    public Patterns() {
    }

    public void merge(Patterns patterns) {
        this.patternsMap.merge(patterns.patternsMap);
    }

    public Where<PatternsSelect, PatternsListen> where(final Matcher matcher) {
        return new Where<PatternsSelect, PatternsListen>(){

            @Override
            public PatternsSelect select() {
                return new PatternsSelect(matcher);
            }

            @Override
            public PatternsListen listen() {
                return new PatternsListen(matcher);
            }
        };
    }

    void add(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            this.patternsMap.put(pattern);
        }
    }

    public class PatternsListen
    extends Listen<Pattern> {
        public PatternsListen(Matcher matcher) {
            super(Patterns.this.patternsMap.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class PatternsSelect
    extends Select<Pattern> {
        public PatternsSelect(Matcher matcher) {
            super(Patterns.this.patternsMap.get(matcher.getKeyDefinition()), matcher);
        }

        public Fields fields() {
            Fields fields = new Fields();
            MultiMap subMap = this.asMap();
            if (subMap != null) {
                Collection patterns = subMap.allValues();
                for (Pattern pattern : patterns) {
                    fields.merge(pattern.getFields());
                }
            }
            return fields;
        }
    }
}

