/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ActionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.BRLConditionsBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldConditionsBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Utils;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class RuleBuilder {
    private final Index index;
    private final GuidedDecisionTable52 model;
    private final List<DTCellValue52> row;
    private final ColumnUtilities utils;
    private final Rule rule;

    public RuleBuilder(Index index, GuidedDecisionTable52 model, Integer rowIndex, List<DTCellValue52> row, ColumnUtilities utils) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.row = (List)PortablePreconditions.checkNotNull((String)"row", row);
        this.utils = (ColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.rule = new Rule((Integer)PortablePreconditions.checkNotNull((String)"rowIndex", (Object)rowIndex));
    }

    public Rule build() {
        this.resolvePatterns();
        return this.rule;
    }

    private void resolvePatterns() {
        for (CompositeColumn column : this.model.getConditions()) {
            if (column instanceof Pattern52) {
                Pattern52 pattern52 = (Pattern52)column;
                Pattern pattern = Utils.resolvePattern(this.index, this.rule, pattern52);
                new FieldConditionsBuilder(this.index, this.model, this.rule, this.row, this.utils, pattern).buildConditions(((Pattern52)column).getChildColumns());
                continue;
            }
            if (!(column instanceof BRLConditionColumn)) continue;
            new BRLConditionsBuilder(this.index, this.model, this.rule, this.row, this.utils).buildConditions(((BRLConditionColumn)column).getChildColumns());
        }
        for (ActionCol52 actionCol52 : this.model.getActionCols()) {
            new ActionBuilder(this.index, this.model, this.rule, this.row, this.utils, actionCol52).build();
        }
    }
}

