/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.IndexedKeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Patterns;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Where;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Listen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Select;

public class Rules {
    public final IndexedKeyTreeMap<Rule> map = new IndexedKeyTreeMap(Rule.keyDefinitions());

    public Rules() {
    }

    public Rules(Collection<Rule> rules) {
        for (Rule rule : rules) {
            this.add(rule);
        }
    }

    public Where<RulesSelect, RulesListen> where(final Matcher matcher) {
        return new Where<RulesSelect, RulesListen>(){

            @Override
            public RulesSelect select() {
                return new RulesSelect(matcher);
            }

            @Override
            public RulesListen listen() {
                return new RulesListen(matcher);
            }
        };
    }

    public void merge(Rules rules) {
        this.map.merge(rules.map);
    }

    public void add(Rule rule) {
        this.map.put(rule, rule.getIndex());
    }

    public void remove(Rule rule) {
        rule.getUuidKey().retract();
    }

    public class RulesListen
    extends Listen<Rule> {
        public RulesListen(Matcher matcher) {
            super(Rules.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class RulesSelect
    extends Select<Rule> {
        public RulesSelect(Matcher matcher) {
            super(Rules.this.map.get(matcher.getKeyDefinition()), matcher);
        }

        public Patterns patterns() {
            Collection rules = this.all();
            Patterns patterns = new Patterns();
            for (Rule rule : rules) {
                patterns.merge(rule.getPatterns());
            }
            return patterns;
        }
    }
}

