/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.PatternBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;

public class Utils {
    public static Pattern resolvePattern(Index index, Rule rule, Pattern52 pattern52) {
        Pattern pattern = (Pattern)rule.getPatterns().where(Pattern.boundName().is((Comparable)((Object)pattern52.getBoundName()))).select().first();
        if (pattern == null) {
            return new PatternBuilder(index, rule, pattern52).build();
        }
        return pattern;
    }

    public static Pattern resolvePattern(Index index, Rule rule, String boundName, String factType) {
        Pattern first = Utils.getFirstPattern(rule, boundName, factType);
        if (first == null) {
            Pattern pattern = new Pattern(boundName, Utils.resolveObjectType(index, factType));
            rule.getPatterns().add(pattern);
            return pattern;
        }
        return first;
    }

    private static Pattern getFirstPattern(Rule rule, String boundName, String factType) {
        if (boundName != null) {
            return (Pattern)rule.getPatterns().where(Pattern.boundName().is((Comparable)((Object)boundName))).select().first();
        }
        return (Pattern)rule.getPatterns().where(Pattern.name().is((Comparable)((Object)factType))).select().first();
    }

    public static ObjectType resolveObjectType(Index index, String factType) {
        ObjectType first = (ObjectType)index.objectTypes.where(ObjectType.type().is((Comparable)((Object)factType))).select().first();
        if (first == null) {
            ObjectType objectType = new ObjectType(factType);
            index.objectTypes.add(objectType);
            return objectType;
        }
        return first;
    }

    public static ObjectField resolveObjectField(ObjectType objectType, String fieldType, String factField) {
        ObjectField first = (ObjectField)objectType.getFields().where(Field.name().is((Comparable)((Object)factField))).select().first();
        if (first == null) {
            ObjectField objectField = new ObjectField(objectType.getType(), fieldType, factField);
            objectType.getFields().add(objectField);
            return objectField;
        }
        return first;
    }

    public static Field resolveField(Pattern pattern, String fieldType, String factField) {
        Field first = (Field)pattern.getFields().where(Field.name().is((Comparable)((Object)factField))).select().first();
        if (first == null) {
            Field field = new Field(Utils.resolveObjectField(pattern.getObjectType(), fieldType, factField), pattern.getName(), fieldType, factField);
            pattern.getFields().add(field);
            return field;
        }
        return first;
    }

    public static boolean rowHasIndex(int columnIndex, List<DTCellValue52> row) {
        return columnIndex > 0 && columnIndex < row.size();
    }

    public static DTCellValue52 getRealCellValue(DTColumnConfig52 config52, DTCellValue52 visibleCellValue) {
        if (config52 instanceof LimitedEntryCol) {
            return ((LimitedEntryCol)config52).getValue();
        }
        return visibleCellValue;
    }

    public static boolean isCellNotBlank(DTColumnConfig52 config52, DTCellValue52 visibleCellValue) {
        if (config52 instanceof LimitedEntryCol) {
            return visibleCellValue.getBooleanValue();
        }
        return visibleCellValue.hasValue();
    }
}

