/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;

public class ValuesResolver {
    private final ColumnUtilities utils;
    private final ConditionCol52 conditionColumn;
    private final DTCellValue52 realCellValue;

    public ValuesResolver(ColumnUtilities utils, ConditionCol52 conditionColumn, DTCellValue52 realCellValue) {
        this.utils = utils;
        this.conditionColumn = conditionColumn;
        this.realCellValue = realCellValue;
    }

    public Values getValues() {
        String type = this.utils.getType((BaseColumn)this.conditionColumn);
        if (this.isTypeGuvnorEnum(this.conditionColumn)) {
            return this.getStringValue();
        }
        if (type == null) {
            return this.getStringValue();
        }
        if (type.equals("String")) {
            return this.getStringValue();
        }
        if (type.equals("Numeric") || type.equals("BigDecimal")) {
            return this.getBigDecimalValue();
        }
        if (type.equals("BigInteger")) {
            return this.getBigIntegerValue();
        }
        if (type.equals("Byte")) {
            return this.getNumericValue();
        }
        if (type.equals("Double")) {
            return this.getDoubleValue();
        }
        if (type.equals("Float")) {
            return this.getNumericValue();
        }
        if (type.equals("Integer")) {
            return this.getIntegerValue();
        }
        if (type.equals("Long")) {
            return this.getLongValue();
        }
        if (type.equals("Short")) {
            return this.getShortValue();
        }
        if (type.equals("Boolean")) {
            return this.getBooleanValue();
        }
        if (type.equals("Date")) {
            return this.getDateValue();
        }
        if (type.equals("Comparable")) {
            return this.getStringValue();
        }
        return this.getStringValue();
    }

    private Values<Boolean> getBooleanValue() {
        Boolean booleanValue = this.realCellValue.getBooleanValue();
        if (booleanValue != null) {
            return new Values<Boolean>(booleanValue);
        }
        return new Values<Boolean>();
    }

    private Values<Date> getDateValue() {
        Date date = this.realCellValue.getDateValue();
        if (date != null) {
            return new Values<Date>(date);
        }
        return new Values<Date>();
    }

    private Values getNumericValue() {
        if (this.realCellValue.getNumericValue() != null) {
            return new Values((Comparable)((Object)this.realCellValue.getNumericValue()));
        }
        return new Values();
    }

    private Values<String> getStringValue() {
        String stringValue = this.realCellValue.getStringValue();
        if (stringValue != null && !stringValue.isEmpty()) {
            if (this.conditionColumn.getOperator() != null && (this.conditionColumn.getOperator().equals("in") || this.conditionColumn.getOperator().equals("not in"))) {
                Values<String> values = new Values<String>();
                for (String item : stringValue.split(",")) {
                    values.add(item.trim());
                }
                return values;
            }
            return new Values<String>(new Comparable[]{stringValue});
        }
        return new Values<String>();
    }

    private Values<Short> getShortValue() {
        Short aShort = this.getShort();
        if (aShort != null) {
            return new Values<Short>(aShort);
        }
        return new Values<Short>();
    }

    private Short getShort() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Short)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Short(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Long> getLongValue() {
        Long aLong = this.getLong();
        if (aLong != null) {
            return new Values<Long>(aLong);
        }
        return new Values<Long>();
    }

    private Long getLong() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Long)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Long(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Double> getDoubleValue() {
        Double aDouble = this.getDouble();
        if (aDouble != null) {
            return new Values<Double>(aDouble);
        }
        return new Values<Double>();
    }

    private Double getDouble() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Double)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Double(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<BigInteger> getBigIntegerValue() {
        BigInteger bigInteger = this.getBigInteger();
        if (bigInteger != null) {
            return new Values<BigInteger>(bigInteger);
        }
        return new Values<BigInteger>();
    }

    private BigInteger getBigInteger() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigInteger)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new BigInteger(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<BigDecimal> getBigDecimalValue() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal != null) {
            return new Values<BigDecimal>(bigDecimal);
        }
        return new Values<BigDecimal>();
    }

    private BigDecimal getBigDecimal() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigDecimal)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Integer> getIntegerValue() {
        Integer integer = this.getInteger();
        if (integer != null) {
            return new Values<Integer>(new Comparable[]{integer});
        }
        return new Values<Integer>();
    }

    private Integer getInteger() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Integer)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Integer(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private boolean isTypeGuvnorEnum(ConditionCol52 conditionColumn) {
        return this.utils.getValueList((BaseColumn)conditionColumn).length != 0;
    }
}

