/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMapChangeHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Select;

class ChangeHelper<T> {
    private final Select<T> addedSelector;
    private final Select<T> removedSelector;

    ChangeHelper(MultiMapChangeHandler.ChangeSet<Value, T> changeSet, Matcher matcher) {
        this.addedSelector = new Select<T>(changeSet.getAdded(), matcher);
        this.removedSelector = new Select<T>(changeSet.getRemoved(), matcher);
    }

    boolean firstChanged(Select.Entry first) {
        if (this.containsEntry(this.removedSelector, first)) {
            return true;
        }
        if (this.addedSelector.exists()) {
            return first.getKey().compareTo(this.addedSelector.firstEntry().getKey()) > 0;
        }
        return false;
    }

    private boolean containsEntry(Select<T> select, Select.Entry entry) {
        return select.asMap().keySet().contains(entry.getKey()) && select.all().contains(entry.getValue());
    }

    boolean lastChanged(Select.Entry last) {
        if (this.containsEntry(this.removedSelector, last)) {
            return true;
        }
        if (this.addedSelector.exists()) {
            return last.getKey().compareTo(this.addedSelector.lastEntry().getKey()) < 0;
        }
        return false;
    }
}

