/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.workbench.AnalysisReportScreen", preferredWidth=360)
public class AnalysisReportScreen {
    public static final String IDENTIFIER = "org.drools.workbench.AnalysisReportScreen";
    private AnalysisReportScreenView view;
    private PlaceManager placeManager;
    private final ListDataProvider<Issue> dataProvider = new ListDataProvider();
    private AnalysisReport currentReport;

    public AnalysisReportScreen() {
    }

    @Inject
    public AnalysisReportScreen(AnalysisReportScreenView view, PlaceManager placeManager) {
        this.view = view;
        this.placeManager = placeManager;
        view.setPresenter(this);
        view.setUpDataProvider(this.dataProvider);
    }

    public void onDTableClose(@Observes ClosePlaceEvent event) {
        if (this.currentReport != null && event.getPlace().equals(this.currentReport.getPlace())) {
            this.placeManager.closePlace(IDENTIFIER);
        }
    }

    public void showReport(AnalysisReport report) {
        this.view.showStatusComplete();
        this.currentReport = report;
        if (!report.getAnalysisData().isEmpty()) {
            this.placeManager.goTo(IDENTIFIER);
        } else {
            this.placeManager.closePlace(IDENTIFIER);
        }
        this.dataProvider.setList(this.getIssues(report));
        if (this.dataProvider.getList().isEmpty()) {
            this.view.clearIssue();
        } else {
            this.view.showIssue((Issue)this.dataProvider.getList().get(0));
        }
    }

    private ArrayList<Issue> getIssues(AnalysisReport report) {
        TreeSet<Issue> issues = new TreeSet<Issue>(new Comparator<Issue>(){

            @Override
            public int compare(Issue issue, Issue other) {
                int compareToSeverity = issue.getSeverity().compareTo(other.getSeverity());
                if (compareToSeverity == 0) {
                    int compareToTitle = issue.getTitle().compareTo(other.getTitle());
                    if (compareToTitle == 0) {
                        return this.compareRowNumbers(issue.getRowNumbers(), other.getRowNumbers());
                    }
                    return compareToTitle;
                }
                return compareToSeverity;
            }

            private int compareRowNumbers(Set<Integer> rowNumbers, Set<Integer> other) {
                if (rowNumbers.equals(other)) {
                    return 0;
                }
                for (Integer a : rowNumbers) {
                    for (Integer b : other) {
                        if (a >= b) continue;
                        return -1;
                    }
                }
                return 1;
            }
        });
        for (Issue issue : report.getAnalysisData()) {
            issues.add(issue);
        }
        return new ArrayList<Issue>(issues);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.Analysis();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void onSelect(Issue issue) {
        this.view.showIssue(issue);
    }

    public void showStatus(Status status) {
        this.view.showStatusTitle(status.getStart(), status.getEnd(), status.getTotalCheckCount());
    }
}

