/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenterView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;

public class IssuePresenter
implements IsWidget {
    private IssuePresenterView view;

    @Inject
    public IssuePresenter(IssuePresenterView view) {
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(Issue issue) {
        if (issue.getTitle() == null) {
            this.view.setIssueTitle(issue.getTitle());
        } else {
            this.view.setIssueTitle(issue.getTitle());
        }
        this.view.setExplanation(issue.getExplanationHTML());
        this.view.setLines(this.makeRowNumbers(issue));
    }

    private String makeRowNumbers(Issue issue) {
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iterator = issue.getRowNumbers().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public void clear() {
        this.view.setIssueTitle("");
        this.view.setExplanation(new SafeHtml(){

            public String asString() {
                return "";
            }
        });
        this.view.setLines("");
        this.view.hideLines();
    }
}

