/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.auditlog;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntryCellHelper;

public class AuditLogEntryCell
extends AbstractCell<AuditLogEntry> {
    private static final Template TEMPLATE = (Template)GWT.create(Template.class);
    private final DateTimeFormat format;
    private final AuditLogEntryCellHelper helper;

    public AuditLogEntryCell(DateTimeFormat format) {
        super(new String[0]);
        this.helper = new AuditLogEntryCellHelper(format);
        this.format = format;
    }

    public AuditLogEntryCell(DateTimeFormat format, String labelClass, String valueClass) {
        super(new String[0]);
        this.helper = new AuditLogEntryCellHelper(format, labelClass, valueClass);
        this.format = format;
    }

    public void render(Cell.Context context, AuditLogEntry value, SafeHtmlBuilder sb) {
        if (value == null) {
            return;
        }
        String eventTypeDisplayText = AuditLogEntryCellHelper.getEventTypeDisplayText(value.getGenericType());
        String whenWhoDisplayText = GuidedDecisionTableConstants.INSTANCE.AuditLogEntryOn1(this.format.format(value.getDateOfEntry()), value.getUserName());
        sb.append(TEMPLATE.entrySummary(eventTypeDisplayText, whenWhoDisplayText));
        sb.append(this.helper.getSafeHtml(value));
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div class=\"auditLogSummary\"><b>{0}</b></div><div class=\"auditLogDetailValue\">{1}</div>")
        public SafeHtml entrySummary(String var1, String var2);
    }
}

