/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveHandler;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerContextMenuSupport;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOver;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOverHandler;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationClearCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationEditCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectBottomRightCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectTopLeftCell;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@Dependent
public class GuidedDecisionTableModellerPresenter
implements GuidedDecisionTableModellerView.Presenter {
    private final GuidedDecisionTableModellerView view;
    private final ManagedInstance<GuidedDecisionTableView.Presenter> dtPresenterProvider;
    private final Event<RadarMenuBuilder.UpdateRadarEvent> updateRadarEvent;
    private final Event<DecisionTablePinnedEvent> pinnedEvent;
    private final ColumnHeaderPopOver columnHeaderPopOver;
    private GuidedDecisionTableView.Presenter activeDecisionTable = null;
    private Set<GuidedDecisionTableView.Presenter> availableDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>();
    private Set<HandlerRegistration> handlerRegistrations = new HashSet<HandlerRegistration>();

    @Inject
    public GuidedDecisionTableModellerPresenter(GuidedDecisionTableModellerView view, ManagedInstance<GuidedDecisionTableView.Presenter> dtPresenterProvider, GuidedDecisionTableModellerContextMenuSupport contextMenuSupport, Event<RadarMenuBuilder.UpdateRadarEvent> updateRadarEvent, Event<DecisionTablePinnedEvent> pinnedEvent, ColumnHeaderPopOver columnHeaderPopOver) {
        this.view = view;
        this.dtPresenterProvider = dtPresenterProvider;
        this.updateRadarEvent = updateRadarEvent;
        this.pinnedEvent = pinnedEvent;
        this.columnHeaderPopOver = columnHeaderPopOver;
        this.view.init(this);
        this.handlerRegistrations.add(view.getGridLayerView().addNodeMouseMoveHandler((NodeMouseMoveHandler)new ColumnHeaderPopOverHandler(this, columnHeaderPopOver)));
        this.handlerRegistrations.add(view.getGridLayerView().addNodeMouseOutHandler(e -> columnHeaderPopOver.hide()));
        GridLayer layer = view.getGridLayerView();
        BaseGridWidgetKeyboardHandler handler = new BaseGridWidgetKeyboardHandler(layer);
        handler.addOperation(new KeyboardOperation[]{new KeyboardOperationClearCell(layer){

            protected void clearCells(GridWidget gridWidget) {
                GuidedDecisionTableModellerPresenter.this.getActiveDecisionTable().onDeleteSelectedCells();
            }
        }, new KeyboardOperationEditCell(layer), new KeyboardOperationMoveLeft(layer), new KeyboardOperationMoveRight(layer), new KeyboardOperationMoveUp(layer), new KeyboardOperationMoveDown(layer), new KeyboardOperationSelectTopLeftCell(layer), new KeyboardOperationSelectBottomRightCell(layer)});
        this.handlerRegistrations.add(view.addKeyDownHandler((KeyDownHandler)handler));
        this.handlerRegistrations.add(view.addContextMenuHandler(contextMenuSupport.getContextMenuHandler(this)));
        this.handlerRegistrations.add(view.addMouseDownHandler(contextMenuSupport.getContextMenuMouseDownHandler()));
    }

    @Override
    @PreDestroy
    public void onClose() {
        this.view.clear();
        this.releaseDecisionTables();
        this.releaseHandlerRegistrations();
    }

    void releaseDecisionTables() {
        for (GuidedDecisionTableView.Presenter dtPresenter : this.availableDecisionTables) {
            dtPresenter.onClose();
        }
        this.availableDecisionTables.clear();
    }

    void releaseHandlerRegistrations() {
        for (HandlerRegistration registration : this.handlerRegistrations) {
            registration.removeHandler();
        }
        this.handlerRegistrations.clear();
    }

    @Override
    public GuidedDecisionTableView.Presenter addDecisionTable(ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly) {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)this.dtPresenterProvider.get();
        dtPresenter.setContent(path, placeRequest, content, this, isReadOnly);
        double x = this.getDecisionTableX(dtPresenter);
        double y = this.getDecisionTableY(dtPresenter);
        dtPresenter.getView().setLocation(x, y);
        this.availableDecisionTables.add(dtPresenter);
        this.updateLinks();
        this.view.addDecisionTable(dtPresenter.getView());
        return dtPresenter;
    }

    private double getDecisionTableX(GuidedDecisionTableView.Presenter dtPresenter) {
        Bounds bounds = this.getView().getBounds();
        double x = bounds.getX() + (bounds.getWidth() - dtPresenter.getView().getWidth()) / 2.0;
        return x;
    }

    private double getDecisionTableY(GuidedDecisionTableView.Presenter dtPresenter) {
        Bounds bounds = this.getView().getBounds();
        double y = bounds.getY() + bounds.getHeight() * 0.25;
        for (GuidedDecisionTableView.Presenter p : this.availableDecisionTables) {
            y = y + p.getView().getHeight() + 200.0;
        }
        return y;
    }

    @Override
    public GuidedDecisionTableView.Presenter refreshDecisionTable(GuidedDecisionTableView.Presenter dtPresenter, ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly) {
        Point2D oldLocation = dtPresenter.getView().getLocation();
        this.view.removeDecisionTable(dtPresenter.getView(), () -> {
            dtPresenter.refreshContent(path, placeRequest, content, isReadOnly);
            dtPresenter.getView().setLocation(oldLocation);
            this.view.addDecisionTable(dtPresenter.getView());
            this.doDecisionTableSelected(dtPresenter);
        });
        return dtPresenter;
    }

    @Override
    public void removeDecisionTable(GuidedDecisionTableView.Presenter dtPresenter) {
        Command afterRemovalCommand = () -> {
            this.view.setEnableColumnCreation(false);
            this.view.refreshAttributeWidget(Collections.emptyList());
            this.view.refreshMetaDataWidget(Collections.emptyList());
            this.view.refreshConditionsWidget(Collections.emptyList());
            this.view.refreshActionsWidget(Collections.emptyList());
            this.view.refreshColumnsNote(false);
            this.availableDecisionTables.remove(dtPresenter);
            if (dtPresenter.equals(this.activeDecisionTable)) {
                this.activeDecisionTable = null;
            }
            dtPresenter.onClose();
        };
        this.view.removeDecisionTable(dtPresenter.getView(), afterRemovalCommand);
    }

    @Override
    public void onLockStatusUpdated(GuidedDecisionTableView.Presenter dtPresenter) {
        if (dtPresenter == null) {
            return;
        }
        if (dtPresenter.equals(this.getActiveDecisionTable())) {
            this.refreshDefinitionsPanel(dtPresenter);
        }
    }

    @Override
    public GuidedDecisionTableView.Presenter getActiveDecisionTable() {
        return this.activeDecisionTable;
    }

    @Override
    public Set<GuidedDecisionTableView.Presenter> getAvailableDecisionTables() {
        return Collections.unmodifiableSet(this.availableDecisionTables);
    }

    @Override
    public boolean isDecisionTableAvailable(GuidedDecisionTableView.Presenter dtPresenter) {
        return this.availableDecisionTables.contains(dtPresenter);
    }

    @Override
    public boolean isActiveDecisionTableEditable() {
        GuidedDecisionTableView.Presenter dtPresenter = this.getActiveDecisionTable();
        if (dtPresenter == null) {
            return false;
        }
        return dtPresenter.getAccess().isEditable();
    }

    @Override
    public GuidedDecisionTableModellerView getView() {
        return this.view;
    }

    @Override
    public void setZoom(int zoom) {
        this.view.setZoom(zoom);
    }

    @Override
    public void onInsertColumn() {
        GuidedDecisionTableView.Presenter dtPresenter = this.getActiveDecisionTable();
        if (dtPresenter == null) {
            return;
        }
        this.view.onInsertColumn();
    }

    public void enterPinnedMode(GridWidget gridWidget, Command onStartCommand) {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().enterPinnedMode(gridWidget, onStartCommand);
    }

    public void exitPinnedMode(Command onCompleteCommand) {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().exitPinnedMode(onCompleteCommand);
    }

    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().updatePinnedContext(gridWidget);
    }

    public GridPinnedModeManager.PinnedContext getPinnedContext() {
        return this.view.getGridLayerView().getPinnedContext();
    }

    public boolean isGridPinned() {
        return this.view.getGridLayerView().isGridPinned();
    }

    public TransformMediator getDefaultTransformMediator() {
        return this.view.getGridLayerView().getDefaultTransformMediator();
    }

    @Override
    public void onDecisionTableSelected(@Observes DecisionTableSelectedEvent event) {
        GuidedDecisionTableView.Presenter dtPresenter = event.getPresenter();
        if (dtPresenter == null) {
            return;
        }
        if (!this.isDecisionTableAvailable(dtPresenter)) {
            return;
        }
        if (dtPresenter.equals(this.getActiveDecisionTable())) {
            return;
        }
        this.doDecisionTableSelected(dtPresenter);
    }

    private void doDecisionTableSelected(GuidedDecisionTableView.Presenter dtPresenter) {
        this.activeDecisionTable = dtPresenter;
        for (GuidedDecisionTableView.Presenter p : this.getAvailableDecisionTables()) {
            if (p.equals(dtPresenter)) {
                p.initialiseAnalysis();
                continue;
            }
            p.terminateAnalysis();
        }
        final GuidedDecisionTable52 model = dtPresenter.getModel();
        dtPresenter.getPackageParentRuleNames(new ParameterizedCommand<Collection<String>>(){

            public void execute(Collection<String> availableParentRuleNames) {
                GuidedDecisionTableModellerPresenter.this.view.refreshRuleInheritance(model.getParentName(), availableParentRuleNames);
            }
        });
        this.refreshDefinitionsPanel(dtPresenter);
        this.view.select(dtPresenter.getView());
    }

    void refreshDefinitionsPanel(GuidedDecisionTableView.Presenter dtPresenter) {
        GuidedDecisionTable52 model = dtPresenter.getModel();
        this.view.setEnableColumnCreation(dtPresenter.getAccess().isEditable());
        this.view.refreshAttributeWidget(model.getAttributeCols());
        this.view.refreshMetaDataWidget(model.getMetadataCols());
        this.view.refreshConditionsWidget(model.getConditions());
        this.view.refreshActionsWidget(model.getActionCols());
        this.view.refreshColumnsNote(dtPresenter.hasColumnDefinitions());
    }

    @Override
    public void onDecisionTableLinkedColumnSelected(@Observes DecisionTableColumnSelectedEvent event) {
        if (event.getColumn() == null) {
            return;
        }
        this.view.selectLinkedColumn(event.getColumn());
    }

    @Override
    public void onRefreshAttributesPanelEvent(@Observes RefreshAttributesPanelEvent event) {
        this.refreshPanel(event.getPresenter(), event.getColumns(), this.view::refreshAttributeWidget);
    }

    @Override
    public void onRefreshMetaDataPanelEvent(@Observes RefreshMetaDataPanelEvent event) {
        this.refreshPanel(event.getPresenter(), event.getColumns(), this.view::refreshMetaDataWidget);
    }

    @Override
    public void onRefreshConditionsPanelEvent(@Observes RefreshConditionsPanelEvent event) {
        this.refreshPanel(event.getPresenter(), event.getColumns(), this.view::refreshConditionsWidget);
    }

    @Override
    public void onRefreshActionsPanelEvent(@Observes RefreshActionsPanelEvent event) {
        this.refreshPanel(event.getPresenter(), event.getColumns(), this.view::refreshActionsWidget);
    }

    private <C> void refreshPanel(GuidedDecisionTableView.Presenter dtPresenter, List<C> columns, ParameterizedCommand<List<C>> command) {
        if (dtPresenter == null) {
            return;
        }
        if (!this.isDecisionTableAvailable(dtPresenter)) {
            return;
        }
        command.execute(columns);
    }

    @Override
    public void updateRadar() {
        this.updateRadarEvent.fire((Object)new RadarMenuBuilder.UpdateRadarEvent(this));
    }

    @Override
    public void onViewPinned(boolean isPinned) {
        this.pinnedEvent.fire((Object)new DecisionTablePinnedEvent(this, isPinned));
    }

    @Override
    public void updateLinks() {
        for (GuidedDecisionTableView.Presenter dtPresenter : this.getAvailableDecisionTables()) {
            dtPresenter.link(this.getAvailableDecisionTables());
        }
        this.getView().getGridLayerView().refreshGridWidgetConnectors();
    }
}

