/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class AttributeColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        AttributeCol52 column = (AttributeCol52)metaData.getColumn();
        this.model.getAttributeCols().add(column);
        this.synchroniseAppendColumn((BaseColumn)column);
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof AttributeCol52;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) {
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        AttributeCol52 originalColumn = (AttributeCol52)originalMetaData.getColumn();
        AttributeCol52 editedColumn = (AttributeCol52)editedMetaData.getColumn();
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        this.update(originalColumn, editedColumn);
        boolean isAttributeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"attribute", (List)diffs);
        boolean isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        if (isAttributeUpdated) {
            this.clearColumnData((BaseColumn)originalColumn);
        }
        this.synchroniseUpdateColumn((BaseColumn)originalColumn);
        if (isAttributeUpdated) {
            this.setColumnHeader((BaseColumn)originalColumn, originalColumn.getAttribute());
        }
        if (isHideUpdated) {
            this.setColumnVisibility((BaseColumn)originalColumn, originalColumn.isHideColumn());
        }
        return diffs;
    }

    private void update(AttributeCol52 originalColumn, AttributeCol52 editedColumn) {
        originalColumn.setAttribute(editedColumn.getAttribute());
        originalColumn.setReverseOrder(editedColumn.isReverseOrder());
        originalColumn.setUseRowNumber(editedColumn.isUseRowNumber());
        originalColumn.setHideColumn(editedColumn.isHideColumn());
        originalColumn.setHeader(editedColumn.getHeader());
        originalColumn.setDefaultValue(editedColumn.getDefaultValue());
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof AttributeCol52;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        AttributeCol52 column = (AttributeCol52)metaData.getColumn();
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        this.model.getAttributeCols().remove(column);
        this.synchroniseDeleteColumn(columnIndex);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (!(metaData2 instanceof BaseSynchronizer.MoveColumnToMetaData)) {
                return false;
            }
            Object column = ((BaseSynchronizer.MoveColumnToMetaData)metaData2).getColumn();
            if (column instanceof AttributeCol52) continue;
            return false;
        }
        if (metaData.size() > 1) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        return true;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        AttributeCol52 modelColumn = (AttributeCol52)md.getColumn();
        List modelAttributeColumns = this.model.getAttributeCols();
        int modelAttributeColumnCount = modelAttributeColumns.size();
        if (modelAttributeColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List allModelColumns = this.model.getExpandedColumns();
        int minColumnIndex = allModelColumns.indexOf(modelAttributeColumns.get(0));
        int maxColumnIndex = allModelColumns.indexOf(modelAttributeColumns.get(modelAttributeColumnCount - 1));
        int targetColumnIndex = md.getTargetColumnIndex();
        int sourceColumnIndex = md.getSourceColumnIndex();
        if (targetColumnIndex < minColumnIndex || targetColumnIndex > maxColumnIndex) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        this.moveModelData(targetColumnIndex, sourceColumnIndex, sourceColumnIndex);
        modelAttributeColumns.remove(modelColumn);
        modelAttributeColumns.add(targetColumnIndex - minColumnIndex, modelColumn);
    }
}

