/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class MetaDataColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        MetadataCol52 column = (MetadataCol52)metaData.getColumn();
        this.model.getMetadataCols().add(column);
        this.synchroniseAppendColumn((BaseColumn)column);
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof MetadataCol52;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) {
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        MetadataCol52 originalColumn = (MetadataCol52)originalMetaData.getColumn();
        MetadataCol52 editedColumn = (MetadataCol52)editedMetaData.getColumn();
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        this.update(originalColumn, editedColumn);
        boolean isMetaDataUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"metadata", (List)diffs);
        boolean isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        if (isMetaDataUpdated) {
            this.setColumnHeader((BaseColumn)originalColumn, originalColumn.getMetadata());
        }
        if (isHideUpdated) {
            this.setColumnVisibility((BaseColumn)originalColumn, originalColumn.isHideColumn());
        }
        return diffs;
    }

    private void update(MetadataCol52 originalColumn, MetadataCol52 editedColumn) {
        originalColumn.setMetadata(editedColumn.getMetadata());
        originalColumn.setHideColumn(editedColumn.isHideColumn());
        originalColumn.setHeader(editedColumn.getHeader());
        originalColumn.setDefaultValue(editedColumn.getDefaultValue());
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof MetadataCol52;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        MetadataCol52 column = (MetadataCol52)metaData.getColumn();
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        this.model.getMetadataCols().remove(column);
        this.synchroniseDeleteColumn(columnIndex);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (!(metaData2 instanceof BaseSynchronizer.MoveColumnToMetaData)) {
                return false;
            }
            Object column = ((BaseSynchronizer.MoveColumnToMetaData)metaData2).getColumn();
            if (column instanceof MetadataCol52) continue;
            return false;
        }
        if (metaData.size() > 1) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        return true;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        MetadataCol52 modelColumn = (MetadataCol52)md.getColumn();
        List modelMetaDataColumns = this.model.getMetadataCols();
        int modelMetaDataColumnCount = modelMetaDataColumns.size();
        if (modelMetaDataColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List allModelColumns = this.model.getExpandedColumns();
        int minColumnIndex = allModelColumns.indexOf(modelMetaDataColumns.get(0));
        int maxColumnIndex = allModelColumns.indexOf(modelMetaDataColumns.get(modelMetaDataColumnCount - 1));
        int targetColumnIndex = md.getTargetColumnIndex();
        int sourceColumnIndex = md.getSourceColumnIndex();
        if (targetColumnIndex < minColumnIndex || targetColumnIndex > maxColumnIndex) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        this.moveModelData(targetColumnIndex, sourceColumnIndex, sourceColumnIndex);
        modelMetaDataColumns.remove(modelColumn);
        modelMetaDataColumns.add(targetColumnIndex - minColumnIndex, modelColumn);
    }
}

