/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Transform;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOver;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.PopOverView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionFactory;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@ApplicationScoped
public class ColumnHeaderPopOverImpl
implements ColumnHeaderPopOver {
    private PopOverView view;
    private ColumnDefinitionFactory columnDefinitionFactory;

    @Inject
    public ColumnHeaderPopOverImpl(PopOverView view, ColumnDefinitionFactory columnDefinitionFactory) {
        this.view = view;
        this.columnDefinitionFactory = columnDefinitionFactory;
    }

    @Override
    public void show(GuidedDecisionTableModellerView modellerView, GuidedDecisionTableView.Presenter dtPresenter, int uiColumnIndex) {
        PortablePreconditions.checkNotNull((String)"modellerView", (Object)modellerView);
        PortablePreconditions.checkNotNull((String)"dtPresenter", (Object)dtPresenter);
        this.showSource(modellerView, dtPresenter, uiColumnIndex);
    }

    private void showSource(GuidedDecisionTableModellerView modellerView, GuidedDecisionTableView.Presenter dtPresenter, int uiColumnIndex) {
        BaseColumn column = (BaseColumn)dtPresenter.getModel().getExpandedColumns().get(uiColumnIndex);
        int screenX = this.getScreenX(modellerView, dtPresenter, uiColumnIndex);
        int screenY = this.getScreenY(modellerView, dtPresenter);
        this.view.show(callback -> this.columnDefinitionFactory.generateColumnDefinition(dtPresenter, column, (Callback<String>)((Callback)definition -> callback.callback((Object)new PopOverView.Content((String)definition, screenX, screenY){
            final /* synthetic */ String val$definition;
            final /* synthetic */ int val$screenX;
            final /* synthetic */ int val$screenY;
            {
                this.val$definition = string;
                this.val$screenX = n;
                this.val$screenY = n2;
            }

            @Override
            public String getContent() {
                return this.val$definition;
            }

            @Override
            public int getX() {
                return this.val$screenX;
            }

            @Override
            public int getY() {
                return this.val$screenY;
            }
        }))));
    }

    @Override
    public void hide() {
        this.view.hide();
    }

    private int getScreenX(GuidedDecisionTableModellerView modellerView, GuidedDecisionTableView.Presenter dtPresenter, int uiColumnIndex) {
        GuidedDecisionTableView gridWidget = dtPresenter.getView();
        GridColumn uiColumn = (GridColumn)gridWidget.getModel().getColumns().get(uiColumnIndex);
        double gx = gridWidget.getX();
        GridLayer layer = modellerView.getGridLayerView();
        int containerX = layer.getDomElementContainer().getAbsoluteLeft();
        double vx = layer.getVisibleBounds().getX();
        Transform t = layer.getViewport().getTransform();
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = ri.getFloatingBlockInformation();
        double offsetX = floatingBlockInformation.getColumns().contains(uiColumn) ? floatingBlockInformation.getX() : 0.0;
        int screenX = containerX + (int)((gx - vx + offsetX + rendererHelper.getColumnOffset(uiColumn) + uiColumn.getWidth() / 2.0) * t.getScaleX());
        return screenX;
    }

    private int getScreenY(GuidedDecisionTableModellerView modellerView, GuidedDecisionTableView.Presenter dtPresenter) {
        GuidedDecisionTableView gridWidget = dtPresenter.getView();
        double gy = gridWidget.getY();
        GridLayer layer = modellerView.getGridLayerView();
        int containerY = layer.getDomElementContainer().getAbsoluteTop();
        double vy = layer.getVisibleBounds().getY();
        Transform t = layer.getViewport().getTransform();
        Group header = gridWidget.getHeader();
        double headerHeight = gridWidget.getRenderer().getHeaderHeight();
        double headerRowHeight = gridWidget.getRenderer().getHeaderRowHeight();
        double offsetY = header == null ? 0.0 : header.getY();
        int screenY = containerY + (int)((gy - vy + offsetY + headerHeight - headerRowHeight / 2.0) * t.getScaleX());
        return screenY;
    }
}

