/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ActionSetFieldsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AvailableField;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.ActionSetFieldsDefinedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.DuplicatePatternsEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.PatternRemovedEvent;
import org.kie.workbench.common.widgets.client.widget.HumanReadableDataTypes;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ActionSetFieldsPage
extends AbstractGuidedDecisionTableWizardPage
implements ActionSetFieldsPageView.Presenter {
    @Inject
    private ActionSetFieldsPageView view;
    @Inject
    private Event<ActionSetFieldsDefinedEvent> actionSetFieldsDefinedEvent;
    @Inject
    private Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private Map<Pattern52, List<ActionSetFieldCol52>> patternToActionsMap = new IdentityHashMap<Pattern52, List<ActionSetFieldCol52>>();

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardActionSetFields();
    }

    public void initialise() {
        this.view.init(this);
        this.view.setValidator(this.getValidator());
        this.patternToActionsMap.clear();
        this.getValidator().setPatternToActionSetFieldsMap(this.patternToActionsMap);
        this.view.setDTCellValueWidgetFactory(DTCellValueWidgetFactory.getInstance(this.model, this.oracle, false, this.allowEmptyValues()));
        for (ActionCol52 a : this.model.getActionCols()) {
            if (!(a instanceof ActionSetFieldCol52)) continue;
            ActionSetFieldCol52 asf = (ActionSetFieldCol52)a;
            Pattern52 p = this.model.getConditionPattern(asf.getBoundName());
            if (!this.patternToActionsMap.containsKey(p)) {
                this.patternToActionsMap.put(p, new ArrayList());
            }
            List<ActionSetFieldCol52> actions = this.patternToActionsMap.get(p);
            actions.add(asf);
        }
        this.view.setChosenFields(new ArrayList<ActionSetFieldCol52>());
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
        ArrayList<Pattern52> availablePatterns = new ArrayList<Pattern52>();
        for (Pattern52 p : this.model.getPatterns()) {
            if (p.getChildColumns().size() > 0) {
                availablePatterns.add(p);
                continue;
            }
            this.patternToActionsMap.remove(p);
        }
        this.view.setAvailablePatterns(availablePatterns);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean areActionSetFieldsDefined = true;
        block0: for (List<ActionSetFieldCol52> actions : this.patternToActionsMap.values()) {
            for (ActionSetFieldCol52 a : actions) {
                if (this.getValidator().isActionValid((ActionCol52)a)) continue;
                areActionSetFieldsDefined = false;
                continue block0;
            }
        }
        ActionSetFieldsDefinedEvent event = new ActionSetFieldsDefinedEvent(areActionSetFieldsDefined);
        this.actionSetFieldsDefinedEvent.fire((Object)event);
        callback.callback((Object)areActionSetFieldsDefined);
    }

    public void onPatternRemoved(@Observes PatternRemovedEvent event) {
        this.patternToActionsMap.remove(event.getPattern());
    }

    public void onDuplicatePatterns(@Observes DuplicatePatternsEvent event) {
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    public void onActionSetFieldsDefined(@Observes ActionSetFieldsDefinedEvent event) {
        this.view.setAreActionSetFieldsDefined(event.getAreActionSetFieldsDefined());
    }

    @Override
    public void selectPattern(final Pattern52 pattern) {
        if (pattern == null) {
            return;
        }
        final String type = pattern.getFactType();
        this.oracle.getFieldCompletions(type, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                ArrayList<AvailableField> availableFields = new ArrayList<AvailableField>();
                for (ModelField modelField : fields) {
                    String fieldName = modelField.getName();
                    String fieldType = ActionSetFieldsPage.this.oracle.getFieldType(type, fieldName);
                    String fieldDisplayType = HumanReadableDataTypes.getUserFriendlyTypeName((String)fieldType);
                    AvailableField field = new AvailableField(fieldName, fieldType, fieldDisplayType, 1);
                    availableFields.add(field);
                }
                ActionSetFieldsPage.this.view.setAvailableFields(availableFields);
                ArrayList<ActionSetFieldCol52> actionsForPattern = (ArrayList<ActionSetFieldCol52>)ActionSetFieldsPage.this.patternToActionsMap.get(pattern);
                if (actionsForPattern == null) {
                    actionsForPattern = new ArrayList<ActionSetFieldCol52>();
                    ActionSetFieldsPage.this.patternToActionsMap.put(pattern, actionsForPattern);
                }
                ActionSetFieldsPage.this.view.setChosenFields(actionsForPattern);
            }
        });
    }

    @Override
    public void makeResult(GuidedDecisionTable52 model) {
        for (Map.Entry<Pattern52, List<ActionSetFieldCol52>> ps : this.patternToActionsMap.entrySet()) {
            Pattern52 p = ps.getKey();
            if (p.getChildColumns().size() <= 0) continue;
            String binding = p.getBoundName();
            for (ActionSetFieldCol52 a : ps.getValue()) {
                a.setBoundName(binding);
                model.getActionCols().add(a);
            }
        }
    }

    @Override
    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.model.getTableFormat();
    }

    @Override
    public boolean hasEnums(ActionSetFieldCol52 selectedAction) {
        for (Map.Entry<Pattern52, List<ActionSetFieldCol52>> e : this.patternToActionsMap.entrySet()) {
            if (!e.getValue().contains(selectedAction)) continue;
            String factType = e.getKey().getFactType();
            String factField = selectedAction.getFactField();
            return this.oracle.hasEnums(factType, factField);
        }
        return false;
    }

    @Override
    public void assertDefaultValue(Pattern52 selectedPattern, ActionSetFieldCol52 selectedAction) {
        List<String> valueList = Arrays.asList(this.columnUtilities.getValueList((BaseColumn)selectedAction));
        if (valueList.size() > 0) {
            String defaultValue = this.cellUtilities.asString(selectedAction.getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                selectedAction.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = selectedAction.getDefaultValue();
            DataType.DataTypes dataType = this.columnUtilities.getDataType(selectedPattern, selectedAction);
            this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        }
    }

    @Override
    public void stateChanged() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.wizardPageStatusChangeEvent.fire((Object)event);
    }
}

