/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AvailableField;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternConstraintsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.ConditionsDefinedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.DuplicatePatternsEvent;
import org.kie.workbench.common.widgets.client.widget.HumanReadableDataTypes;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class FactPatternConstraintsPage
extends AbstractGuidedDecisionTableWizardPage
implements FactPatternConstraintsPageView.Presenter {
    @Inject
    private FactPatternConstraintsPageView view;
    @Inject
    private Event<ConditionsDefinedEvent> conditionsDefinedEvent;
    @Inject
    private Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardFactPatternConstraints();
    }

    public void initialise() {
        this.view.init(this);
        this.view.setValidator(this.getValidator());
        this.view.setDTCellValueUtilities(this.cellUtilities);
        this.view.setChosenConditions(new ArrayList<ConditionCol52>());
        this.view.setDTCellValueWidgetFactory(DTCellValueWidgetFactory.getInstance(this.model, this.oracle, false, this.allowEmptyValues()));
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
        this.view.setAvailablePatterns(this.model.getPatterns());
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean areConditionsDefined = true;
        block0: for (Pattern52 p : this.model.getPatterns()) {
            for (ConditionCol52 c : p.getChildColumns()) {
                if (this.getValidator().isConditionValid(c)) continue;
                areConditionsDefined = false;
                continue block0;
            }
        }
        ConditionsDefinedEvent event = new ConditionsDefinedEvent(areConditionsDefined);
        this.conditionsDefinedEvent.fire((Object)event);
        callback.callback((Object)areConditionsDefined);
    }

    public void onDuplicatePatterns(@Observes DuplicatePatternsEvent event) {
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    public void onConditionsDefined(@Observes ConditionsDefinedEvent event) {
        this.view.setAreConditionsDefined(event.getAreConditionsDefined());
    }

    @Override
    public void selectPattern(final Pattern52 pattern) {
        if (pattern == null) {
            return;
        }
        final String type = pattern.getFactType();
        this.oracle.getFieldCompletions(type, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                ArrayList<AvailableField> availableFields = new ArrayList<AvailableField>();
                for (ModelField modelField : fields) {
                    String fieldName = modelField.getName();
                    String fieldType = FactPatternConstraintsPage.this.oracle.getFieldType(type, fieldName);
                    String fieldDisplayType = HumanReadableDataTypes.getUserFriendlyTypeName((String)fieldType);
                    AvailableField field = new AvailableField(fieldName, fieldType, fieldDisplayType, 1);
                    availableFields.add(field);
                }
                if (FactPatternConstraintsPage.this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
                    AvailableField field = new AvailableField(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardPredicate(), 5);
                    availableFields.add(field);
                }
                FactPatternConstraintsPage.this.view.setAvailableFields(availableFields);
                FactPatternConstraintsPage.this.view.setChosenConditions(pattern.getChildColumns());
            }
        });
    }

    @Override
    public void setChosenConditions(Pattern52 pattern, List<ConditionCol52> conditions) {
        pattern.getChildColumns().clear();
        pattern.getChildColumns().addAll(conditions);
    }

    @Override
    public void getOperatorCompletions(Pattern52 selectedPattern, final ConditionCol52 selectedCondition, final Callback<String[]> callback) {
        String factType = selectedPattern.getFactType();
        String factField = selectedCondition.getFactField();
        this.oracle.getOperatorCompletions(factType, factField, (Callback)new Callback<String[]>(){

            public void callback(String[] ops) {
                ArrayList<String> filteredOps = new ArrayList<String>();
                for (String op : ops) {
                    filteredOps.add(op);
                }
                if (1 != selectedCondition.getConstraintValueType()) {
                    filteredOps.remove("in");
                    filteredOps.remove("not in");
                }
                String[] displayOps = new String[filteredOps.size()];
                filteredOps.toArray(displayOps);
                callback.callback((Object)displayOps);
            }
        });
    }

    @Override
    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.model.getTableFormat();
    }

    @Override
    public boolean hasEnum(Pattern52 selectedPattern, ConditionCol52 selectedCondition) {
        String factType = selectedPattern.getFactType();
        String factField = selectedCondition.getFactField();
        return this.oracle.hasEnums(factType, factField);
    }

    @Override
    public boolean requiresValueList(Pattern52 selectedPattern, ConditionCol52 selectedCondition) {
        boolean enableValueList;
        String factType = selectedPattern.getFactType();
        String factField = selectedCondition.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = this.validator.doesOperatorAcceptValueList(selectedCondition);
        }
        if (enableValueList) {
            enableValueList = !this.oracle.hasEnums(factType, factField);
        }
        return enableValueList;
    }

    @Override
    public void assertDefaultValue(Pattern52 selectedPattern, ConditionCol52 selectedCondition) {
        List<String> valueList = Arrays.asList(this.columnUtilities.getValueList((BaseColumn)selectedCondition));
        if (valueList.size() > 0) {
            String defaultValue = this.cellUtilities.asString(selectedCondition.getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                selectedCondition.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = selectedCondition.getDefaultValue();
            DataType.DataTypes dataType = this.columnUtilities.getDataType(selectedPattern, selectedCondition);
            this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        }
    }

    @Override
    public void stateChanged() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.wizardPageStatusChangeEvent.fire((Object)event);
    }
}

