/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages.cells;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.RequiresValidator;
import org.uberfire.ext.widgets.core.client.resources.WizardResources;

public class ConditionCell
extends AbstractCell<ConditionCol52>
implements RequiresValidator {
    private Validator validator;
    private static final ConditionCellTemplate TEMPLATE = (ConditionCellTemplate)GWT.create(ConditionCellTemplate.class);

    public ConditionCell() {
        super(new String[0]);
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void render(Cell.Context context, ConditionCol52 value, SafeHtmlBuilder sb) {
        StringBuilder b = new StringBuilder();
        switch (value.getConstraintValueType()) {
            case 1: {
                this.makeLiteral(b, value);
                break;
            }
            case 3: {
                this.makeFormula(b, value);
                break;
            }
            case 5: {
                this.makePredicate(b, value);
            }
        }
        sb.append(TEMPLATE.text(this.getCssStyleName(value), b.toString()));
    }

    private void makeLiteral(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void makeFormula(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void makePredicate(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void appendHeader(StringBuilder sb, ConditionCol52 condition) {
        if (this.validator.isConditionHeaderValid(condition)) {
            sb.append("[");
            sb.append(condition.getHeader());
            sb.append("] ");
        }
    }

    private String getCssStyleName(ConditionCol52 c) {
        if (!this.validator.isConditionValid(c)) {
            return WizardResources.INSTANCE.css().wizardDTableValidationError();
        }
        return "";
    }

    static interface ConditionCellTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div class=\"{0}\" >{1}</div>")
        public SafeHtml text(String var1, String var2);
    }
}

