/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseGuidedDecisionTableEditorPresenterTest
extends BaseGuidedDecisionTablePresenterTest<BaseGuidedDecisionTableEditorPresenter> {
    private GuidedDTableResourceType resourceType = new GuidedDTableResourceType();

    @Override
    protected GuidedDecisionTableEditorPresenter getPresenter() {
        return new GuidedDecisionTableEditorPresenter(this.view, this.dtServiceCaller, this.notification, this.decisionTableSelectedEvent, this.resourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.beanManager, this.placeManager);
    }

    @Test
    public void checkInit() {
        ((ViewMenuBuilder)Mockito.verify((Object)this.viewMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((InsertMenuBuilder)Mockito.verify((Object)this.insertMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((RadarMenuBuilder)Mockito.verify((Object)this.radarMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModellerView((GuidedDecisionTableModellerView)Mockito.eq((Object)this.modellerView));
    }

    @Test
    public void checkOnStartup() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        Assert.assertEquals((Object)path, (Object)this.presenter.editorPath);
        Assert.assertEquals((Object)placeRequest, (Object)this.presenter.editorPlaceRequest);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).loadDocument((ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Mockito.eq((Object)path));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).addDecisionTable((ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)content), ((Boolean)Matchers.any(Boolean.class)).booleanValue(), (Double)Mockito.eq(null), (Double)Mockito.eq(null));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).registerDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertNotNull((Object)dtSelectedEvent.getPresenter());
        Assert.assertEquals((Object)dtPresenter, (Object)dtSelectedEvent.getPresenter());
    }

    @Test
    public void checkMayCloseWithNoDecisionTable() {
        Assert.assertTrue((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkMayCloseWithCleanDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)dtPresenter.getOriginalHashCode()).thenReturn((Object)0);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Assert.assertTrue((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkMayCloseWithDirtyDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)dtPresenter.getOriginalHashCode()).thenReturn((Object)10);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Assert.assertFalse((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkOnClose() {
        this.presenter.onClose();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).onClose();
    }

    @Test
    public void checkOnDecisionTableSelectedWhenAvailableSelected() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDocument()).thenReturn((Object)dtPresenter);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void checkOnDecisionTableSelectedWhenAvailableNotSelected() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDocument()).thenReturn(null);
        this.presenter.onStartup(path, placeRequest);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void checkOnDecisionTableSelectedWhenNotAvailable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)false);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void checkRefreshDocument() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Mockito.eq((Object)path));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertNotNull((Object)dtSelectedEvent.getPresenter());
        Assert.assertEquals((Object)dtPresenter, (Object)dtSelectedEvent.getPresenter());
        Mockito.when((Object)dtPresenter.getCurrentPath()).thenReturn((Object)path);
        this.presenter.refreshDocument(dtPresenter);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showLoading();
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)2))).loadContent((Path)Mockito.eq((Object)path));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).refreshDecisionTable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter), (ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)content), ((Boolean)Matchers.any(Boolean.class)).booleanValue());
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).activateDocument((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void checkRemoveDocument() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        this.presenter.removeDocument(dtPresenter);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).removeDecisionTable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).deregisterDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).openOtherDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter, (VerificationMode)Mockito.times((int)1))).onClose();
    }

    @Test
    public void checkOpenOtherDecisionTableIsLastDecisionTable() {
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn(Collections.emptySet());
        this.presenter.openOtherDecisionTable();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).forceClosePlace((PlaceRequest)Mockito.eq((Object)this.presenter.editorPlaceRequest));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void checkOpenOtherDecisionTableIsNotLastDecisionTable() {
        final GuidedDecisionTableView.Presenter remainingDtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(remainingDtPresenter);
            }
        });
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        this.presenter.openOtherDecisionTable();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).forceClosePlace((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).activateDocument(remainingDtPresenter);
    }

    @Test
    public void checkOnValidateWithErrors() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage());
            }
        };
        Mockito.when((Object)this.dtService.validate((Path)Matchers.any(Path.class), Matchers.any(GuidedDecisionTable52.class))).thenReturn((Object)validationMessages);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).showValidationPopup((List)Matchers.any(List.class));
        this.presenter.onValidate(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).validate((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((Event)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.never())).fire(Matchers.any(NotificationEvent.class));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).showValidationPopup((List)Mockito.eq((Object)validationMessages));
    }

    @Test
    public void checkOnValidateWithoutErrors() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)this.dtService.validate((Path)Matchers.any(Path.class), Matchers.any(GuidedDecisionTable52.class))).thenReturn(Collections.emptyList());
        this.presenter.onValidate(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).validate((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((Event)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void checkOnSave() {
        String commitMessage = "message";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onSave(dtPresenter, "message");
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(Metadata.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)path), modelCaptor.capture(), (Metadata)metadataCaptor.capture(), (String)Mockito.eq((Object)"message"));
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        Assert.assertNotNull((Object)metadataCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getOverview().getMetadata(), (Object)metadataCaptor.getValue());
    }

    @Test
    public void checkOnSourceTabSelected() {
        String source = "source";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)this.dtService.toSource((Path)Mockito.eq((Object)path), Matchers.any(GuidedDecisionTable52.class))).thenReturn((Object)"source");
        this.presenter.onSourceTabSelected(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).toSource((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).updateSource((String)Mockito.eq((Object)"source"));
    }
}

