/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import java.lang.reflect.Field;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuBuilder;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilderImpl;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class BaseGuidedDecisionTablePresenterTest<P extends BaseGuidedDecisionTableEditorPresenter> {
    @Mock
    protected BaseGuidedDecisionTableEditorPresenter.View view;
    @Mock
    protected GuidedDecisionTableEditorService dtService;
    protected Caller<GuidedDecisionTableEditorService> dtServiceCaller;
    protected Event<NotificationEvent> notification = (Event)Mockito.spy((Object)new EventSourceMock<NotificationEvent>(){

        public void fire(NotificationEvent event) {
        }
    });
    protected Event<DecisionTableSelectedEvent> decisionTableSelectedEvent = (Event)Mockito.spy((Object)new EventSourceMock<DecisionTableSelectedEvent>(){

        public void fire(DecisionTableSelectedEvent event) {
        }
    });
    @Mock
    protected EditMenuBuilder editMenuBuilder;
    @Mock
    protected MenuItem editMenuItem;
    @Mock
    protected ViewMenuBuilder viewMenuBuilder;
    @Mock
    protected MenuItem viewMenuItem;
    @Mock
    protected InsertMenuBuilder insertMenuBuilder;
    @Mock
    protected MenuItem insertMenuItem;
    @Mock
    protected RadarMenuBuilder radarMenuBuilder;
    @Mock
    protected MenuItem radarMenuItem;
    @Mock
    protected RegisteredDocumentsMenuBuilder registeredDocumentsMenuBuilder;
    @Mock
    protected MenuItem registeredDocumentsMenuItem;
    @Mock
    protected MenuItem saveMenuItem;
    @Mock
    protected MenuItem versionManagerMenuItem;
    @Mock
    protected GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    protected GuidedDecisionTableModellerView modellerView;
    @Mock
    protected KieMultipleDocumentEditorWrapperView kieEditorWrapperView;
    @Mock
    protected OverviewWidgetPresenter overviewWidget;
    @Mock
    protected SavePopUpPresenter savePopUpPresenter;
    @Mock
    protected ImportsWidgetPresenter importsWidget;
    @Mock
    protected EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    protected EventSourceMock<ChangeTitleWidgetEvent> changeTitleEvent;
    @Mock
    protected ProjectContext workbenchContext;
    @Mock
    protected VersionRecordManager versionRecordManager;
    @Mock
    protected VersionService versionService;
    protected CallerMock<VersionService> versionServiceCaller;
    @Mock
    protected EventSourceMock<RestoreEvent> restoreEvent;
    @Mock
    protected DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    protected CopyPopUpPresenter copyPopUpPresenter;
    @Mock
    protected RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    protected BusyIndicatorView busyIndicatorView;
    @Spy
    protected RestoreVersionCommandProvider restoreVersionCommandProvider = this.getRestoreVersionCommandProvider();
    @Spy
    protected BasicFileMenuBuilder basicFileMenuBuilder = this.getBasicFileMenuBuilder();
    @Spy
    protected FileMenuBuilder fileMenuBuilder = this.getFileMenuBuilder();
    @Mock
    protected DefaultFileNameValidator fileNameValidator;
    @Mock
    protected SyncBeanManager beanManager;
    @Mock
    protected PlaceManager placeManager;
    @Captor
    protected ArgumentCaptor<DecisionTableSelectedEvent> dtSelectedEventCaptor;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected P presenter;

    @Before
    public void setup() {
        this.dtServiceCaller = new CallerMock((Object)this.dtService);
        this.versionServiceCaller = new CallerMock((Object)this.versionService);
        P wrapped = this.getPresenter();
        wrapped.setKieEditorWrapperView(this.kieEditorWrapperView);
        wrapped.setOverviewWidget(this.overviewWidget);
        wrapped.setSavePopUpPresenter(this.savePopUpPresenter);
        wrapped.setImportsWidget(this.importsWidget);
        wrapped.setNotificationEvent(this.notificationEvent);
        wrapped.setChangeTitleEvent(this.changeTitleEvent);
        wrapped.setWorkbenchContext(this.workbenchContext);
        wrapped.setVersionRecordManager(this.versionRecordManager);
        wrapped.setRegisteredDocumentsMenuBuilder(this.registeredDocumentsMenuBuilder);
        wrapped.setFileMenuBuilder(this.fileMenuBuilder);
        wrapped.setFileNameValidator(this.fileNameValidator);
        this.presenter = (BaseGuidedDecisionTableEditorPresenter)Mockito.spy(wrapped);
        Mockito.when((Object)this.modeller.getView()).thenReturn((Object)this.modellerView);
        Mockito.when((Object)this.versionRecordManager.newSaveMenuItem((Command)Matchers.any(Command.class))).thenReturn((Object)this.saveMenuItem);
        Mockito.when((Object)this.versionRecordManager.buildMenu()).thenReturn((Object)this.versionManagerMenuItem);
        Mockito.when((Object)this.editMenuBuilder.build()).thenReturn((Object)this.editMenuItem);
        Mockito.when((Object)this.viewMenuBuilder.build()).thenReturn((Object)this.viewMenuItem);
        Mockito.when((Object)this.insertMenuBuilder.build()).thenReturn((Object)this.insertMenuItem);
        Mockito.when((Object)this.radarMenuBuilder.build()).thenReturn((Object)this.radarMenuItem);
        Mockito.when((Object)this.registeredDocumentsMenuBuilder.build()).thenReturn((Object)this.registeredDocumentsMenuItem);
        this.presenter.init();
        this.presenter.setupMenuBar();
    }

    protected abstract P getPresenter();

    protected GuidedDecisionTableView.Presenter makeDecisionTable(Path originalPath, ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content) {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)path))).thenReturn((Object)content);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)content), ((Boolean)Matchers.any(Boolean.class)).booleanValue(), (Double)Matchers.any(Double.class), (Double)Matchers.any(Double.class))).thenReturn((Object)dtPresenter);
        Mockito.when((Object)path.getOriginal()).thenReturn((Object)originalPath);
        Mockito.when((Object)dtPresenter.getLatestPath()).thenReturn((Object)path);
        Mockito.when((Object)dtPresenter.getCurrentPath()).thenReturn((Object)path);
        Mockito.when((Object)dtPresenter.getPlaceRequest()).thenReturn((Object)placeRequest);
        Mockito.when((Object)dtPresenter.getModel()).thenReturn((Object)content.getModel());
        Mockito.when((Object)dtPresenter.getDataModelOracle()).thenReturn((Object)oracle);
        Mockito.when((Object)dtPresenter.getOverview()).thenReturn((Object)overview);
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn((Object)access);
        Mockito.when((Object)dtPresenter.getView()).thenReturn(Mockito.mock(GuidedDecisionTableView.class));
        Mockito.when((Object)overview.getMetadata()).thenReturn(Mockito.mock(Metadata.class));
        return dtPresenter;
    }

    protected GuidedDecisionTableEditorContent makeDecisionTableContent() {
        return this.makeDecisionTableContent(0);
    }

    protected GuidedDecisionTableEditorContent makeDecisionTableContent(final int hashCode) {
        GuidedDecisionTable52 model = new GuidedDecisionTable52(){

            public int hashCode() {
                return hashCode;
            }
        };
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)overview.getMetadata()).thenReturn((Object)metadata);
        return new GuidedDecisionTableEditorContent(model, Collections.emptySet(), overview, (PackageDataModelOracleBaselinePayload)Mockito.mock(PackageDataModelOracleBaselinePayload.class));
    }

    private RestoreVersionCommandProvider getRestoreVersionCommandProvider() {
        RestoreVersionCommandProvider restoreVersionCommandProvider = new RestoreVersionCommandProvider();
        this.setField(restoreVersionCommandProvider, "versionService", this.versionServiceCaller);
        this.setField(restoreVersionCommandProvider, "restoreEvent", this.restoreEvent);
        this.setField(restoreVersionCommandProvider, "busyIndicatorView", this.view);
        return restoreVersionCommandProvider;
    }

    private BasicFileMenuBuilder getBasicFileMenuBuilder() {
        BasicFileMenuBuilderImpl basicFileMenuBuilder = new BasicFileMenuBuilderImpl(this.deletePopUpPresenter, this.copyPopUpPresenter, this.renamePopUpPresenter, this.busyIndicatorView, this.notification, this.restoreVersionCommandProvider);
        this.setField(basicFileMenuBuilder, "restoreVersionCommandProvider", this.restoreVersionCommandProvider);
        this.setField(basicFileMenuBuilder, "notification", this.notificationEvent);
        this.setField(this.restoreVersionCommandProvider, "busyIndicatorView", this.view);
        return basicFileMenuBuilder;
    }

    private FileMenuBuilder getFileMenuBuilder() {
        FileMenuBuilderImpl fileMenuBuilder = new FileMenuBuilderImpl();
        this.setField(fileMenuBuilder, "menuBuilder", this.basicFileMenuBuilder);
        return fileMenuBuilder;
    }

    private void setField(Object o, String fieldName, Object value) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

