/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ViewMenuBuilderTest {
    private ViewMenuBuilder builder;
    @Mock
    private ViewMenuView view;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private GuidedDecisionTableView dtPresenterView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;

    @Before
    public void setup() {
        this.builder = new ViewMenuBuilder(this.view);
        this.builder.setup();
        this.builder.setModeller(this.modeller);
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
    }

    @Test
    public void testInitialSetup() {
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom125(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom100(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom75(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom50(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableToggleMergedStateMenuItem(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableViewAuditLogMenuItem(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNonOtherwiseColumnSelected() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableToggleMergedStateMenuItem(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableViewAuditLogMenuItem(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnZoom125() {
        Mockito.reset((Object[])new ViewMenuView[]{this.view});
        this.builder.onZoom(125);
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom125(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom100(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom75(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom50(Mockito.eq((boolean)false));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)125));
    }

    @Test
    public void testOnZoom100() {
        Mockito.reset((Object[])new ViewMenuView[]{this.view});
        this.builder.onZoom(100);
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom125(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom100(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom75(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom50(Mockito.eq((boolean)false));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)100));
    }

    @Test
    public void testOnZoom75() {
        Mockito.reset((Object[])new ViewMenuView[]{this.view});
        this.builder.onZoom(75);
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom125(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom100(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom75(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom50(Mockito.eq((boolean)false));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)75));
    }

    @Test
    public void testOnZoom50() {
        Mockito.reset((Object[])new ViewMenuView[]{this.view});
        this.builder.onZoom(50);
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom125(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom100(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom75(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom50(Mockito.eq((boolean)true));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)50));
    }

    @Test
    public void testToggleMergeState() {
        Mockito.when((Object)this.dtPresenter.isMerged()).thenReturn((Object)false);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableToggleMergedStateMenuItem(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableViewAuditLogMenuItem(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMerged(Mockito.eq((boolean)false));
        this.builder.onToggleMergeState();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).setMerged(Mockito.eq((boolean)true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMerged(Mockito.eq((boolean)true));
    }

    @Test
    public void testViewAuditLog() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        this.builder.onViewAuditLog();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).showAuditLog();
    }

    @Test
    public void testEnableZoom_Pinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableZoom(Mockito.eq((boolean)false));
    }

    @Test
    public void testEnableZoom_Pinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), true));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableZoom(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testEnableZoom_Unpinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableZoom(Mockito.eq((boolean)true));
    }

    @Test
    public void testEnableZoom_Unpinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableZoom(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableToggleMergedStateMenuItem(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableViewAuditLogMenuItem(Mockito.eq((boolean)false));
        this.dtPresenter.getAccess().setReadOnly(true);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableToggleMergedStateMenuItem(Mockito.eq((boolean)false));
        ((ViewMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableViewAuditLogMenuItem(Mockito.eq((boolean)false));
    }
}

