/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionSetFieldPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class, GuidedDecisionTableImageResources508.class})
public class ActionSetFieldPopupTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ActionColumnCommand refreshGrid;
    private ActionSetFieldPopup popup;

    @BeforeClass
    public static void setupApplicationPreferences() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
    }

    private void setup(GuidedDecisionTable52 model, ActionSetFieldCol52 column, boolean isNew, boolean isReadOnly) {
        this.popup = (ActionSetFieldPopup)Mockito.spy((Object)new ActionSetFieldPopup(model, this.oracle, this.presenter, this.refreshGrid, column, isNew, isReadOnly));
    }

    @Test
    public void noPatternSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelPleaseChooseAFactPatternFirst();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseSelectAField();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }

    @Test
    public void patternSelectedNoFieldSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        column.setBoundName("$a");
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseChooseAFactPatternFirst();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelPleaseSelectAField();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }

    @Test
    public void patternSelectedFieldSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("MyFact");
        model.getConditions().add(pattern);
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        column.setBoundName("$a");
        column.setFactField("myField");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"MyFact"), (String)Mockito.eq((Object)"myField"))).thenReturn((Object)"String");
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseChooseAFactPatternFirst();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseSelectAField();
        ((ActionSetFieldPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }
}

