/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class, GuidedDecisionTableImageResources508.class, CEPWindowOperatorsDropdown.class})
public class ConditionPopupTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ConditionColumnCommand refreshGrid;
    private ConditionPopup popup;

    @BeforeClass
    public static void setupApplicationPreferences() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
    }

    private void setup(GuidedDecisionTable52 model, Pattern52 pattern, ConditionCol52 column, boolean isNew, boolean isReadOnly) {
        this.popup = (ConditionPopup)Mockito.spy((Object)new ConditionPopup(model, this.oracle, this.presenter, this.refreshGrid, pattern, column, isNew, isReadOnly));
    }

    @Test
    public void patternIsPreSelectedWhenBeingEdited() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Pattern52 pattern = new Pattern52();
        ConditionCol52 column = new ConditionCol52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("$p1");
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$p2");
        model.getConditions().add(p1);
        model.getConditions().add(p2);
        pattern.setBoundName("$p2");
        this.setup(model, pattern, column, false, false);
        this.popup.loadPatterns();
        ArgumentCaptor indexArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).selectListBoxItem((ListBox)Mockito.any(ListBox.class), ((Integer)indexArgumentCaptor.capture()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)indexArgumentCaptor.getValue()).intValue());
    }

    @Test
    public void fieldIsPreSelectedWhenBeingEdited() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Pattern52 pattern = new Pattern52();
        ConditionCol52 column = new ConditionCol52();
        pattern.setFactType("Pattern");
        pattern.setBoundName("$p2");
        column.setFactField("field2");
        column.setBinding("$p2");
        ModelField[] modelFields = new ModelField[]{new ModelField("field1", "java.lang.Integer", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, "Integer"), new ModelField("field2", "java.lang.Integer", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, "Integer")};
        ((AsyncPackageDataModelOracle)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArguments()[2];
            callback.callback((Object)modelFields);
            return null;
        }).when((Object)this.oracle)).getFieldCompletions((String)Mockito.eq((Object)"Pattern"), (FieldAccessorsAndMutators)Mockito.eq((Object)FieldAccessorsAndMutators.ACCESSOR), (Callback)Mockito.any(Callback.class));
        this.setup(model, pattern, column, false, false);
        this.popup.loadFields();
        ArgumentCaptor indexArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).selectListBoxItem((ListBox)Mockito.any(ListBox.class), ((Integer)indexArgumentCaptor.capture()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)indexArgumentCaptor.getValue()).intValue());
    }
}

