/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionGlobalCollectionAdd;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.ExpressionCollectionIndex;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionText;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.screens.guided.dtable.client.widget.RuleModelCloneVisitor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RuleModelCloneVisitorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCloneWithUnsupportedClass() {
        RuleModel model = new RuleModel();
        model.addLhsItem((IPattern)new TestFactPattern());
        RuleModelCloneVisitor visitor = new RuleModelCloneVisitor();
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(TestFactPattern.class.getSimpleName());
        visitor.visitRuleModel(model);
    }

    @Test
    public void testRuleModelCloning() {
        RuleModel model = new RuleModel();
        RuleAttribute attribute = new RuleAttribute("att1_name", "att1_val");
        model.addAttribute(attribute);
        RuleMetadata metadata = new RuleMetadata("meta1_name", "meta1_val");
        model.addMetadata(metadata);
        FactPattern f1 = RuleModelCloneVisitorTest.buildFactPattern();
        FactPattern f2 = new FactPattern();
        f2.setBoundName("$f2");
        f2.setFactType("Fact2");
        f2.addConstraint((FieldConstraint)RuleModelCloneVisitorTest.buildCompositeFieldConstraint());
        CompositeFactPattern composite = new CompositeFactPattern();
        composite.setType("exists");
        composite.addFactPattern((IFactPattern)f1);
        composite.addFactPattern((IFactPattern)f2);
        model.addLhsItem((IPattern)composite);
        model.addLhsItem((IPattern)RuleModelCloneVisitorTest.buildFromAccumulateCompositeFactPattern());
        model.addLhsItem((IPattern)RuleModelCloneVisitorTest.buildFromCollectCompositeFactPattern());
        model.addLhsItem((IPattern)RuleModelCloneVisitorTest.buildFromCompositeFactPattern());
        model.addLhsItem((IPattern)RuleModelCloneVisitorTest.buildFreeFormLine());
        model.addLhsItem((IPattern)this.buildDslSentence());
        ActionGlobalCollectionAdd addGlobal = new ActionGlobalCollectionAdd();
        addGlobal.setFactName("MyFact");
        addGlobal.setGlobalName("glist");
        model.addRhsItem((IAction)addGlobal);
        ActionInsertFact aif = new ActionInsertFact();
        aif.setBoundName("$f");
        aif.setFactType("FactType");
        aif.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        aif.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        model.addRhsItem((IAction)aif);
        ActionUpdateField auf = new ActionUpdateField();
        auf.setVariable("$var");
        auf.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        auf.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        model.addRhsItem((IAction)auf);
        ActionSetField asf = new ActionSetField();
        asf.setVariable("$var");
        asf.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        asf.addFieldValue(RuleModelCloneVisitorTest.buildActionFieldValue());
        model.addRhsItem((IAction)asf);
        ActionRetractFact arf = new ActionRetractFact();
        arf.setVariableName("$f");
        model.addRhsItem((IAction)arf);
        ActionCallMethod callMethod1 = new ActionCallMethod();
        callMethod1.setVariable("var1");
        callMethod1.setMethodName("testMethod1 ");
        callMethod1.setState(1);
        callMethod1.addFieldValue((ActionFieldValue)new ActionFieldFunction("field1", "value1", "type1"));
        model.addRhsItem((IAction)callMethod1);
        ActionCallMethod callMethod2 = new ActionCallMethod();
        callMethod2.setVariable("var2");
        callMethod2.setMethodName("testMethod2 ");
        callMethod2.setState(0);
        callMethod2.addFieldValue((ActionFieldValue)new ActionFieldFunction("field2", "value2", "type2"));
        model.addRhsItem((IAction)callMethod2);
        model.addRhsItem((IAction)RuleModelCloneVisitorTest.buildFreeFormLine());
        RuleModel clone = new RuleModelCloneVisitor().visitRuleModel(model);
        Assert.assertArrayEquals((Object[])model.attributes, (Object[])clone.attributes);
        int attIndex = 0;
        for (RuleAttribute att : model.attributes) {
            Assert.assertNotSame((Object)att, (Object)clone.attributes[attIndex++]);
        }
        Assert.assertArrayEquals((Object[])model.metadataList, (Object[])clone.metadataList);
        int metIndex = 0;
        for (RuleMetadata met : model.metadataList) {
            Assert.assertNotSame((Object)met, (Object)clone.metadataList[metIndex++]);
        }
        Assert.assertArrayEquals((Object[])model.lhs, (Object[])clone.lhs);
        int lhsIndex = 0;
        for (IPattern pattern : model.lhs) {
            Assert.assertNotSame((Object)pattern, (Object)clone.lhs[lhsIndex++]);
        }
        Assert.assertArrayEquals((Object[])model.rhs, (Object[])clone.rhs);
        int rhsIndex = 0;
        for (IAction action : model.rhs) {
            Assert.assertNotSame((Object)action, (Object)clone.rhs[rhsIndex++]);
        }
    }

    private static FromCompositeFactPattern buildFromCompositeFactPattern() {
        FromCompositeFactPattern fcomp = new FromCompositeFactPattern();
        fcomp.setExpression(RuleModelCloneVisitorTest.buildExpressionFormLine());
        fcomp.setFactPattern(RuleModelCloneVisitorTest.buildFactPattern());
        return fcomp;
    }

    private static FromAccumulateCompositeFactPattern buildFromAccumulateCompositeFactPattern() {
        FromAccumulateCompositeFactPattern facc = new FromAccumulateCompositeFactPattern();
        facc.setActionCode("action code; ");
        facc.setExpression(RuleModelCloneVisitorTest.buildExpressionFormLine());
        facc.setFactPattern(RuleModelCloneVisitorTest.buildFactPattern());
        facc.setFunction("function;");
        facc.setInitCode("init code;");
        facc.setResultCode("result code;");
        facc.setReverseCode("reverse code;");
        facc.setSourcePattern((IPattern)RuleModelCloneVisitorTest.buildExpressionFormLine());
        return facc;
    }

    private static FromCollectCompositeFactPattern buildFromCollectCompositeFactPattern() {
        FromCollectCompositeFactPattern fcoll = new FromCollectCompositeFactPattern();
        fcoll.setExpression(RuleModelCloneVisitorTest.buildExpressionFormLine());
        fcoll.setFactPattern(RuleModelCloneVisitorTest.buildFactPattern());
        fcoll.setRightPattern((IPattern)RuleModelCloneVisitorTest.buildExpressionFormLine());
        return fcoll;
    }

    private static FactPattern buildFactPattern() {
        FactPattern fp = new FactPattern();
        fp.setBoundName("$f");
        fp.setFactType("FactType");
        fp.setNegated(true);
        CEPWindow win = new CEPWindow();
        win.setOperator("winOp");
        win.setParameter("winKey", "winPar");
        fp.setWindow(win);
        fp.addConstraint((FieldConstraint)RuleModelCloneVisitorTest.buildSingleFieldConstraint());
        return fp;
    }

    private static CompositeFieldConstraint buildCompositeFieldConstraint() {
        CompositeFieldConstraint cfc = new CompositeFieldConstraint();
        cfc.addConstraint((FieldConstraint)RuleModelCloneVisitorTest.buildSingleFieldConstraint());
        cfc.addConstraint((FieldConstraint)RuleModelCloneVisitorTest.buildSingleFieldConstraintEBLeftSide());
        cfc.setCompositeJunctionType("||");
        return cfc;
    }

    private static SingleFieldConstraint buildSingleFieldConstraint() {
        SingleFieldConstraint sfc = new SingleFieldConstraint();
        sfc.setExpressionValue(RuleModelCloneVisitorTest.buildExpressionFormLine());
        sfc.setFactType("FactType");
        sfc.setFieldBinding("fieldBinding");
        sfc.setFieldName("fieldName");
        sfc.setFieldType("FieldType");
        sfc.setId("id");
        sfc.setOperator("operator");
        sfc.setParameter("key", "parameter");
        sfc.setParent((FieldConstraint)new SingleFieldConstraint("parentFieldName"));
        sfc.addNewConnective();
        return sfc;
    }

    private static SingleFieldConstraintEBLeftSide buildSingleFieldConstraintEBLeftSide() {
        SingleFieldConstraintEBLeftSide sfc = new SingleFieldConstraintEBLeftSide();
        sfc.setConstraintValueType(1);
        sfc.setExpressionValue(RuleModelCloneVisitorTest.buildExpressionFormLine());
        sfc.setExpressionLeftSide(RuleModelCloneVisitorTest.buildExpressionFormLine());
        sfc.setFactType("FactType");
        sfc.setId("id");
        sfc.setOperator("operator");
        sfc.setParameter("key", "parameter");
        sfc.setParent((FieldConstraint)new SingleFieldConstraint("parentFieldName"));
        sfc.setValue("value");
        sfc.addNewConnective();
        return sfc;
    }

    private static ExpressionFormLine buildExpressionFormLine() {
        ExpressionFormLine efl = new ExpressionFormLine();
        efl.setBinding("eflBinding");
        efl.appendPart((ExpressionPart)new ExpressionText("text"));
        efl.appendPart((ExpressionPart)new ExpressionCollectionIndex("collectionIndex", "CT", "GT"));
        return efl;
    }

    private DSLSentence buildDslSentence() {
        DSLSentence dsl = new DSLSentence();
        dsl.setDrl("Person( sex == {$sex} )");
        dsl.setDefinition("Person is {$sex:ENUM:Person.sex}");
        return dsl;
    }

    private static FreeFormLine buildFreeFormLine() {
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("text");
        return ffl;
    }

    private static ActionFieldValue buildActionFieldValue() {
        ActionFieldValue afv = new ActionFieldValue();
        afv.setField("field");
        afv.setNature(1);
        afv.setType("Type");
        afv.setValue("value");
        return afv;
    }

    private static class TestFactPattern
    implements IFactPattern {
        private TestFactPattern() {
        }

        public String getFactType() {
            throw new UnsupportedOperationException("Not expected to be called.");
        }
    }
}

