/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerSubsumptionResolverTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "amount")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "lengthYears")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "deposit")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "approved")).thenReturn((Object)"Boolean");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "insuranceCost")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("LoanApplication", "approvedRate")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("IncomeSource", "type")).thenReturn((Object)"String");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("Person", "name")).thenReturn((Object)"String");
    }

    @Test
    public void testNoIssues() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 10000, 100000, 20, 2000, "Job", true, 0, 4}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}, {4, "description", null, null, null, null, null, null, null, null}, {5, "description", null, null, null, null, null, null, null, null}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(3)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(4)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(5)", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testNoIssues2() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 1000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(3)", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    @Ignore(value="This randomly does not pick up the issue. Better that way, I'm hoping future changes will find the cause. Every other test works 100%")
    public void testRedundantRows001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withNumericColumn("application", "LoanApplication", "amount", ">").withNumericColumn("application", "LoanApplication", "amount", "<=").withNumericColumn("application", "LoanApplication", "lengthYears", "==").withNumericColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Numeric").withActionSetField("application", "approvedRate", "Numeric").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRedundantRows002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRedundantRows003() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withEnumColumn("income", "IncomeSource", "type", "==", "Asset,Job").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRedundantConditions001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withEnumColumn("a", "Person", "name", "==", "Toni,Eder").withConditionIntegerColumn("a", "Person", "name", "==").withData(new Object[][]{{1, "description", "Toni", "Toni"}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("RedundantConditions", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRedundantRowsWithConflict() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionDoubleColumn("d", "Account", "deposit", "<").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, 0.0, true, true}, {2, "description", 100, 0.0, true, false}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(1)", this.analyzerProvider.getAnalysisReport());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo(2)", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRedundantActionsInOneRow001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("ValueForFactFieldIsSetTwice(a, salary)", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRedundantActionsInOneRow002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionInsertFact("Person", "b", "salary", "Integer").withActionSetField("b", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).buildTable();
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertContains("ValueForFactFieldIsSetTwice(b, salary)", this.analyzerProvider.getAnalysisReport());
    }
}

