/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalyzerUpdateTestBase;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerUpdateTest
extends AnalyzerUpdateTestBase {
    @Test
    public void updateRetract() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withRetract().withData(DataBuilderProvider.row(1, null).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
        this.setValue(0, 3, "a");
        TestUtil.assertDoesNotContain("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRowValueChange() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(1, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
        this.setValue(1, 2, 0);
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
    }

    @Test
    public void testRemoveRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).row(1, 1, false).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("ConflictingRows", this.analyzerProvider.getAnalysisReport(), 4);
        TestUtil.assertContains("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 2);
        this.removeRow(1);
        TestUtil.assertContains("ConflictingRows", this.analyzerProvider.getAnalysisReport(), 3);
        TestUtil.assertDoesNotContain("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 3);
        this.setValue(1, 3, 1);
        TestUtil.assertContains("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRemoveRow2() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withPersonAgeColumn("<").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 10, true).row(1, 10, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
        this.removeRow(0);
        TestUtil.assertDoesNotContain("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRemoveColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
        this.removeActionColumn(3, 0);
        TestUtil.assertContains("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testAddColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
        this.appendActionColumn(4, ExtendedGuidedDecisionTableBuilder.createActionSetField("a", "approved", "Boolean"), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        TestUtil.assertContains("MultipleValuesForOneAction", this.analyzerProvider.getAnalysisReport(), 3);
    }

    @Test
    public void testAddBRLColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
        this.insertConditionColumn(3, ExtendedGuidedDecisionTableBuilder.createBRLConditionColumn(), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        TestUtil.assertDoesNotContain("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testInsertRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).end()).buildTable();
        this.fireUpAnalyzer();
        this.insertRow(0);
        TestUtil.assertContains("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 3);
    }

    @Test
    public void testAppendRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 2);
        this.appendRow(DataType.DataTypes.NUMERIC, DataType.DataTypes.NUMERIC, DataType.DataTypes.STRING);
        TestUtil.assertContains("ImpossibleMatch", this.analyzerProvider.getAnalysisReport(), 2);
    }
}

