/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.DtableRuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DtableRuleInspectorCacheTest {
    private DtableRuleInspectorCache cache;
    private GuidedDecisionTable52 table52;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(0, 1, true).row(0, 1, true).row(0, 1, true).row(0, 1, true).row(0, 1, false).row(0, 1, true).row(0, 1, true).end()).buildTable();
        this.cache = this.analyzerProvider.getCache(this.table52);
    }

    @Test
    public void testInit() throws Exception {
        Assert.assertEquals((long)7L, (long)this.cache.all().size());
    }

    @Test
    public void testRemoveRow() throws Exception {
        this.cache.removeRow(3);
        Collection all = this.cache.all();
        Assert.assertEquals((long)6L, (long)all.size());
        this.assertContainsRowNumbers(all, 0, 1, 2, 3, 4, 5);
    }

    private void assertContainsRowNumbers(Collection<RuleInspector> all, int ... numbers) {
        ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
        for (RuleInspector ruleInspector : all) {
            int rowIndex = ruleInspector.getRowIndex();
            rowNumbers.add(rowIndex);
        }
        for (Object number : (Object)numbers) {
            Assert.assertTrue((String)rowNumbers.toString(), (boolean)rowNumbers.contains((int)number));
        }
    }

    @Test
    public void testRemoveColumn() throws Exception {
        this.table52.getActionCols().clear();
        ((List)this.table52.getData().get(0)).remove(4);
        ((List)this.table52.getData().get(1)).remove(4);
        ((List)this.table52.getData().get(2)).remove(4);
        ((List)this.table52.getData().get(3)).remove(4);
        ((List)this.table52.getData().get(4)).remove(4);
        ((List)this.table52.getData().get(5)).remove(4);
        ((List)this.table52.getData().get(6)).remove(4);
        this.cache.deleteColumns(4, 1);
        Collection all = this.cache.all();
        Assert.assertEquals((long)7L, (long)all.size());
        for (RuleInspector ruleInspector : all) {
            Assert.assertFalse((boolean)ruleInspector.atLeastOneActionHasAValue());
        }
    }
}

