/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import java.util.ArrayList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnDeleted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnInserted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AnalyzerControllerImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.ValidateEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnalyzerControllerImplTest {
    @Mock
    DecisionTableAnalyzer analyzer;
    @Mock
    EventBus eventBus;
    private AnalyzerControllerImpl controller;

    @Before
    public void setUp() throws Exception {
        this.controller = new AnalyzerControllerImpl(this.analyzer, this.eventBus);
    }

    @Test
    public void areHandlersAreSetUp() throws Exception {
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(ValidateEvent.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(DeleteRowEvent.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(AfterColumnDeleted.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(UpdateColumnDataEvent.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(AppendRowEvent.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(InsertRowEvent.TYPE, (EventHandler)this.controller);
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(AfterColumnInserted.TYPE, (EventHandler)this.controller);
    }

    @Test
    public void start() throws Exception {
        this.controller.initialiseAnalysis();
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).start();
    }

    @Test
    public void terminate() throws Exception {
        this.controller.terminateAnalysis();
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).terminate();
    }

    @Test
    public void analyze() throws Exception {
        ArrayList updates = new ArrayList();
        this.controller.onValidate(new ValidateEvent(updates));
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).analyze(updates);
    }

    @Test
    public void deleteColumns() throws Exception {
        this.controller.onAfterDeletedColumn(new AfterColumnDeleted(1, 2));
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).deleteColumns(1, 2);
    }

    @Test
    public void appendRow() throws Exception {
        this.controller.onAppendRow(new AppendRowEvent());
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).appendRow();
    }

    @Test
    public void deleteRow() throws Exception {
        this.controller.onDeleteRow(new DeleteRowEvent(10));
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).deleteRow(10);
    }

    @Test
    public void insertRow() throws Exception {
        this.controller.onInsertRow(new InsertRowEvent(10));
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).insertRow(10);
    }

    @Test
    public void updateColumns() throws Exception {
        ArrayList<Object> columnData = new ArrayList<Object>();
        columnData.add(Mockito.mock(CellValue.class));
        this.controller.onUpdateColumnData(new UpdateColumnDataEvent(10, columnData));
        ((DecisionTableAnalyzer)Mockito.verify((Object)this.analyzer)).updateColumns(1);
    }
}

