/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerFromFileTest;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.junit.Assert;

public class TestUtil {
    public static String loadResource(String name) throws Exception {
        InputStream in = DecisionTableAnalyzerFromFileTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    public static void assertOnlyContains(AnalysisReport result, String ... expected) {
        if (result.getAnalysisData().isEmpty()) {
            Assert.fail((String)"Data is empty.");
        }
        for (Issue issue : result.getAnalysisData()) {
            if (TestUtil.contains(expected, issue.getTitle())) continue;
            Assert.fail((String)("Should not find: " + issue.getTitle()));
        }
    }

    private static boolean contains(String[] expected, String title) {
        for (String item : expected) {
            if (!title.contains(item)) continue;
            return true;
        }
        return false;
    }

    public static void assertContains(String expected, AnalysisReport result) {
        boolean foundIt = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!issue.getTitle().contains(expected)) continue;
            foundIt = true;
            break;
        }
        Assert.assertTrue((String)("Could not find " + expected), (boolean)foundIt);
    }

    public static void assertDoesNotContain(String notExpected, AnalysisReport result) {
        boolean foundIt = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!issue.getTitle().contains(notExpected)) continue;
            foundIt = true;
            break;
        }
        Assert.assertFalse((String)("Found " + notExpected), (boolean)foundIt);
    }

    public static void assertDoesNotContain(String notExpected, AnalysisReport result, int rowNumber) {
        boolean foundOne = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!TestUtil.containsRowNumber(rowNumber, issue) || !issue.getTitle().contains(notExpected)) continue;
            foundOne = true;
            break;
        }
        Assert.assertFalse((String)("Found " + notExpected), (boolean)foundOne);
    }

    public static void assertContains(String expected, AnalysisReport result, int rowNumber) {
        boolean foundOne = false;
        for (Issue issue : result.getAnalysisData()) {
            if (!TestUtil.containsRowNumber(rowNumber, issue) || !issue.getTitle().contains(expected)) continue;
            foundOne = true;
            break;
        }
        Assert.assertTrue((String)("Could not find " + expected + " from: " + result.toString()), (boolean)foundOne);
    }

    private static boolean containsRowNumber(int rowNumber, Issue issue) {
        for (Integer number : issue.getRowNumbers()) {
            if (rowNumber != number) continue;
            return true;
        }
        return false;
    }
}

