/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.IntegerUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class ConditionColumnSynchronizerTest
extends BaseSynchronizerTest {
    @Override
    protected AsyncPackageDataModelOracle getOracle() {
        AsyncPackageDataModelOracle oracle = super.getOracle();
        oracle.addModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Applicant", new ModelField[]{new ModelField("this", "Applicant", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "Applicant"), new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "Integer"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "String"), new ModelField("approved", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "Boolean")});
                this.put("Address", new ModelField[]{new ModelField("this", "Address", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "Address"), new ModelField("state", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "String"), new ModelField("country", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "String")});
            }
        });
        return oracle;
    }

    @Test
    public void testAppend1() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
    }

    @Test
    public void testAppend2() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition1);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col1");
        condition2.setFactField("name");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
    }

    @Test
    public void testAppend3() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("country");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern2, condition2);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
    }

    @Test
    public void testAppendBoolean() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("approved");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof BooleanUiColumn));
        this.modelSynchronizer.appendRow();
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getBooleanValue());
        Assert.assertFalse((boolean)((Boolean)((GridCell)this.uiModel.getRow(0).getCells().get(2)).getValue().getValue()));
    }

    @Test
    public void testUpdate1() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)new Pattern52());
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)new ConditionCol52());
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setBoundName("$a");
        editedPattern.setFactType("Applicant");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("name");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof StringUiColumn));
    }

    @Test
    public void testUpdate2() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)new Pattern52());
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)new ConditionCol52());
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition1);
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("name");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setBoundName("$a2");
        editedPattern.setFactType("Applicant");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("age");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a2").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof StringUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
    }

    @Test
    public void testUpdate3() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)new Pattern52());
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)new ConditionCol52());
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("name");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern1, condition2);
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setBoundName("$d");
        editedPattern.setFactType("Address");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("country");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)3L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof StringUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
    }

    @Test
    public void testUpdate4() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)new Pattern52());
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)new ConditionCol52());
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setBoundName("$d");
        editedPattern.setFactType("Address");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("country");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)3L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof StringUiColumn));
    }

    @Test
    public void testUpdate5() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)new Pattern52());
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)new ConditionCol52());
        condition1.setConstraintValueType(1);
        condition1.setFactField("age");
        condition1.setOperator("==");
        condition1.setHeader("age");
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setBoundName("$a");
        editedPattern.setFactType("Applicant");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setConstraintValueType(1);
        editedCondition.setFactField("age");
        editedCondition.setOperator("==");
        editedCondition.setHideColumn(true);
        editedCondition.setHeader("updated");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(2) instanceof IntegerUiColumn));
        Assert.assertEquals((Object)false, (Object)((GridColumn)this.uiModel.getColumns().get(2)).isVisible());
        Assert.assertEquals((Object)"updated", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(2)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testDelete1() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition);
        Assert.assertEquals((long)2L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)0L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testDelete2() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition1);
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("name");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition1);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testDelete3() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setConstraintValueType(1);
        condition1.setHeader("col1");
        condition1.setFactField("age");
        condition1.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("country");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern2, condition2);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition1);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testMoveColumnTo_MoveLeft() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 column1 = new ConditionCol52();
        column1.setConstraintValueType(1);
        column1.setFactField("age");
        column1.setOperator("==");
        column1.setHeader("age");
        ConditionCol52 column2 = new ConditionCol52();
        column2.setConstraintValueType(1);
        column2.setFactField("name");
        column2.setOperator("==");
        column2.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(2, uiModelColumn2_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveRight() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 column1 = new ConditionCol52();
        column1.setConstraintValueType(1);
        column1.setFactField("age");
        column1.setOperator("==");
        column1.setHeader("age");
        ConditionCol52 column2 = new ConditionCol52();
        column2.setConstraintValueType(1);
        column2.setFactField("name");
        column2.setOperator("==");
        column2.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn1_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds_OutOfConditions() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 column1 = new ConditionCol52();
        column1.setConstraintValueType(1);
        column1.setFactField("age");
        column1.setOperator("==");
        column1.setHeader("age");
        ConditionCol52 column2 = new ConditionCol52();
        column2.setConstraintValueType(1);
        column2.setFactField("name");
        column2.setOperator("==");
        column2.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(0, uiModelColumn1_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds_OutOfPattern() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        ConditionCol52 column2p1 = new ConditionCol52();
        column2p1.setConstraintValueType(1);
        column2p1.setFactField("name");
        column2p1.setOperator("==");
        column2p1.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$a2");
        pattern2.setFactType("Applicant");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("name");
        column1p2.setOperator("==");
        column1p2.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Fred"));
        this.uiModel.setCell(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1.get(1));
        List conditionColumns2_1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_1.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Fred", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Fred", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(4, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2.get(1));
        List conditionColumns2_2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_2.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Fred", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Fred", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_SingleColumnPattern() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$a2");
        pattern2.setFactType("Applicant");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("name");
        column1p2.setOperator("==");
        column1p2.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1.get(0));
        List conditionColumns2_1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_1.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2.get(0));
        List conditionColumns2_2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns2_2.get(0));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveLeft() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        ConditionCol52 column2p1 = new ConditionCol52();
        column2p1.setConstraintValueType(1);
        column2p1.setFactField("name");
        column2p1.setOperator("==");
        column2p1.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCell(0, 4, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCell(0, 5, (GridCellValue)new BaseGridCellValue((Object)"America"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        final GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(4);
        final GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(2, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn3_1);
                this.add(uiModelColumn4_1);
            }
        });
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveLeft_MidPoint() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        ConditionCol52 column2p1 = new ConditionCol52();
        column2p1.setConstraintValueType(1);
        column2p1.setFactField("name");
        column2p1.setOperator("==");
        column2p1.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        Pattern52 pattern3 = new Pattern52();
        pattern3.setBoundName("$d2");
        pattern3.setFactType("Address");
        ConditionCol52 column1p3 = new ConditionCol52();
        column1p3.setConstraintValueType(1);
        column1p3.setFactField("state");
        column1p3.setOperator("==");
        column1p3.setHeader("state");
        ConditionCol52 column2p3 = new ConditionCol52();
        column2p3.setConstraintValueType(1);
        column2p3.setFactField("country");
        column2p3.setOperator("==");
        column2p3.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern3, column1p3);
        this.modelSynchronizer.appendColumn(pattern3, column2p3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCell(0, 4, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCell(0, 5, (GridCellValue)new BaseGridCellValue((Object)"America"));
        this.uiModel.setCell(0, 6, (GridCellValue)new BaseGridCellValue((Object)"Essex"));
        this.uiModel.setCell(0, 7, (GridCellValue)new BaseGridCellValue((Object)"England"));
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        List conditionColumns1_1p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_1p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_1p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((long)8L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(5);
        final GridColumn uiModelColumn5_1 = (GridColumn)this.uiModel.getColumns().get(6);
        final GridColumn uiModelColumn6_1 = (GridColumn)this.uiModel.getColumns().get(7);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn5_1.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn6_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(4, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn5_1);
                this.add(uiModelColumn6_1);
            }
        });
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_2p3 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_2p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_2p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((long)8L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn5_2 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn6_2 = (GridColumn)this.uiModel.getColumns().get(7);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_2 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn5_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn6_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveRight() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        ConditionCol52 column2p1 = new ConditionCol52();
        column2p1.setConstraintValueType(1);
        column2p1.setFactField("name");
        column2p1.setOperator("==");
        column2p1.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCell(0, 4, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCell(0, 5, (GridCellValue)new BaseGridCellValue((Object)"America"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        final GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(5, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1_1);
                this.add(uiModelColumn2_1);
            }
        });
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveRight_MidPoint() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setBoundName("$a");
        pattern1.setFactType("Applicant");
        ConditionCol52 column1p1 = new ConditionCol52();
        column1p1.setConstraintValueType(1);
        column1p1.setFactField("age");
        column1p1.setOperator("==");
        column1p1.setHeader("age");
        ConditionCol52 column2p1 = new ConditionCol52();
        column2p1.setConstraintValueType(1);
        column2p1.setFactField("name");
        column2p1.setOperator("==");
        column2p1.setHeader("name");
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setBoundName("$d");
        pattern2.setFactType("Address");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        Pattern52 pattern3 = new Pattern52();
        pattern3.setBoundName("$d2");
        pattern3.setFactType("Address");
        ConditionCol52 column1p3 = new ConditionCol52();
        column1p3.setConstraintValueType(1);
        column1p3.setFactField("state");
        column1p3.setOperator("==");
        column1p3.setHeader("state");
        ConditionCol52 column2p3 = new ConditionCol52();
        column2p3.setConstraintValueType(1);
        column2p3.setFactField("country");
        column2p3.setOperator("==");
        column2p3.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern3, column1p3);
        this.modelSynchronizer.appendColumn(pattern3, column2p3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCell(0, 3, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCell(0, 4, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCell(0, 5, (GridCellValue)new BaseGridCellValue((Object)"America"));
        this.uiModel.setCell(0, 6, (GridCellValue)new BaseGridCellValue((Object)"Essex"));
        this.uiModel.setCell(0, 7, (GridCellValue)new BaseGridCellValue((Object)"England"));
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        List conditionColumns1_1p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_1p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_1p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((long)8L, (long)this.uiModel.getColumns().size());
        final GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(2);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn5_1 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn6_1 = (GridColumn)this.uiModel.getColumns().get(7);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_1 instanceof StringUiColumn));
        Assert.assertEquals((long)2L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn5_1.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn6_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(5, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1_1);
                this.add(uiModelColumn2_1);
            }
        });
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        List conditionColumns1_2p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_2p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_2p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((long)8L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(2);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn5_2 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn6_2 = (GridColumn)this.uiModel.getColumns().get(7);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_2 instanceof StringUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)2L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn5_2.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn6_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_2.getIndex())).getValue().getValue());
    }
}

