/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnUtilitiesTest {
    private static final String FACT_TYPE = "MyFactType";
    private static final String FIELD_NAME = "myField";
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    private Pattern52 pattern;
    private ConditionCol52 column;
    private ColumnUtilities utilities;

    @Before
    public void setUp() {
        this.utilities = new ColumnUtilities(this.model, this.oracle);
        this.pattern = new Pattern52();
        this.column = new ConditionCol52();
        Mockito.when((Object)this.model.getPattern(this.column)).thenReturn((Object)this.pattern);
    }

    @Test
    public void getTypeSafeType_operatorIn() {
        this.column.setOperator("in");
        this.check();
    }

    @Test
    public void getTypeSafeType_operatorNotIn() {
        this.column.setOperator("not in");
        this.check();
    }

    @Test
    public void unknownDataTypeDefaultsToString() {
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    @Test
    public void knownDataTypeWithoutOperator() {
        this.pattern.setFactType(FACT_TYPE);
        this.column.setFactField(FIELD_NAME);
        this.column.setOperator(null);
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    @Test
    public void knownDataTypeWithOperator() {
        this.pattern.setFactType(FACT_TYPE);
        this.column.setFactField(FIELD_NAME);
        this.column.setOperator("==");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)FACT_TYPE), (String)Mockito.eq((Object)FIELD_NAME))).thenReturn((Object)"Integer");
        Assert.assertEquals((Object)"Integer", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    private void check() {
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)this.utilities.getTypeSafeType(this.pattern, this.column));
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)this.utilities.getTypeSafeType((BaseColumn)this.column));
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle, (VerificationMode)Mockito.never())).getFieldType(Matchers.anyString(), Matchers.anyString());
    }
}

