/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.rule.client.editor.ModellerWidgetFactory;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModelEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConfiguration;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.template.client.editor.TemplateModellerWidgetFactory;
import org.gwtbootstrap3.client.shared.event.ModalHideEvent;
import org.gwtbootstrap3.client.shared.event.ModalHideHandler;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractBRLColumnViewImpl<T, C extends BaseColumn>
extends BaseModal
implements RuleModelEditor,
TemplateVariablesChangedEvent.Handler {
    protected int MIN_WIDTH = 500;
    @UiField(provided=true)
    RuleModeller ruleModeller;
    @UiField
    TextBox txtColumnHeader;
    @UiField
    CheckBox chkHideColumn;
    @UiField
    ScrollPanel brlEditorContainer;
    private static AbstractBRLColumnEditorBinder uiBinder = (AbstractBRLColumnEditorBinder)GWT.create(AbstractBRLColumnEditorBinder.class);
    protected final GuidedDecisionTable52 model;
    protected final GuidedDecisionTableView.Presenter presenter;
    private final Command cmdOK = new Command(){

        public void execute() {
            AbstractBRLColumnViewImpl.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            AbstractBRLColumnViewImpl.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);
    protected final BRLColumn<T, C> editingCol;
    protected final BRLColumn<T, C> originalCol;
    protected final RuleModel ruleModel;
    protected final EventBus eventBus;
    protected final boolean isNew;

    public AbstractBRLColumnViewImpl(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, EventBus eventBus, BRLColumn<T, C> column, boolean isNew, boolean isReadOnly) {
        this.model = model;
        this.presenter = presenter;
        this.eventBus = eventBus;
        this.originalCol = column;
        this.isNew = isNew;
        this.editingCol = this.cloneBRLColumn(column);
        this.ruleModel = this.getRuleModel(this.editingCol);
        TemplateModellerWidgetFactory widgetFactory = new TemplateModellerWidgetFactory();
        this.ruleModeller = new RuleModeller(this.ruleModel, oracle, (ModellerWidgetFactory)widgetFactory, this.getRuleModellerConfiguration(), eventBus, isReadOnly);
        this.setWidth(this.getPopupWidth() + "px");
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        presenter.getPackageParentRuleNames(new ParameterizedCommand<Collection<String>>(){

            public void execute(Collection<String> ruleNames) {
                AbstractBRLColumnViewImpl.this.ruleModeller.setRuleNamesForPackage(ruleNames);
            }
        });
        this.brlEditorContainer.setHeight("100%");
        this.brlEditorContainer.setWidth("100%");
        this.txtColumnHeader.setText(this.editingCol.getHeader());
        this.txtColumnHeader.setEnabled(!isReadOnly);
        this.chkHideColumn.setValue(Boolean.valueOf(this.editingCol.isHideColumn()));
        this.footer.enableOkButton(!isReadOnly);
    }

    public void show() {
        final HandlerRegistration registration = this.eventBus.addHandler(TemplateVariablesChangedEvent.TYPE, (EventHandler)this);
        this.addHideHandler(new ModalHideHandler(){

            public void onHide(ModalHideEvent hideEvent) {
                registration.removeHandler();
            }
        });
        super.show();
    }

    protected abstract boolean isHeaderUnique(String var1);

    protected abstract RuleModel getRuleModel(BRLColumn<T, C> var1);

    protected abstract RuleModellerConfiguration getRuleModellerConfiguration();

    protected abstract void doInsertColumn();

    protected abstract void doUpdateColumn();

    protected abstract List<C> convertInterpolationVariables(Map<InterpolationVariable, Integer> var1);

    protected abstract BRLColumn<T, C> cloneBRLColumn(BRLColumn<T, C> var1);

    public RuleModeller getRuleModeller() {
        return this.ruleModeller;
    }

    private int getPopupWidth() {
        int w = (int)((double)Window.getClientWidth() * 0.5);
        if (w < this.MIN_WIDTH) {
            w = this.MIN_WIDTH;
        }
        return w;
    }

    @UiHandler(value={"txtColumnHeader"})
    void columnHanderChangeHandler(ChangeEvent event) {
        this.editingCol.setHeader(this.txtColumnHeader.getText());
    }

    @UiHandler(value={"chkHideColumn"})
    void hideColumnClickHandler(ClickEvent event) {
        this.editingCol.setHideColumn(this.chkHideColumn.getValue().booleanValue());
    }

    private void applyChanges() {
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.isNew) {
            if (!this.isHeaderUnique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
            this.getDefinedVariables(this.ruleModel);
            this.doInsertColumn();
        } else {
            if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.isHeaderUnique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
            this.getDefinedVariables(this.ruleModel);
            this.doUpdateColumn();
        }
        this.hide();
    }

    public void onTemplateVariablesChanged(TemplateVariablesChangedEvent event) {
        if (event.getSource() == this.ruleModel) {
            this.getDefinedVariables(event.getModel());
        }
    }

    private boolean getDefinedVariables(RuleModel ruleModel) {
        HashMap<InterpolationVariable, Integer> ivs = new HashMap<InterpolationVariable, Integer>();
        RuleModelVisitor rmv = new RuleModelVisitor(ivs);
        rmv.visit((Object)ruleModel);
        this.editingCol.setChildColumns(this.convertInterpolationVariables(ivs));
        return ivs.size() > 0;
    }

    static interface AbstractBRLColumnEditorBinder
    extends UiBinder<Widget, AbstractBRLColumnViewImpl> {
    }
}

