/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionRetractFactPopup
extends FormStylePopup {
    private final GuidedDecisionTable52 model;
    private final BRLRuleModel rm;
    private final GuidedDecisionTableView.Presenter presenter;
    private final ActionRetractFactCol52 editingCol;
    private final ActionColumnCommand refreshGrid;
    private final ActionRetractFactCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;
    private final Command cmdOK = new Command(){

        public void execute() {
            ActionRetractFactPopup.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ActionRetractFactPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);

    public ActionRetractFactPopup(GuidedDecisionTable52 model, GuidedDecisionTableView.Presenter presenter, ActionColumnCommand refreshGrid, ActionRetractFactCol52 column, boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ColumnConfigurationDeleteAFact());
        this.rm = new BRLRuleModel(model);
        this.model = model;
        this.presenter = presenter;
        this.editingCol = this.cloneActionRetractColumn(column);
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            final LimitedEntryActionRetractFactCol52 ler = (LimitedEntryActionRetractFactCol52)this.editingCol;
            final ListBox patterns = this.loadBoundFacts(ler.getValue().getStringValue());
            patterns.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                patterns.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int index = patterns.getSelectedIndex();
                        if (index > -1) {
                            ler.getValue().setStringValue(patterns.getValue(index));
                        }
                    }
                });
            }
            this.addAttribute(GuidedDecisionTableConstants.INSTANCE.FactToDeleteColon(), (IsWidget)patterns);
        }
        final TextBox header = new TextBox();
        header.setText(column.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionRetractFactPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer.enableOkButton(!isReadOnly);
        this.add((Widget)this.footer);
    }

    private void applyChanges() {
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        this.refreshGrid.execute((ActionCol52)this.editingCol);
        this.hide();
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private ActionRetractFactCol52 cloneActionRetractColumn(ActionRetractFactCol52 col) {
        LimitedEntryActionRetractFactCol52 clone = null;
        if (col instanceof LimitedEntryCol) {
            clone = new LimitedEntryActionRetractFactCol52();
            DTCellValue52 dcv = new DTCellValue52(((LimitedEntryCol)col).getValue().getStringValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionRetractFactCol52();
        }
        clone.setHeader(col.getHeader());
        clone.setHideColumn(col.isHideColumn());
        return clone;
    }

    private ListBox loadBoundFacts(String binding) {
        ListBox listBox = new ListBox();
        listBox.addItem(GuidedDecisionTableConstants.INSTANCE.Choose());
        List factBindings = this.rm.getLHSBoundFacts();
        for (int index = 0; index < factBindings.size(); ++index) {
            String boundName = (String)factBindings.get(index);
            if ("".equals(boundName)) continue;
            listBox.addItem(boundName);
            if (!boundName.equals(binding)) continue;
            listBox.setSelectedIndex(index + 1);
        }
        listBox.setEnabled(listBox.getItemCount() > 1);
        if (listBox.getItemCount() == 1) {
            listBox.clear();
            listBox.addItem(GuidedDecisionTableConstants.INSTANCE.NoPatternBindingsAvailable());
        }
        return listBox;
    }
}

