/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionWorkItemSetFieldPopup
extends FormStylePopup {
    private SmallLabel bindingLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private ListBox workItemResultParameters = new ListBox();
    private Map<String, WorkItemParameter> workItemResultParametersMap = new HashMap<String, WorkItemParameter>();
    private final GuidedDecisionTable52 model;
    private final ActionWorkItemSetFieldCol52 editingCol;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableView.Presenter presenter;
    private final ActionColumnCommand refreshGrid;
    private final ActionWorkItemSetFieldCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;
    private final Command cmdOK = new Command(){

        public void execute() {
            ActionWorkItemSetFieldPopup.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ActionWorkItemSetFieldPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);

    public ActionWorkItemSetFieldPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ActionColumnCommand refreshGrid, ActionWorkItemSetFieldCol52 column, boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ColumnConfigurationWorkItemSetField());
        this.editingCol = this.cloneActionSetColumn(column);
        this.model = model;
        this.oracle = oracle;
        this.presenter = presenter;
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.bindingLabel);
        this.doBindingLabel();
        Image edit = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        edit.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        Image editDisabled = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        editDisabled.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        ImageButton changePattern = new ImageButton(edit, editDisabled, GuidedDecisionTableConstants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionWorkItemSetFieldPopup.this.showChangeFact(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Fact() + ":", (IsWidget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = this.createEditField();
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(column.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionWorkItemSetFieldPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.UpdateEngineWithChanges() + ":", (IsWidget)this.doUpdate());
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.BindActionFieldToWorkItem(), (IsWidget)this.doBindFieldToWorkItem());
        if (!isReadOnly) {
            this.workItemResultParameters.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int index = ActionWorkItemSetFieldPopup.this.workItemResultParameters.getSelectedIndex();
                    if (index >= 0) {
                        String key = ActionWorkItemSetFieldPopup.this.workItemResultParameters.getValue(index);
                        WorkItemParameter wip = (WorkItemParameter)ActionWorkItemSetFieldPopup.this.workItemResultParametersMap.get(key);
                        ActionWorkItemSetFieldPopup.this.editingCol.setWorkItemName(wip.workDefinition.getName());
                        ActionWorkItemSetFieldPopup.this.editingCol.setWorkItemResultParameterName(wip.workParameterDefinition.getName());
                        ActionWorkItemSetFieldPopup.this.editingCol.setParameterClassName(wip.workParameterDefinition.getClassName());
                    }
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer.enableOkButton(!isReadOnly);
        this.add((Widget)this.footer);
    }

    private void applyChanges() {
        if (!this.isValidFactType()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnFact());
            return;
        }
        if (!this.isValidFactField()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnField());
            return;
        }
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        this.refreshGrid.execute((ActionCol52)this.editingCol);
        this.hide();
    }

    private ImageButton createEditField() {
        Image edit = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        edit.setAltText(GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        Image editDisabled = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        editDisabled.setAltText(GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        return new ImageButton(edit, editDisabled, GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionWorkItemSetFieldPopup.this.showFieldChange();
            }
        });
    }

    private ActionWorkItemSetFieldCol52 cloneActionSetColumn(ActionWorkItemSetFieldCol52 col) {
        ActionWorkItemSetFieldCol52 clone = new ActionWorkItemSetFieldCol52();
        clone.setBoundName(col.getBoundName());
        clone.setFactField(col.getFactField());
        clone.setHeader(col.getHeader());
        clone.setType(col.getType());
        clone.setValueList(col.getValueList());
        clone.setUpdate(col.isUpdate());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setWorkItemName(col.getWorkItemName());
        clone.setWorkItemResultParameterName(col.getWorkItemResultParameterName());
        clone.setParameterClassName(col.getParameterClassName());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void doBindingLabel() {
        if (this.editingCol.getBoundName() != null) {
            this.bindingLabel.setText("" + this.editingCol.getBoundName());
        } else {
            this.bindingLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseABoundFactForThisColumn());
        }
    }

    private void doFieldLabel() {
        if (this.editingCol.getFactField() != null) {
            this.fieldLabel.setText(this.editingCol.getFactField());
        } else {
            this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseAFactPatternFirst());
        }
    }

    private Widget doUpdate() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isUpdate()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionWorkItemSetFieldPopup.this.oracle.isGlobalVariable(ActionWorkItemSetFieldPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionWorkItemSetFieldPopup.this.editingCol.setUpdate(false);
                    } else {
                        ActionWorkItemSetFieldPopup.this.editingCol.setUpdate(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.UpdateFact(), GuidedDecisionTableConstants.INSTANCE.UpdateDescription()));
        return hp;
    }

    private Widget doBindFieldToWorkItem() {
        this.workItemResultParameters.clear();
        this.workItemResultParametersMap.clear();
        ArrayList<PortableWorkDefinition> actionWorkItems = new ArrayList<PortableWorkDefinition>();
        for (ActionCol52 ac : this.model.getActionCols()) {
            if (!(ac instanceof ActionWorkItemCol52)) continue;
            PortableWorkDefinition pwd = ((ActionWorkItemCol52)ac).getWorkItemDefinition();
            actionWorkItems.add(pwd);
        }
        if (actionWorkItems.isEmpty()) {
            this.workItemResultParameters.setEnabled(false);
            this.workItemResultParameters.addItem(GuidedDecisionTableConstants.INSTANCE.NoWorkItemsAvailable());
            this.editingCol.setWorkItemName(null);
            this.editingCol.setWorkItemResultParameterName(null);
            this.editingCol.setParameterClassName(null);
        } else {
            int selectedItemIndex = -1;
            String selectedItemKey = this.editingCol.getWorkItemName() + "" + this.editingCol.getWorkItemResultParameterName();
            this.workItemResultParameters.setEnabled(!this.isReadOnly);
            for (PortableWorkDefinition pwd : actionWorkItems) {
                for (PortableParameterDefinition ppd : pwd.getResults()) {
                    if (!this.acceptParameterType(ppd)) continue;
                    String key = pwd.getName() + "" + ppd.getName();
                    String parameterDisplayName = pwd.getDisplayName() + "" + ppd.getName();
                    if (key.equals(selectedItemKey)) {
                        selectedItemIndex = this.workItemResultParameters.getItemCount();
                    }
                    this.workItemResultParametersMap.put(key, new WorkItemParameter(pwd, ppd));
                    this.workItemResultParameters.addItem(parameterDisplayName, key);
                }
            }
            if (this.workItemResultParameters.getItemCount() == 0) {
                this.workItemResultParameters.setEnabled(false);
                this.workItemResultParameters.addItem(GuidedDecisionTableConstants.INSTANCE.NoWorkItemsAvailable());
                this.editingCol.setWorkItemName(null);
                this.editingCol.setWorkItemResultParameterName(null);
                this.editingCol.setParameterClassName(null);
            } else {
                if (selectedItemIndex == -1) {
                    selectedItemIndex = 0;
                    selectedItemKey = this.workItemResultParameters.getValue(selectedItemIndex);
                    WorkItemParameter wip = this.workItemResultParametersMap.get(selectedItemKey);
                    this.editingCol.setWorkItemName(wip.workDefinition.getName());
                    this.editingCol.setWorkItemResultParameterName(wip.workParameterDefinition.getName());
                    this.editingCol.setParameterClassName(wip.workParameterDefinition.getClassName());
                }
                this.workItemResultParameters.setSelectedIndex(selectedItemIndex);
            }
        }
        return this.workItemResultParameters;
    }

    private boolean acceptParameterType(PortableParameterDefinition ppd) {
        if (this.nil(this.editingCol.getFactField())) {
            return false;
        }
        if (ppd.getClassName() == null) {
            return false;
        }
        Pattern52 p = this.model.getConditionPattern(this.editingCol.getBoundName());
        String fieldClassName = this.oracle.getFieldClassName(p.getFactType(), this.editingCol.getFactField());
        return fieldClassName.equals(ppd.getClassName());
    }

    private String getFactType() {
        if (this.oracle.isGlobalVariable(this.editingCol.getBoundName())) {
            return this.oracle.getGlobalVariable(this.editingCol.getBoundName());
        }
        return this.getFactType(this.editingCol.getBoundName());
    }

    private String getFactType(String boundName) {
        for (Pattern52 p : this.model.getPatterns()) {
            if (!p.getBoundName().equals(boundName)) continue;
            return p.getFactType();
        }
        return "";
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionWorkItemSetFieldPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadBoundFacts() {
        HashSet<String> facts = new HashSet<String>();
        for (Pattern52 p : this.model.getPatterns()) {
            if (p.isNegated()) continue;
            facts.add(p.getBoundName());
        }
        ListBox box = new ListBox();
        for (String b : facts) {
            box.addItem(b);
        }
        String[] globs = this.oracle.getGlobalVariables();
        for (int i = 0; i < globs.length; ++i) {
            box.addItem(globs[i]);
        }
        return box;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showChangeFact(ClickEvent w) {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        final ListBox pats = this.loadBoundFacts();
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseFact(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                String val = pats.getValue(pats.getSelectedIndex());
                ActionWorkItemSetFieldPopup.this.editingCol.setBoundName(val);
                ActionWorkItemSetFieldPopup.this.editingCol.setFactField(null);
                ActionWorkItemSetFieldPopup.this.doBindFieldToWorkItem();
                ActionWorkItemSetFieldPopup.this.doBindingLabel();
                ActionWorkItemSetFieldPopup.this.doFieldLabel();
                pop.hide();
                ActionWorkItemSetFieldPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemSetFieldPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        final ListBox box = new ListBox();
        final String factType = this.getFactType();
        this.oracle.getFieldCompletions(factType, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i].getName());
                }
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionWorkItemSetFieldPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionWorkItemSetFieldPopup.this.editingCol.setType(ActionWorkItemSetFieldPopup.this.oracle.getFieldType(factType, ActionWorkItemSetFieldPopup.this.editingCol.getFactField()));
                ActionWorkItemSetFieldPopup.this.doBindFieldToWorkItem();
                ActionWorkItemSetFieldPopup.this.doFieldLabel();
                pop.hide();
                ActionWorkItemSetFieldPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionWorkItemSetFieldPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean isValidFactType() {
        return this.editingCol.getBoundName() != null && !"".equals(this.editingCol.getBoundName());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }

    private static class WorkItemParameter {
        PortableWorkDefinition workDefinition;
        PortableParameterDefinition workParameterDefinition;

        WorkItemParameter(PortableWorkDefinition workDefinition, PortableParameterDefinition workParameterDefinition) {
            this.workDefinition = workDefinition;
            this.workParameterDefinition = workParameterDefinition;
        }
    }
}

