/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopupView;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.ModalFooterChangePattern;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ConditionPopup {
    protected ConditionPopupView view;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableView.Presenter presenter;
    private final DTCellValueWidgetFactory factory;
    private final Validator validator;
    private final BRLRuleModel rm;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;
    private final GuidedDecisionTable52 model;
    private Pattern52 editingPattern;
    private ConditionCol52 editingCol;
    private final ConditionColumnCommand refreshGrid;
    private final ConditionCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;

    public ConditionPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ConditionColumnCommand refreshGrid, ConditionCol52 col, boolean isNew, boolean isReadOnly) {
        this(model, oracle, presenter, refreshGrid, new Pattern52(), col, isNew, isReadOnly);
    }

    public ConditionPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ConditionColumnCommand refreshGrid, Pattern52 pattern, ConditionCol52 column, boolean isNew, boolean isReadOnly) {
        this.rm = new BRLRuleModel(model);
        this.editingPattern = pattern != null ? pattern.clonePattern() : null;
        this.editingCol = this.cloneConditionColumn(column);
        this.model = model;
        this.oracle = oracle;
        this.presenter = presenter;
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        this.validator = new Validator(model.getConditions());
        this.cellUtilities = new CellUtilities();
        this.columnUtilities = new ColumnUtilities(model, oracle);
        this.factory = DTCellValueWidgetFactory.getInstance(model, oracle, isReadOnly, this.allowEmptyValues());
        this.view = this.getWidgets();
        this.view.initializeView();
    }

    protected ConditionPopupView getWidgets() {
        return new ConditionPopupView(this);
    }

    public void show() {
        this.view.show();
    }

    public void applyChanges() {
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            this.view.warnAboutMissingColumnHeaderDescription();
            return;
        }
        if (this.editingCol.getConstraintValueType() != 5) {
            if (null == this.editingCol.getFactField() || "".equals(this.editingCol.getFactField())) {
                this.view.warnAboutMissingFactField();
                return;
            }
            if (this.editingCol.getOperator() == null) {
                this.view.warnAboutMissingOperator();
                return;
            }
        } else {
            this.editingCol.setOperator(null);
        }
        String factBinding = this.editingPattern.getBoundName();
        String fieldBinding = this.editingCol.getBinding();
        if (factBinding != null && fieldBinding != null && this.editingCol.isBound() && (!this.isBindingUnique(fieldBinding) || factBinding.compareTo(fieldBinding) == 0)) {
            this.view.warnAboutAlreadyUsedBinding();
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                this.view.warnAboutAlreadyUsedColumnHeaderName();
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            this.view.warnAboutAlreadyUsedColumnHeaderName();
            return;
        }
        if (this.editingCol.getConstraintValueType() != 1) {
            this.editingCol.setBinding(null);
        }
        this.refreshGrid.execute(this.editingPattern, this.editingCol);
        this.view.hide();
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ConditionCol52 cloneConditionColumn(ConditionCol52 col) {
        LimitedEntryConditionCol52 clone = null;
        if (col instanceof LimitedEntryConditionCol52) {
            clone = new LimitedEntryConditionCol52();
            DTCellValue52 dcv = this.cloneDTCellValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ConditionCol52();
        }
        clone.setConstraintValueType(col.getConstraintValueType());
        clone.setFactField(col.getFactField());
        clone.setFieldType(col.getFieldType());
        clone.setHeader(col.getHeader());
        clone.setOperator(col.getOperator());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setParameters(col.getParameters());
        clone.setWidth(col.getWidth());
        clone.setBinding(col.getBinding());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    public void makeLimitedValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.view.addLimitedEntryValue();
            if (!(this.editingCol instanceof LimitedEntryConditionCol52)) {
                return;
            }
            LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)this.editingCol;
            boolean doesOperatorNeedValue = this.validator.doesOperatorNeedValue(this.editingCol);
            if (!doesOperatorNeedValue) {
                this.view.setLimitedEntryVisibility(false);
                lec.setValue(null);
                return;
            }
            this.view.setLimitedEntryVisibility(true);
            if (lec.getValue() == null) {
                lec.setValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
            }
            this.view.setLimitedEntryWidget(this.factory.getWidget(this.editingPattern, this.editingCol, lec.getValue()));
        }
    }

    public void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.view.addDefaultValueIfNoPresent();
            if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
                return;
            }
            if (this.nil(this.editingCol.getFactField())) {
                this.view.setDefaultValueVisibility(false);
                return;
            }
            if (!this.validator.doesOperatorNeedValue(this.editingCol)) {
                this.view.setDefaultValueVisibility(false);
                return;
            }
            this.view.setDefaultValueVisibility(true);
            if (this.editingCol.getDefaultValue() == null) {
                this.editingCol.setDefaultValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
            }
            DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
            DataType.DataTypes dataType = this.columnUtilities.getDataType(this.editingPattern, this.editingCol);
            this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
            if (!this.validator.doesOperatorAcceptCommaSeparatedValues(this.editingCol)) {
                this.cellUtilities.removeCommaSeparatedValue(defaultValue);
            }
            this.view.setDefaultValueWidget(this.factory.getWidget(this.editingPattern, this.editingCol, defaultValue));
        }
    }

    public void applyConsTypeChange(int newConstraintValueType) {
        this.editingCol.setConstraintValueType(newConstraintValueType);
        this.initialiseViewForConstraintValueType();
    }

    public void initialiseViewForConstraintValueType() {
        this.view.enableBinding(this.editingCol.getConstraintValueType() == 1 && !this.isReadOnly);
        this.doFieldLabel();
        this.doValueList();
        this.doOperatorLabel();
        this.doImageButtons();
        this.makeDefaultValueWidget();
    }

    public void doImageButtons() {
        int constraintType = this.editingCol.getConstraintValueType();
        boolean enableField = !this.nil(this.editingPattern.getFactType()) && constraintType != 5 && !this.isReadOnly;
        boolean enableOp = !this.nil(this.editingCol.getFactField()) && constraintType != 5 && !this.isReadOnly;
        this.view.enableEditField(enableField);
        this.view.enableEditOperator(enableOp);
    }

    private boolean isBindingUnique(String binding) {
        return !this.rm.isVariableNameUsed(binding);
    }

    public void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            if (this.editingCol.getFactField() == null || this.editingCol.getFactField().equals("")) {
                this.view.setFieldLabelText(GuidedDecisionTableConstants.INSTANCE.notNeededForPredicate());
            } else {
                this.view.setFieldLabelText(this.editingCol.getFactField());
            }
            this.view.setFieldLabelDisplayStyle(Style.Display.INLINE);
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.view.setFieldLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAPatternFirst());
            this.view.setFieldLabelDisplayStyle(Style.Display.NONE);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.view.setFieldLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAField());
            this.view.setFieldLabelDisplayStyle(Style.Display.NONE);
        } else {
            this.view.setFieldLabelText(this.editingCol.getFactField());
        }
    }

    public void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.view.setOperatorLabelText(GuidedDecisionTableConstants.INSTANCE.notNeededForPredicate());
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.view.setOperatorLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.view.setOperatorLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.view.setOperatorLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAnOperator());
        } else {
            this.view.setOperatorLabelText(HumanReadable.getOperatorDisplayName((String)this.editingCol.getOperator()));
        }
    }

    public void doPatternLabel() {
        if (this.editingPattern.getFactType() != null) {
            StringBuilder patternLabel = new StringBuilder();
            String factType = this.editingPattern.getFactType();
            String boundName = this.editingPattern.getBoundName();
            if (factType != null && factType.length() > 0) {
                if (this.editingPattern.isNegated()) {
                    patternLabel.append(GuidedDecisionTableConstants.INSTANCE.negatedPattern()).append(" ").append(factType);
                } else {
                    patternLabel.append(factType).append(" [").append(boundName).append("]");
                }
            }
            this.view.setPatternLabelText(patternLabel.toString());
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    public void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = !this.isReadOnly && factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = this.validator.doesOperatorAcceptValueList(this.editingCol);
        }
        if (enableValueList) {
            enableValueList = !this.oracle.hasEnums(factType, factField);
        }
        this.view.enableValueListWidget(enableValueList);
        if (!enableValueList) {
            this.view.setValueListWidgetText("");
        } else {
            this.view.setValueListWidgetText(this.editingCol.getValueList());
        }
    }

    public void doCalculationType() {
        String factField;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        boolean hasEnums = this.oracle.hasEnums(factType, factField = this.editingCol.getFactField());
        this.view.enableLiteral(hasEnums || !this.isReadOnly);
        this.view.enableFormula(!hasEnums && !this.isReadOnly);
        this.view.enablePredicate(!hasEnums && !this.isReadOnly);
        if (hasEnums) {
            this.editingCol.setConstraintValueType(1);
        }
    }

    ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        int selectedIndex = -1;
        List availablePatterns = this.model.getPatterns();
        String editingPatternBinding = this.editingPattern == null ? null : this.editingPattern.getBoundName();
        for (int i = 0; i < availablePatterns.size(); ++i) {
            Pattern52 p = (Pattern52)availablePatterns.get(i);
            if (p.getBoundName().equals(editingPatternBinding)) {
                selectedIndex = i;
            }
            if (vars.contains(p.getBoundName())) continue;
            patterns.addItem((p.isNegated() ? GuidedDecisionTableConstants.INSTANCE.negatedPattern() + " " : "") + p.getFactType() + " [" + p.getBoundName() + "]", p.getFactType() + " " + p.getBoundName() + " " + p.isNegated());
            vars.add(p.getBoundName());
        }
        if (selectedIndex >= 0) {
            this.selectListBoxItem(patterns, selectedIndex);
        }
        return patterns;
    }

    void selectListBoxItem(ListBox listBox, int index) {
        listBox.setSelectedIndex(index);
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    public void showOperatorChange() {
        final String factType = this.editingPattern.getFactType();
        final String factField = this.editingCol.getFactField();
        this.oracle.getOperatorCompletions(factType, factField, (Callback)new Callback<String[]>(){

            public void callback(String[] ops) {
                ConditionPopup.this.doShowOperatorChange(factType, factField, ops);
            }
        });
    }

    private void doShowOperatorChange(String factType, String factField, String[] ops) {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.SetTheOperator());
        ArrayList<String> filteredOps = new ArrayList<String>();
        for (String op : ops) {
            filteredOps.add(op);
        }
        if (1 != this.editingCol.getConstraintValueType()) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        String[] displayOps = new String[filteredOps.size()];
        filteredOps.toArray(displayOps);
        final CEPOperatorsDropdown box = new CEPOperatorsDropdown(displayOps, (HasParameterizedOperator)this.editingCol);
        box.insertItem(GuidedDecisionTableConstants.INSTANCE.noOperator(), "", 1);
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Operator(), (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ConditionPopup.this.editingCol.setOperator(box.getValue(box.getSelectedIndex()));
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.doOperatorLabel();
                ConditionPopup.this.doValueList();
                pop.hide();
                ConditionPopup.this.view.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.view.enableFooter(true);
            }
        }));
        this.view.enableFooter(false);
        pop.show();
    }

    private boolean unique(String header) {
        for (CompositeColumn cc : this.model.getConditions()) {
            for (int iChild = 0; iChild < cc.getChildColumns().size(); ++iChild) {
                if (!((BaseColumn)cc.getChildColumns().get(iChild)).getHeader().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    public void showChangePattern(ClickEvent w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterChangePattern(this.getShowPatternOKCommand(pats, pop), () -> {
            pop.hide();
            this.showNewPatternDialog();
        }, () -> {
            pop.hide();
            this.view.enableFooter(true);
        }));
        this.view.enableFooter(false);
        pop.show();
    }

    Command getShowPatternOKCommand(ListBox pats, FormStylePopup pop) {
        return () -> {
            String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
            Optional<Pattern52> p = this.extractEditingPattern(val);
            this.editingPattern = p.orElseThrow(IllegalStateException::new);
            this.editingCol.setFactField(null);
            this.editingCol.setOperator(null);
            this.view.setEntryPointName(this.editingPattern.getEntryPointName());
            this.view.selectOperator(this.editingPattern.getWindow().getOperator());
            this.makeLimitedValueWidget();
            this.makeDefaultValueWidget();
            this.displayCEPOperators();
            this.doPatternLabel();
            this.doValueList();
            this.doCalculationType();
            this.doImageButtons();
            pop.hide();
            this.view.enableFooter(true);
        };
    }

    Optional<Pattern52> extractEditingPattern(String[] metadata) {
        String factType = metadata[0];
        String factBinding = metadata[1];
        boolean negated = Boolean.parseBoolean(metadata[2]);
        if (!negated) {
            return Optional.ofNullable(this.model.getConditionPattern(factBinding));
        }
        return this.model.getPatterns().stream().filter(Pattern52::isNegated).filter(p -> p.getFactType().equals(factType)).findFirst();
    }

    public void showFieldChange() {
        this.view.enableFooter(false);
        this.view.showFieldChangePopUp();
    }

    ListBox loadFields() {
        ListBox box = new ListBox();
        this.oracle.getFieldCompletions(this.editingPattern.getFactType(), FieldAccessorsAndMutators.ACCESSOR, fields -> {
            switch (this.editingCol.getConstraintValueType()) {
                case 1: {
                    int selectedIndex = -1;
                    for (int i = 0; i < ((ModelField[])fields).length; ++i) {
                        String fieldName = fields[i].getName();
                        if (fieldName.equals(this.editingCol.getFactField())) {
                            selectedIndex = i;
                        }
                        box.addItem(fields[i].getName());
                    }
                    if (selectedIndex < 0) break;
                    this.selectListBoxItem(box, selectedIndex);
                    break;
                }
                case 3: {
                    for (int i = 0; i < ((ModelField[])fields).length; ++i) {
                        String fieldName = fields[i].getName();
                        if (this.oracle.hasEnums(this.editingPattern.getFactType(), fieldName)) continue;
                        box.addItem(fieldName);
                    }
                    break;
                }
            }
        });
        return box;
    }

    protected void showNewPatternDialog() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.setTitle(GuidedDecisionTableConstants.INSTANCE.CreateANewFactPattern());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            types.addItem(this.oracle.getFactTypes()[i]);
        }
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.FactType(), (IsWidget)types);
        BindingTextBox binding = new BindingTextBox();
        binding.addChangeHandler(new ChangeHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onChange(ChangeEvent event) {
                this.val$binding.setText(this.val$binding.getText().replace(" ", ""));
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)binding);
        final CheckBox chkNegated = new CheckBox();
        chkNegated.addClickHandler(new ClickHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onClick(ClickEvent event) {
                boolean isPatternNegated = chkNegated.getValue();
                this.val$binding.setEnabled(!isPatternNegated);
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.negatePattern(), (IsWidget)chkNegated);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void execute() {
                String fn;
                boolean isPatternNegated = chkNegated.getValue();
                String ft = types.getItemText(types.getSelectedIndex());
                String string = fn = isPatternNegated ? "" : this.val$binding.getText();
                if (!isPatternNegated) {
                    if (fn.equals("")) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameForFact());
                        return;
                    }
                    if (fn.equals(ft)) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                        return;
                    }
                    if (!ConditionPopup.this.isBindingUnique(fn)) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                        return;
                    }
                }
                ConditionPopup.this.editingPattern = new Pattern52();
                ConditionPopup.this.editingPattern.setFactType(ft);
                ConditionPopup.this.editingPattern.setBoundName(fn);
                ConditionPopup.this.editingPattern.setNegated(isPatternNegated);
                ConditionPopup.this.editingCol.setFactField(null);
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.view.setEntryPointName(ConditionPopup.this.editingPattern.getEntryPointName());
                ConditionPopup.this.view.selectOperator(ConditionPopup.this.editingPattern.getWindow().getOperator());
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.displayCEPOperators();
                ConditionPopup.this.doPatternLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                ConditionPopup.this.doOperatorLabel();
                ConditionPopup.this.doImageButtons();
                this.val$pop.hide();
                ConditionPopup.this.view.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.view.enableFooter(true);
            }
        }));
        this.view.enableFooter(false);
        pop.show();
    }

    public void displayCEPOperators() {
        this.oracle.isFactTypeAnEvent(this.editingPattern.getFactType(), (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                ConditionPopup.this.view.setCepWindowVisibility(Boolean.TRUE.equals(result));
            }
        });
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.model.getTableFormat();
    }

    public int getConstraintValueType() {
        return this.editingCol.getConstraintValueType();
    }

    public void setFactField(String factField) {
        this.editingCol.setFactField(factField);
    }

    public Pattern52 getEditingPattern() {
        return this.editingPattern;
    }

    public String getHeader() {
        return this.editingCol.getHeader();
    }

    public void setHeader(String header) {
        this.editingCol.setHeader(header);
    }

    public String getValueList() {
        return this.editingCol.getValueList();
    }

    public void setValueList(String valueList) {
        this.editingCol.setValueList(valueList);
    }

    public ConditionCol52 getEditingCol() {
        return this.editingCol;
    }

    public void assertDefaultValue() {
        List<String> valueList = Arrays.asList(this.columnUtilities.getValueList((BaseColumn)this.editingCol));
        if (valueList.size() > 0) {
            String defaultValue = this.cellUtilities.asString(this.editingCol.getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                this.editingCol.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
            DataType.DataTypes dataType = this.columnUtilities.getDataType(this.editingPattern, this.editingCol);
            this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        }
    }

    public String getBinding() {
        return this.editingCol.getBinding();
    }

    public void setBinding(String binding) {
        this.editingCol.setBinding(binding);
    }

    public void confirmFieldChangePopUp(FormStylePopup popUp, String newSelectedField) {
        boolean fieldChanged = true;
        if (this.editingCol.getFactField() != null) {
            fieldChanged = this.editingCol.getFactField().compareTo(newSelectedField) != 0;
        }
        this.editingCol.setFactField(newSelectedField);
        this.editingCol.setFieldType(this.oracle.getFieldType(this.editingPattern.getFactType(), this.editingCol.getFactField()));
        if (fieldChanged) {
            this.editingCol.setOperator(null);
            this.editingCol.setValueList(null);
        }
        this.doFieldLabel();
        this.doValueList();
        this.doCalculationType();
        this.makeLimitedValueWidget();
        this.makeDefaultValueWidget();
        this.doOperatorLabel();
        this.doImageButtons();
        popUp.hide();
        this.view.enableFooter(true);
    }

    public void cancelFieldChangePopUp(FormStylePopup popUp) {
        popUp.hide();
        this.view.enableFooter(true);
    }
}

