/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.HasCEPWindow;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ConditionPopupView
extends FormStylePopup {
    protected TextBox header;
    private SmallLabel patternLabel = new SmallLabel();
    protected TextBox fieldLabel = this.getFieldLabel();
    protected TextBox binding = new BindingTextBox();
    private SmallLabel operatorLabel = new SmallLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    protected TextBox valueListWidget;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    protected ImageButton editField = null;
    protected ImageButton editOp = null;
    protected ImageButton changePattern = null;
    protected InlineRadio literal = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.LiteralValue());
    protected InlineRadio formula = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.Formula());
    protected InlineRadio predicate = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.Predicate());
    private CEPWindowOperatorsDropdown cwo;
    protected TextBox entryPointName;
    private int cepWindowRowIndex;
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();
    private final Command cmdOK = new Command(){

        public void execute() {
            ConditionPopupView.this.presenter.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ConditionPopupView.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);
    private ConditionPopup presenter;

    public ConditionPopupView(ConditionPopup presenter) {
        super(GuidedDecisionTableConstants.INSTANCE.ConditionColumnConfiguration());
        this.presenter = presenter;
        this.changePattern = new ImageButton(this.getEditImage(), this.getDisabledImage(), GuidedDecisionTableConstants.INSTANCE.ChooseAnExistingPatternThatThisColumnAddsTo());
        this.editField = new ImageButton(this.getEditImage(), this.getDisabledImage(), GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        this.editOp = new ImageButton(this.getEditImage(), this.getDisabledImage(), GuidedDecisionTableConstants.INSTANCE.EditTheOperatorThatIsUsedToCompareDataWithThisField());
        this.entryPointName = new TextBox();
        this.header = new TextBox();
        this.valueListWidget = new TextBox();
    }

    protected Image getDisabledImage() {
        return GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
    }

    protected Image getEditImage() {
        return GuidedDecisionTableImageResources508.INSTANCE.Edit();
    }

    public void initializeView() {
        this.initializeChangePattern();
        this.initializeTableFormatSpecifics();
        this.initializeFactField();
        this.initializeOperator();
        this.initializeCepWindow();
        this.initializeEntryPoint();
        this.initializeColumnHeader();
        this.initializeOptionalValueList();
        this.initializeBinding();
        this.initializeHideColumnTick();
        this.initializeApplyButton();
    }

    private void initializeChangePattern() {
        HorizontalPanel patternWidget = new HorizontalPanel();
        patternWidget.add((Widget)this.patternLabel);
        this.changePattern.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopupView.this.presenter.showChangePattern(w);
            }
        });
        this.changePattern.setEnabled(!this.presenter.isReadOnly());
        patternWidget.add((Widget)this.changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Pattern(), (IsWidget)patternWidget);
    }

    private void initializeTableFormatSpecifics() {
        switch (this.presenter.getTableFormat()) {
            case EXTENDED_ENTRY: {
                HorizontalPanel valueTypes = new HorizontalPanel();
                valueTypes.add((Widget)this.literal);
                valueTypes.add((Widget)this.formula);
                valueTypes.add((Widget)this.predicate);
                this.addAttribute(GuidedDecisionTableConstants.INSTANCE.CalculationType() + ":", (IsWidget)valueTypes);
                switch (this.presenter.getConstraintValueType()) {
                    case 1: {
                        this.literal.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case 3: {
                        this.formula.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case 5: {
                        this.predicate.setValue(Boolean.valueOf(true));
                    }
                }
                if (this.presenter.isReadOnly()) break;
                this.literal.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        ConditionPopupView.this.presenter.applyConsTypeChange(1);
                    }
                });
                this.formula.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        ConditionPopupView.this.presenter.applyConsTypeChange(3);
                    }
                });
                this.predicate.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        ConditionPopupView.this.presenter.setFactField(null);
                        ConditionPopupView.this.presenter.applyConsTypeChange(5);
                    }
                });
                break;
            }
            case LIMITED_ENTRY: {
                this.binding.setEnabled(!this.presenter.isReadOnly());
            }
        }
    }

    private void initializeFactField() {
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!this.presenter.isReadOnly());
        field.add((Widget)this.fieldLabel);
        field.add((IsWidget)this.fieldLabelInterpolationInfo);
        this.editField.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopupView.this.presenter.showFieldChange();
            }
        });
        this.editField.setEnabled(!this.presenter.isReadOnly());
        field.add((Widget)this.editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
    }

    private void initializeOperator() {
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        this.editOp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopupView.this.presenter.showOperatorChange();
            }
        });
        this.editOp.setEnabled(!this.presenter.isReadOnly());
        operator.add((Widget)this.editOp);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Operator(), (IsWidget)operator);
    }

    private void initializeCepWindow() {
        this.cepWindowRowIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DTLabelOverCEPWindow(), this.createCEPWindowWidget((HasCEPWindow)this.presenter.getEditingPattern())).getIndex();
    }

    private void initializeEntryPoint() {
        this.entryPointName.setText(this.presenter.getEditingPattern().getEntryPointName());
        this.entryPointName.setEnabled(!this.presenter.isReadOnly());
        if (!this.presenter.isReadOnly()) {
            this.entryPointName.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopupView.this.presenter.getEditingPattern().setEntryPointName(ConditionPopupView.this.entryPointName.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DTLabelFromEntryPoint() + ":", (IsWidget)this.entryPointName);
    }

    private void initializeColumnHeader() {
        this.header.setText(this.presenter.getHeader());
        this.header.setEnabled(!this.presenter.isReadOnly());
        if (!this.presenter.isReadOnly()) {
            this.header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopupView.this.presenter.setHeader(ConditionPopupView.this.header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)this.header);
    }

    private void initializeOptionalValueList() {
        if (this.presenter.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget.setText(this.presenter.getValueList());
            this.valueListWidget.setEnabled(!this.presenter.isReadOnly());
            if (!this.presenter.isReadOnly()) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ConditionPopupView.this.presenter.setValueList(ConditionPopupView.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        ConditionPopupView.this.presenter.assertDefaultValue();
                        ConditionPopupView.this.presenter.makeDefaultValueWidget();
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.ValueList(), GuidedDecisionTableConstants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(GuidedDecisionTableConstants.INSTANCE.optionalValueList(), (IsWidget)vl);
        }
    }

    private void initializeBinding() {
        this.binding.setText(this.presenter.getBinding());
        if (!this.presenter.isReadOnly()) {
            this.binding.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopupView.this.presenter.setBinding(ConditionPopupView.this.binding.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)this.binding);
    }

    private void initializeHideColumnTick() {
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.presenter.getEditingCol()));
    }

    private void initializeApplyButton() {
        this.footer.enableOkButton(!this.presenter.isReadOnly());
        this.add((Widget)this.footer);
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConditionPopupView.this.presenter.setFactField(box.getText());
            }
        });
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(GuidedDecisionTableConstants.INSTANCE.Predicates(), GuidedDecisionTableConstants.INSTANCE.PredicatesInfo());
    }

    private IsWidget createCEPWindowWidget(final HasCEPWindow c) {
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(GuidedDecisionTableConstants.INSTANCE.OverCEPWindow());
        lbl.setStyleName("paddedLabel");
        hp.add((Widget)lbl);
        this.cwo = new CEPWindowOperatorsDropdown(c, this.presenter.isReadOnly());
        if (!this.presenter.isReadOnly()) {
            this.cwo.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<OperatorSelection>(){

                public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                    OperatorSelection selection = (OperatorSelection)event.getValue();
                    String selected = selection.getValue();
                    c.getWindow().setOperator(selected);
                }
            });
        }
        hp.add((Widget)this.cwo);
        return hp;
    }

    public void enableLiteral(boolean enabled) {
        this.literal.setEnabled(enabled);
    }

    public void enableFormula(boolean enabled) {
        this.formula.setEnabled(enabled);
    }

    public void enablePredicate(boolean enabled) {
        this.predicate.setEnabled(enabled);
    }

    public void enableValueListWidget(boolean enabled) {
        this.valueListWidget.setEnabled(enabled);
    }

    public void setValueListWidgetText(String text) {
        this.valueListWidget.setText(text);
    }

    public void setLimitedEntryVisibility(boolean visibility) {
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, visibility);
    }

    public void setDefaultValueVisibility(boolean visibility) {
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, visibility);
    }

    public void setLimitedEntryWidget(Widget widget) {
        this.limitedEntryValueWidgetContainer.setWidget(widget);
    }

    public void setDefaultValueWidget(Widget widget) {
        this.defaultValueWidgetContainer.setWidget(widget);
    }

    public void enableBinding(boolean enabled) {
        this.binding.setEnabled(enabled);
    }

    public void enableEditField(boolean enabled) {
        this.editField.setEnabled(enabled);
    }

    public void enableEditOperator(boolean enabled) {
        this.editOp.setEnabled(enabled);
    }

    public void setFieldLabelText(String text) {
        this.fieldLabel.setText(text);
    }

    public void setOperatorLabelText(String text) {
        this.operatorLabel.setText(text);
    }

    public void setPatternLabelText(String text) {
        this.patternLabel.setText(text);
    }

    public void setFieldLabelDisplayStyle(Style.Display displayStyle) {
        this.fieldLabelInterpolationInfo.getWidget().getElement().getStyle().setDisplay(displayStyle);
    }

    public void setEntryPointName(String name) {
        this.entryPointName.setText(name);
    }

    public void selectOperator(String operator) {
        this.cwo.selectItem(operator);
    }

    public void setCepWindowVisibility(boolean visibility) {
        this.setAttributeVisibility(this.cepWindowRowIndex, visibility);
    }

    public void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }

    public void addLimitedEntryValue() {
        this.limitedEntryValueAttributeIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LimitedEntryValue(), (IsWidget)this.limitedEntryValueWidgetContainer).getIndex();
    }

    public void addDefaultValueIfNoPresent() {
        if (this.defaultValueWidgetContainerIndex == -1) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":", (IsWidget)this.defaultValueWidgetContainer).getIndex();
        }
    }

    public void show() {
        this.presenter.doPatternLabel();
        this.presenter.doFieldLabel();
        this.presenter.doOperatorLabel();
        this.presenter.displayCEPOperators();
        this.presenter.doImageButtons();
        this.presenter.doValueList();
        this.presenter.doCalculationType();
        this.presenter.initialiseViewForConstraintValueType();
        this.presenter.makeDefaultValueWidget();
        this.presenter.makeLimitedValueWidget();
        super.show();
    }

    public void showFieldChangePopUp() {
        FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        ListBox box = this.presenter.loadFields();
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(() -> this.presenter.confirmFieldChangePopUp(pop, box.getItemText(box.getSelectedIndex())), () -> this.presenter.cancelFieldChangePopUp(pop)));
        pop.show();
    }

    public void warnAboutMissingColumnHeaderDescription() {
        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
    }

    public void warnAboutMissingFactField() {
        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseSelectOrEnterField());
    }

    public void warnAboutMissingOperator() {
        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.NotifyNoSelectedOperator());
    }

    public void warnAboutAlreadyUsedBinding() {
        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
    }

    public void warnAboutAlreadyUsedColumnHeaderName() {
        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
    }
}

