/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.HideColumnCheckBox;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DefaultValueDropDownManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.LimitedEntryDropDownManager;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.EnumDropDownUtilities;
import org.uberfire.ext.widgets.common.client.common.AbstractRestrictedEntryTextBox;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.NumericBigDecimalTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericBigIntegerTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericByteTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericDoubleTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericFloatTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericIntegerTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericLongTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericShortTextBox;
import org.uberfire.ext.widgets.common.client.common.NumericTextBox;

public class DTCellValueWidgetFactory {
    private final GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;
    private final ColumnUtilities columnUtilities;
    private final LimitedEntryDropDownManager dropDownManager;
    private final boolean isReadOnly;
    private final boolean allowEmptyValues;
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat format = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public static DTCellValueWidgetFactory getInstance(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, boolean isReadOnly, boolean allowEmptyValues) {
        switch (model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                return new DTCellValueWidgetFactory(model, oracle, new DefaultValueDropDownManager(model, oracle), isReadOnly, allowEmptyValues);
            }
        }
        return new DTCellValueWidgetFactory(model, oracle, new LimitedEntryDropDownManager(model, oracle), isReadOnly, allowEmptyValues);
    }

    private DTCellValueWidgetFactory(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, LimitedEntryDropDownManager dropDownManager, boolean isReadOnly, boolean allowEmptyValues) {
        this.model = model;
        this.oracle = oracle;
        this.columnUtilities = new ColumnUtilities(model, oracle);
        this.dropDownManager = dropDownManager;
        this.isReadOnly = isReadOnly;
        this.allowEmptyValues = allowEmptyValues;
    }

    public DTCellValue52 makeNewValue(DTColumnConfig52 c) {
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType((BaseColumn)c);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public DTCellValue52 makeNewValue(Pattern52 p, ConditionCol52 c) {
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType(p, c);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public Widget getWidget(Pattern52 pattern, ConditionCol52 column, DTCellValue52 value) {
        if (this.columnUtilities.hasValueList(column)) {
            String[] valueList = this.columnUtilities.getValueList((BaseColumn)column);
            return this.makeListBox(DropDownData.create((String[])valueList), pattern, column, value);
        }
        if (this.oracle.hasEnums(pattern.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(pattern, column);
            Map<String, String> currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.oracle.getEnums(pattern.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(DropDownData.create((String[])new String[0]), pattern, column, value);
            }
            return this.makeListBox(dd, pattern, column, value);
        }
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType(pattern, column);
        switch (type) {
            case NUMERIC: {
                return this.makeNumericTextBox(value);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case NUMERIC_BIGINTEGER: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case NUMERIC_BYTE: {
                return this.makeNumericByteTextBox(value);
            }
            case NUMERIC_DOUBLE: {
                return this.makeNumericDoubleTextBox(value);
            }
            case NUMERIC_FLOAT: {
                return this.makeNumericFloatTextBox(value);
            }
            case NUMERIC_INTEGER: {
                return this.makeNumericIntegerTextBox(value);
            }
            case NUMERIC_LONG: {
                return this.makeNumericLongTextBox(value);
            }
            case NUMERIC_SHORT: {
                return this.makeNumericShortTextBox(value);
            }
            case BOOLEAN: {
                return this.makeBooleanSelector(value);
            }
            case DATE: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    public DTCellValue52 makeNewValue(Pattern52 p, ActionSetFieldCol52 c) {
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType(p, c);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public Widget getWidget(Pattern52 pattern, ActionSetFieldCol52 column, DTCellValue52 value) {
        if (this.columnUtilities.hasValueList(column)) {
            String[] valueList = this.columnUtilities.getValueList((BaseColumn)column);
            return this.makeListBox(DropDownData.create((String[])valueList), pattern, column, value);
        }
        if (this.oracle.hasEnums(pattern.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(pattern, column);
            Map<String, String> currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.oracle.getEnums(pattern.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(DropDownData.create((String[])new String[0]), pattern, column, value);
            }
            return this.makeListBox(dd, pattern, column, value);
        }
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType(pattern, column);
        switch (type) {
            case NUMERIC: {
                return this.makeNumericTextBox(value);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case NUMERIC_BIGINTEGER: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case NUMERIC_BYTE: {
                return this.makeNumericByteTextBox(value);
            }
            case NUMERIC_DOUBLE: {
                return this.makeNumericDoubleTextBox(value);
            }
            case NUMERIC_FLOAT: {
                return this.makeNumericFloatTextBox(value);
            }
            case NUMERIC_INTEGER: {
                return this.makeNumericIntegerTextBox(value);
            }
            case NUMERIC_LONG: {
                return this.makeNumericLongTextBox(value);
            }
            case NUMERIC_SHORT: {
                return this.makeNumericShortTextBox(value);
            }
            case BOOLEAN: {
                return this.makeBooleanSelector(value);
            }
            case DATE: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    public Widget getWidget(ActionInsertFactCol52 column, DTCellValue52 value) {
        if (this.columnUtilities.hasValueList(column)) {
            String[] valueList = this.columnUtilities.getValueList((BaseColumn)column);
            return this.makeListBox(DropDownData.create((String[])valueList), column, value);
        }
        if (this.oracle.hasEnums(column.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(column);
            Map<String, String> currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.oracle.getEnums(column.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(DropDownData.create((String[])new String[0]), column, value);
            }
            return this.makeListBox(dd, column, value);
        }
        DataType.DataTypes type = this.columnUtilities.getTypeSafeType((BaseColumn)column);
        switch (type) {
            case NUMERIC: {
                return this.makeNumericTextBox(value);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case NUMERIC_BIGINTEGER: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case NUMERIC_BYTE: {
                return this.makeNumericByteTextBox(value);
            }
            case NUMERIC_DOUBLE: {
                return this.makeNumericDoubleTextBox(value);
            }
            case NUMERIC_FLOAT: {
                return this.makeNumericFloatTextBox(value);
            }
            case NUMERIC_INTEGER: {
                return this.makeNumericIntegerTextBox(value);
            }
            case NUMERIC_LONG: {
                return this.makeNumericLongTextBox(value);
            }
            case NUMERIC_SHORT: {
                return this.makeNumericShortTextBox(value);
            }
            case BOOLEAN: {
                return this.makeBooleanSelector(value);
            }
            case DATE: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    private ListBox makeBooleanSelector(final DTCellValue52 value) {
        final ListBox lb = new ListBox();
        int indexTrue = 0;
        int indexFalse = 1;
        if (this.allowEmptyValues) {
            indexTrue = 1;
            indexFalse = 2;
            lb.addItem(GuidedDecisionTableConstants.INSTANCE.Choose(), "");
        }
        lb.addItem("true");
        lb.addItem("false");
        Boolean currentItem = value.getBooleanValue();
        if (currentItem == null) {
            lb.setSelectedIndex(0);
        } else {
            lb.setSelectedIndex(currentItem != false ? indexTrue : indexFalse);
        }
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String txtValue = lb.getValue(lb.getSelectedIndex());
                    Boolean boolValue = txtValue.equals("") ? null : Boolean.valueOf(txtValue.equals("true"));
                    value.setBooleanValue(boolValue);
                }
            });
        }
        return lb;
    }

    private ListBox makeListBox(DropDownData dd, final Pattern52 basePattern, final ConditionCol52 baseCondition, final DTCellValue52 dcv) {
        boolean isMultipleSelect = this.isExplicitListOperator(baseCondition.getOperator());
        final ListBox lb = this.makeListBox(dd, isMultipleSelect, dcv);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String value = null;
                    if (lb.isMultipleSelect()) {
                        for (int i = 0; i < lb.getItemCount(); ++i) {
                            if (!lb.isItemSelected(i)) continue;
                            value = value == null ? lb.getValue(i) : value + "," + lb.getValue(i);
                        }
                    } else {
                        int index = lb.getSelectedIndex();
                        if (index > -1) {
                            value = lb.getValue(index);
                        }
                    }
                    dcv.setStringValue(value);
                    LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(basePattern, baseCondition);
                    Set<Integer> dependentColumnIndexes = DTCellValueWidgetFactory.this.dropDownManager.getDependentColumnIndexes(context);
                    for (Integer iCol : dependentColumnIndexes) {
                        BaseColumn column = (BaseColumn)DTCellValueWidgetFactory.this.model.getExpandedColumns().get(iCol);
                        if (column instanceof LimitedEntryCol) {
                            ((LimitedEntryCol)column).setValue(null);
                            continue;
                        }
                        if (!(column instanceof DTColumnConfig52)) continue;
                        ((DTColumnConfig52)column).setDefaultValue(null);
                    }
                }
            });
        }
        return lb;
    }

    private boolean isExplicitListOperator(String operator) {
        List<String> ops = Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        return ops.contains(operator);
    }

    private ListBox makeListBox(DropDownData dd, final Pattern52 basePattern, final ActionSetFieldCol52 baseAction, final DTCellValue52 value) {
        final ListBox lb = this.makeListBox(dd, value);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int index = lb.getSelectedIndex();
                    if (index > -1) {
                        value.setStringValue(lb.getValue(index));
                        LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(basePattern, baseAction);
                        Set<Integer> dependentColumnIndexes = DTCellValueWidgetFactory.this.dropDownManager.getDependentColumnIndexes(context);
                        for (Integer iCol : dependentColumnIndexes) {
                            BaseColumn column = (BaseColumn)DTCellValueWidgetFactory.this.model.getExpandedColumns().get(iCol);
                            if (column instanceof LimitedEntryCol) {
                                ((LimitedEntryCol)column).setValue(null);
                                continue;
                            }
                            if (!(column instanceof DTColumnConfig52)) continue;
                            ((DTColumnConfig52)column).setDefaultValue(null);
                        }
                    } else {
                        value.setStringValue(null);
                    }
                }
            });
        }
        return lb;
    }

    private ListBox makeListBox(DropDownData dd, final ActionInsertFactCol52 baseAction, final DTCellValue52 value) {
        final ListBox lb = this.makeListBox(dd, value);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int index = lb.getSelectedIndex();
                    if (index > -1) {
                        value.setStringValue(lb.getValue(index));
                        LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(baseAction);
                        Set<Integer> dependentColumnIndexes = DTCellValueWidgetFactory.this.dropDownManager.getDependentColumnIndexes(context);
                        for (Integer iCol : dependentColumnIndexes) {
                            BaseColumn column = (BaseColumn)DTCellValueWidgetFactory.this.model.getExpandedColumns().get(iCol);
                            if (column instanceof LimitedEntryCol) {
                                ((LimitedEntryCol)column).setValue(null);
                                continue;
                            }
                            if (!(column instanceof DTColumnConfig52)) continue;
                            ((DTColumnConfig52)column).setDefaultValue(null);
                        }
                    } else {
                        value.setStringValue(null);
                    }
                }
            });
        }
        return lb;
    }

    private ListBox makeListBox(DropDownData dd, DTCellValue52 value) {
        return this.makeListBox(dd, false, value);
    }

    private ListBox makeListBox(DropDownData dd, boolean isMultipleSelect, final DTCellValue52 value) {
        ListBox lb = new ListBox(isMultipleSelect);
        EnumDropDownUtilities utilities = new EnumDropDownUtilities(){

            protected int addItems(ListBox listBox) {
                if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                    listBox.addItem(GuidedDecisionTableConstants.INSTANCE.Choose(), "");
                }
                return DTCellValueWidgetFactory.this.allowEmptyValues ? 1 : 0;
            }

            protected void selectItem(ListBox listBox) {
                int itemCount = listBox.getItemCount();
                listBox.setEnabled(itemCount > 0);
                if (itemCount > 0) {
                    listBox.setSelectedIndex(0);
                    value.setStringValue(listBox.getValue(0));
                } else {
                    value.setStringValue(null);
                }
            }
        };
        String strValue = value.getStringValue() == null ? "" : value.getStringValue();
        utilities.setDropDownData(strValue, dd, isMultipleSelect, this.oracle.getResourcePath(), lb);
        return lb;
    }

    private AbstractRestrictedEntryTextBox makeNumericTextBox(final DTCellValue52 value) {
        NumericTextBox tb = new NumericTextBox(this.allowEmptyValues);
        BigDecimal numericValue = (BigDecimal)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toPlainString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(new BigDecimal((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((BigDecimal)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(BigDecimal.ZERO);
                        this.val$tb.setValue(BigDecimal.ZERO.toPlainString());
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericBigDecimalTextBox(final DTCellValue52 value) {
        NumericBigDecimalTextBox tb = new NumericBigDecimalTextBox(this.allowEmptyValues);
        BigDecimal numericValue = (BigDecimal)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toPlainString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(new BigDecimal((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((BigDecimal)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(BigDecimal.ZERO);
                        this.val$tb.setValue(BigDecimal.ZERO.toPlainString());
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericBigIntegerTextBox(final DTCellValue52 value) {
        NumericBigIntegerTextBox tb = new NumericBigIntegerTextBox(this.allowEmptyValues);
        BigInteger numericValue = (BigInteger)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(new BigInteger((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((BigInteger)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(BigInteger.ZERO);
                        this.val$tb.setValue(BigInteger.ZERO.toString());
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericByteTextBox(final DTCellValue52 value) {
        NumericByteTextBox tb = new NumericByteTextBox(this.allowEmptyValues);
        Byte numericValue = (Byte)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(Byte.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Byte)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(Byte.valueOf("0"));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericDoubleTextBox(final DTCellValue52 value) {
        NumericDoubleTextBox tb = new NumericDoubleTextBox(this.allowEmptyValues);
        Double numericValue = (Double)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(new Double((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Double)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(new Double("0"));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericFloatTextBox(final DTCellValue52 value) {
        NumericFloatTextBox tb = new NumericFloatTextBox(this.allowEmptyValues);
        Float numericValue = (Float)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(new Float((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Float)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(new Float("0"));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericIntegerTextBox(final DTCellValue52 value) {
        NumericIntegerTextBox tb = new NumericIntegerTextBox(this.allowEmptyValues);
        Integer numericValue = (Integer)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(Integer.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Integer)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(Integer.valueOf(0));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericLongTextBox(final DTCellValue52 value) {
        NumericLongTextBox tb = new NumericLongTextBox(this.allowEmptyValues);
        Long numericValue = (Long)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(Long.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Long)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(Long.valueOf(0L));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericShortTextBox(final DTCellValue52 value) {
        NumericShortTextBox tb = new NumericShortTextBox(this.allowEmptyValues);
        Short numericValue = (Short)value.getNumericValue();
        tb.setValue(numericValue == null ? "" : numericValue.toString());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>((AbstractRestrictedEntryTextBox)tb){
                final /* synthetic */ AbstractRestrictedEntryTextBox val$tb;
                {
                    this.val$tb = abstractRestrictedEntryTextBox;
                }

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        value.setNumericValue(Short.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        if (DTCellValueWidgetFactory.this.allowEmptyValues) {
                            value.setNumericValue((Short)null);
                            this.val$tb.setValue("");
                        }
                        value.setNumericValue(Short.valueOf("0"));
                        this.val$tb.setValue("0");
                    }
                }
            });
        }
        return tb;
    }

    private TextBox makeTextBox(final DTCellValue52 value) {
        TextBox tb = new TextBox();
        tb.setValue((Object)value.getStringValue());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    value.setStringValue((String)event.getValue());
                }
            });
        }
        return tb;
    }

    private Widget makeDateSelector(DTCellValue52 value) {
        if (this.isReadOnly) {
            Label dateLabel = new Label();
            dateLabel.setText(format.format(value.getDateValue()));
            return dateLabel;
        }
        DatePicker datePicker = new DatePicker(this.allowEmptyValues);
        datePicker.addChangeDateHandler(e -> value.setDateValue(datePicker.getValue()));
        datePicker.setFormat(DATE_FORMAT);
        datePicker.setValue(value.getDateValue());
        return datePicker;
    }

    public static CheckBox getHideColumnIndicator(DTColumnConfig52 col) {
        HideColumnCheckBox chkHide = new HideColumnCheckBox();
        chkHide.init(col);
        return chkHide;
    }
}

