/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.Iterator;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;

public class AnalysisLineCell
extends AbstractCell<Issue> {
    private static final CellTemplate TEMPLATE = (CellTemplate)GWT.create(CellTemplate.class);

    public AnalysisLineCell() {
        super(new String[0]);
    }

    public void render(Cell.Context context, Issue issue, SafeHtmlBuilder safeHtmlBuilder) {
        safeHtmlBuilder.append(TEMPLATE.text(this.getStyleName(issue.getSeverity()), this.getIcon(issue.getSeverity()), this.getLineNumbers(issue.getRowNumbers()), ExplanationProvider.toTitle((Issue)issue)));
    }

    private SafeHtml getLineNumbers(final Set<Integer> rowNumbers) {
        return new SafeHtml(){

            public String asString() {
                StringBuilder builder = new StringBuilder();
                Iterator iterator = rowNumbers.iterator();
                while (iterator.hasNext()) {
                    builder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
        };
    }

    private String getStyleName(Severity severity) {
        switch (severity) {
            case ERROR: {
                return "alert-danger";
            }
            case WARNING: {
                return "alert-warning";
            }
        }
        return "alert-info";
    }

    private String getIcon(Severity severity) {
        switch (severity) {
            case ERROR: {
                return "pficon pficon-error-circle-o btn-xs";
            }
            case WARNING: {
                return "pficon pficon-warning-triangle-o btn-xs";
            }
        }
        return "pficon pficon-info btn-xs";
    }

    static interface CellTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div class=\"{0}\" style=\"margin-bottom: 1px; width:100%; height:100%; \"><span class=\"{1}\"></span><span> - {2} - {3}</span></div>")
        public SafeHtml text(String var1, String var2, SafeHtml var3, String var4);
    }
}

