/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;

public class IssuesSet
extends TreeSet<Issue> {
    private static Set<CheckType> MERGEABLE_ISSUES = EnumSet.of(CheckType.EMPTY_RULE, CheckType.MISSING_RESTRICTION, CheckType.MISSING_ACTION);

    public IssuesSet(List<Issue> issues) {
        super(new Comparator<Issue>(){

            @Override
            public int compare(Issue issue, Issue other) {
                int compareToSeverity = issue.getSeverity().compareTo((Enum)other.getSeverity());
                if (compareToSeverity == 0) {
                    String otherTitle;
                    String thisTitle = ExplanationProvider.toTitle((Issue)issue);
                    int compareToTitle = thisTitle.compareTo(otherTitle = ExplanationProvider.toTitle((Issue)other));
                    if (compareToTitle == 0) {
                        return this.compareRowNumbers(issue.getRowNumbers(), other.getRowNumbers());
                    }
                    return compareToTitle;
                }
                return compareToSeverity;
            }

            private int compareRowNumbers(Set<Integer> rowNumbers, Set<Integer> other) {
                if (rowNumbers.equals(other)) {
                    return 0;
                }
                for (Integer a : rowNumbers) {
                    for (Integer b : other) {
                        if (a >= b) continue;
                        return -1;
                    }
                }
                return 1;
            }
        });
        this.addAll(MERGEABLE_ISSUES.stream().map(typeToMerge -> this.mergeIssues(issues, (CheckType)typeToMerge)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        issues.stream().filter(issue -> !MERGEABLE_ISSUES.contains(issue.getCheckType())).forEach(issue -> this.add(issue));
    }

    private Optional<Issue> mergeIssues(List<Issue> issues, CheckType typeToMerge) {
        Set issuesToMerge = issues.stream().filter(issue -> issue.getCheckType() == typeToMerge).collect(Collectors.toSet());
        Set affectedRows = issuesToMerge.stream().flatMap(issue -> issue.getRowNumbers().stream()).sorted().collect(Collectors.toSet());
        return issuesToMerge.stream().findFirst().map(issue -> new Issue(issue.getSeverity(), typeToMerge, affectedRows));
    }
}

