/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.types.Transform;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class BoundaryTransformMediator
implements TransformMediator {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private final GuidedDecisionTableModellerView view;

    public BoundaryTransformMediator(GuidedDecisionTableModellerView view) {
        this.view = (GuidedDecisionTableModellerView)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.updateBounds();
    }

    private void updateBounds() {
        Bounds bounds = this.view.getBounds();
        this.minX = bounds.getX();
        this.minY = bounds.getY();
        this.maxX = this.minX + bounds.getWidth();
        this.maxY = this.minY + bounds.getHeight();
    }

    public Transform adjust(Transform transform, Bounds visibleBounds) {
        this.updateBounds();
        Transform newTransform = transform.copy();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        double translateX = newTransform.getTranslateX();
        double translateY = newTransform.getTranslateY();
        double scaledTranslateX = translateX / scaleX;
        double scaledTranslateY = translateY / scaleY;
        double visibleBoundsWidth = visibleBounds.getWidth();
        double visibleBoundsHeight = visibleBounds.getHeight();
        if (-scaledTranslateX < this.minX) {
            newTransform = newTransform.translate(-scaledTranslateX - this.minX, 0.0);
        }
        if (-scaledTranslateY < this.minY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY - this.minY);
        }
        if (-scaledTranslateX + visibleBoundsWidth > this.maxX) {
            newTransform = newTransform.translate(-scaledTranslateX + visibleBoundsWidth - this.maxX, 0.0);
        }
        if (-scaledTranslateY + visibleBoundsHeight > this.maxY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY + visibleBoundsHeight - this.maxY);
        }
        return newTransform;
    }
}

