/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RowContextMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.IsRowDragHandle;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RangeSelectionStrategy;

@Dependent
public class GuidedDecisionTableModellerContextMenuSupport {
    private final CellContextMenu cellContextMenu;
    private final RowContextMenu rowContextMenu;

    @Inject
    public GuidedDecisionTableModellerContextMenuSupport(CellContextMenu cellContextMenu, RowContextMenu rowContextMenu) {
        this.cellContextMenu = cellContextMenu;
        this.rowContextMenu = rowContextMenu;
    }

    public ContextMenuHandler getContextMenuHandler(GuidedDecisionTableModellerView.Presenter modellerPresenter) {
        return new GuidedDecisionTableModellerContextMenuHandler(modellerPresenter, this.cellContextMenu, this.rowContextMenu);
    }

    public MouseDownHandler getContextMenuMouseDownHandler() {
        return new GuidedDecisionTableModellerContextMenuMouseDownHandler(this.cellContextMenu, this.rowContextMenu);
    }

    private static class GuidedDecisionTableModellerContextMenuMouseDownHandler
    implements MouseDownHandler {
        private final CellContextMenu cellContextMenu;
        private final RowContextMenu rowContextMenu;

        public GuidedDecisionTableModellerContextMenuMouseDownHandler(CellContextMenu cellContextMenu, RowContextMenu rowContextMenu) {
            this.cellContextMenu = cellContextMenu;
            this.rowContextMenu = rowContextMenu;
        }

        public void onMouseDown(MouseDownEvent event) {
            if (!this.eventTargetsPopup(event.getNativeEvent(), (Element)this.cellContextMenu.asWidget().getElement())) {
                this.cellContextMenu.hide();
            }
            if (!this.eventTargetsPopup(event.getNativeEvent(), (Element)this.rowContextMenu.asWidget().getElement())) {
                this.rowContextMenu.hide();
            }
        }

        private boolean eventTargetsPopup(NativeEvent event, Element element) {
            EventTarget target = event.getEventTarget();
            if (Element.is((JavaScriptObject)target)) {
                return element.isOrHasChild((Node)Element.as((JavaScriptObject)target));
            }
            return false;
        }
    }

    private static class GuidedDecisionTableModellerContextMenuHandler
    implements ContextMenuHandler {
        private final GuidedDecisionTableModellerView.Presenter modellerPresenter;
        private final CellContextMenu cellContextMenu;
        private final RowContextMenu rowContextMenu;

        public GuidedDecisionTableModellerContextMenuHandler(GuidedDecisionTableModellerView.Presenter modellerPresenter, CellContextMenu cellContextMenu, RowContextMenu rowContextMenu) {
            this.modellerPresenter = modellerPresenter;
            this.cellContextMenu = cellContextMenu;
            this.rowContextMenu = rowContextMenu;
        }

        public void onContextMenu(ContextMenuEvent event) {
            event.preventDefault();
            event.stopPropagation();
            boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
            boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
            int eventX = event.getNativeEvent().getClientX();
            int eventY = event.getNativeEvent().getClientY();
            int canvasX = this.getRelativeX(event);
            int canvasY = this.getRelativeY(event);
            for (GuidedDecisionTableView.Presenter dtPresenter : this.modellerPresenter.getAvailableDecisionTables()) {
                GuidedDecisionTableView gridView = dtPresenter.getView();
                GridData gridModel = gridView.getModel();
                Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)gridView, (Point2D)new Point2D((double)canvasX, (double)canvasY));
                Integer uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)gridView, (double)ap.getY());
                Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)gridView, (double)ap.getX());
                if (uiRowIndex == null || uiColumnIndex == null) continue;
                GridColumn column = (GridColumn)gridModel.getColumns().get(uiColumnIndex);
                if (column instanceof IsRowDragHandle) {
                    this.rowContextMenu.show(eventX, eventY);
                } else {
                    this.cellContextMenu.show(eventX, eventY);
                }
                this.selectCell(uiRowIndex, uiColumnIndex, gridView, isShiftKeyDown, isControlKeyDown);
            }
        }

        private int getRelativeX(ContextMenuEvent event) {
            NativeEvent e = event.getNativeEvent();
            Element target = event.getRelativeElement();
            return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
        }

        private int getRelativeY(ContextMenuEvent event) {
            NativeEvent e = event.getNativeEvent();
            Element target = event.getRelativeElement();
            return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
        }

        private void selectCell(int uiRowIndex, int uiColumnIndex, GuidedDecisionTableView gridView, boolean isShiftKeyDown, boolean isControlKeyDown) {
            GridData gridModel = gridView.getModel();
            GridCell cell = gridModel.getCell(uiRowIndex, uiColumnIndex);
            CellSelectionStrategy selectionStrategy = cell == null ? RangeSelectionStrategy.INSTANCE : cell.getSelectionManager();
            if (selectionStrategy == null) {
                return;
            }
            if (selectionStrategy.handleSelection(gridModel, uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown)) {
                gridView.getLayer().batch();
            }
        }
    }
}

