/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BoundaryTransformMediator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerBoundsHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.uberfire.ext.widgets.common.client.common.DecoratedDisclosurePanel;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.PrettyFormLayout;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.mvp.ParameterizedCommand;

public class GuidedDecisionTableModellerViewImpl
extends Composite
implements GuidedDecisionTableModellerView {
    private static final double VP_SCALE = 1.0;
    private static GuidedDecisionTableModellerViewImplUiBinder uiBinder = (GuidedDecisionTableModellerViewImplUiBinder)GWT.create(GuidedDecisionTableModellerViewImplUiBinder.class);
    private static String SECTION_SEPARATOR = "..................";
    private TransformMediator defaultTransformMediator;
    private GuidedDecisionTableModellerView.Presenter presenter;
    private final DefaultGridLayer gridLayer = new DefaultGridLayer(){

        public void enterPinnedMode(GridWidget gridWidget, final Command onStartCommand) {
            super.enterPinnedMode(gridWidget, new Command(){

                public void execute() {
                    onStartCommand.execute();
                    GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(true);
                }
            });
        }

        public void exitPinnedMode(final Command onCompleteCommand) {
            super.exitPinnedMode(new Command(){

                public void execute() {
                    onCompleteCommand.execute();
                    GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(false);
                }
            });
        }

        public TransformMediator getDefaultTransformMediator() {
            return GuidedDecisionTableModellerViewImpl.this.defaultTransformMediator;
        }
    };
    private final RestrictedMousePanMediator mousePanMediator = new RestrictedMousePanMediator((GridLayer)this.gridLayer){

        protected void onMouseMove(NodeMouseMoveEvent event) {
            super.onMouseMove(event);
            GuidedDecisionTableModellerViewImpl.this.presenter.updateRadar();
        }
    };
    @UiField
    VerticalPanel configuration;
    @UiField(provided=true)
    GridLienzoPanel gridPanel = new GridLienzoPanel(){

        public void onResize() {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    int width = this.getParent().getOffsetWidth();
                    int height = this.getParent().getOffsetHeight();
                    if (width != 0 && height != 0) {
                        domElementContainer.setPixelSize(width, height);
                        lienzoPanel.setPixelSize(width, height);
                    }
                    TransformMediator restriction = GuidedDecisionTableModellerViewImpl.this.mousePanMediator.getTransformMediator();
                    Transform transform = restriction.adjust(GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().getTransform(), GuidedDecisionTableModellerViewImpl.this.gridLayer.getVisibleBounds());
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().setTransform(transform);
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.draw();
                }
            });
        }
    };
    private Button addButton = new Button(){
        {
            this.setIcon(IconType.PLUS_SQUARE);
            this.setText(GuidedDecisionTableConstants.INSTANCE.NewColumn());
            this.setTitle(GuidedDecisionTableConstants.INSTANCE.AddNewColumn());
            this.setEnabled(false);
        }
    };
    private VerticalPanel config = new VerticalPanel();
    private DecoratedDisclosurePanel disclosurePanelConditions;
    private DecoratedDisclosurePanel disclosurePanelActions;
    protected DecoratedDisclosurePanel disclosurePanelAttributes;
    private DecoratedDisclosurePanel disclosurePanelMetaData;
    private PrettyFormLayout configureColumnsNote;
    protected VerticalPanel attributeConfigWidget;
    private VerticalPanel metaDataConfigWidget;
    private VerticalPanel conditionsConfigWidget;
    private VerticalPanel actionsConfigWidget;
    private final RuleSelector ruleSelector = new RuleSelector();
    private final GuidedDecisionTableModellerBoundsHelper boundsHelper = new GuidedDecisionTableModellerBoundsHelper();

    public GuidedDecisionTableModellerViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(GuidedDecisionTableModellerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.configureColumnsNote = new PrettyFormLayout();
        this.configureColumnsNote.startSection();
        this.configureColumnsNote.addRow((Widget)new HTML(AbstractImagePrototype.create((ImageResource)GuidedDecisionTableResources.INSTANCE.images().information()).getHTML() + "&nbsp;" + GuidedDecisionTableConstants.INSTANCE.ConfigureColumnsNote()));
        this.configureColumnsNote.endSection();
        DecoratedDisclosurePanel disclosurePanelContainer = new DecoratedDisclosurePanel(GuidedDecisionTableConstants.INSTANCE.DecisionTable());
        disclosurePanelContainer.setTitle(GuidedDecisionTableConstants.INSTANCE.DecisionTable());
        disclosurePanelContainer.setWidth("100%");
        this.config.setWidth("100%");
        disclosurePanelContainer.add((Widget)this.config);
        this.config.add(this.newColumn());
        this.disclosurePanelMetaData = this.setupDisclosurePanel(GuidedDecisionTableConstants.INSTANCE.MetadataColumns(), this.wrapDisclosurePanelContent(this.getMetaDataWidget()));
        this.disclosurePanelAttributes = this.setupDisclosurePanel(GuidedDecisionTableConstants.INSTANCE.AttributeColumns(), this.wrapDisclosurePanelContent(this.getAttributesWidget()));
        this.disclosurePanelConditions = this.setupDisclosurePanel(GuidedDecisionTableConstants.INSTANCE.ConditionColumns(), this.wrapDisclosurePanelContent(this.getConditionsWidget()));
        this.disclosurePanelActions = this.setupDisclosurePanel(GuidedDecisionTableConstants.INSTANCE.ActionColumns(), this.wrapDisclosurePanelContent(this.getActionsWidget()));
        this.config.add((Widget)this.disclosurePanelMetaData);
        this.config.add((Widget)this.disclosurePanelAttributes);
        this.config.add((Widget)this.disclosurePanelConditions);
        this.config.add((Widget)this.disclosurePanelActions);
        this.configuration.add((Widget)disclosurePanelContainer);
        this.configuration.add((Widget)this.configureColumnsNote);
        this.configuration.add(this.getRuleInheritanceWidget());
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.defaultTransformMediator = new BoundaryTransformMediator(this);
        this.mousePanMediator.setTransformMediator(this.defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridPanel.add(this.gridLayer);
        this.gridPanel.getElement().setId("dtable_container_" + Document.get().createUniqueId());
    }

    private DecoratedDisclosurePanel setupDisclosurePanel(String title, Widget content) {
        DecoratedDisclosurePanel panel = new DecoratedDisclosurePanel(title);
        panel.setWidth("75%");
        panel.setOpen(false);
        panel.add(content);
        return panel;
    }

    public void onResize() {
        this.gridPanel.onResize();
        this.presenter.updateRadar();
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.gridPanel.addKeyDownHandler(handler);
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.gridPanel.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.gridPanel.addMouseDownHandler(handler);
    }

    private Widget getRuleInheritanceWidget() {
        this.ruleSelector.setEnabled(false);
        HorizontalPanel result = new HorizontalPanel();
        result.add((Widget)new Label(GuidedDecisionTableConstants.INSTANCE.AllTheRulesInherit()));
        this.ruleSelector.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().setParentRuleName((String)event.getValue());
            }
        });
        result.add((Widget)this.ruleSelector);
        return result;
    }

    @Override
    public void clear() {
        this.gridLayer.removeAll();
    }

    @Override
    public void addDecisionTable(GuidedDecisionTableView gridWidget) {
        if (this.gridLayer.getGridWidgets().isEmpty()) {
            Point2D translation = this.getTranslation(gridWidget);
            Transform t = this.gridLayer.getViewport().getTransform();
            t.translate(translation.getX(), translation.getY());
        }
        this.gridLayer.add((IPrimitive)gridWidget);
        this.gridLayer.batch();
    }

    private Point2D getTranslation(GuidedDecisionTableView gridWidget) {
        Transform t = this.gridLayer.getViewport().getTransform();
        double requiredTranslateX = 20.0 - gridWidget.getX();
        double requiredTranslateY = 20.0 - gridWidget.getY();
        double actualTranslateX = t.getTranslateX();
        double actualTranslateY = t.getTranslateY();
        double dx = requiredTranslateX - actualTranslateX;
        double dy = requiredTranslateY - actualTranslateY;
        return new Point2D(dx, dy);
    }

    @Override
    public void removeDecisionTable(GuidedDecisionTableView gridWidget, Command afterRemovalCommand) {
        if (gridWidget == null) {
            return;
        }
        Command remove = () -> {
            this.gridLayer.remove((IPrimitive)gridWidget);
            this.gridLayer.batch();
            afterRemovalCommand.execute();
        };
        if (this.gridLayer.isGridPinned()) {
            GridPinnedModeManager.PinnedContext context = this.gridLayer.getPinnedContext();
            if (gridWidget.equals(context.getGridWidget())) {
                this.gridLayer.exitPinnedMode(remove);
            }
        } else {
            remove.execute();
        }
    }

    @Override
    public void setEnableColumnCreation(boolean enabled) {
        this.addButton.setEnabled(enabled);
    }

    private Widget newColumn() {
        this.addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                GuidedDecisionTableModellerViewImpl.this.doNewColumn();
            }
        });
        return this.addButton;
    }

    private void doNewColumn() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.AddNewColumn());
        final ListBox choice = new ListBox();
        choice.setVisibleItemCount(NewColumnTypes.values().length);
        choice.setWidth("100%");
        choice.addItem(GuidedDecisionTableConstants.INSTANCE.AddNewMetadataOrAttributeColumn(), NewColumnTypes.METADATA_ATTRIBUTE.name());
        choice.addItem(SECTION_SEPARATOR);
        choice.addItem(GuidedDecisionTableConstants.INSTANCE.AddNewConditionSimpleColumn(), NewColumnTypes.CONDITION_SIMPLE.name());
        choice.addItem(SECTION_SEPARATOR);
        choice.addItem(GuidedDecisionTableConstants.INSTANCE.SetTheValueOfAField(), NewColumnTypes.ACTION_UPDATE_FACT_FIELD.name());
        choice.addItem(GuidedDecisionTableConstants.INSTANCE.SetTheValueOfAFieldOnANewFact(), NewColumnTypes.ACTION_INSERT_FACT_FIELD.name());
        choice.addItem(GuidedDecisionTableConstants.INSTANCE.DeleteAnExistingFact(), NewColumnTypes.ACTION_RETRACT_FACT.name());
        final CheckBox chkIncludeAdvancedOptions = new CheckBox(SafeHtmlUtils.fromString((String)GuidedDecisionTableConstants.INSTANCE.IncludeAdvancedOptions()));
        chkIncludeAdvancedOptions.setValue(Boolean.valueOf(false));
        chkIncludeAdvancedOptions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (chkIncludeAdvancedOptions.getValue().booleanValue()) {
                    this.addItem(3, GuidedDecisionTableConstants.INSTANCE.AddNewConditionBRLFragment(), NewColumnTypes.CONDITION_BRL_FRAGMENT.name());
                    this.addItem(GuidedDecisionTableConstants.INSTANCE.WorkItemAction(), NewColumnTypes.ACTION_WORKITEM.name());
                    this.addItem(GuidedDecisionTableConstants.INSTANCE.WorkItemActionSetField(), NewColumnTypes.ACTION_WORKITEM_UPDATE_FACT_FIELD.name());
                    this.addItem(GuidedDecisionTableConstants.INSTANCE.WorkItemActionInsertFact(), NewColumnTypes.ACTION_WORKITEM_INSERT_FACT_FIELD.name());
                    this.addItem(GuidedDecisionTableConstants.INSTANCE.AddNewActionBRLFragment(), NewColumnTypes.ACTION_BRL_FRAGMENT.name());
                } else {
                    this.removeItem(NewColumnTypes.CONDITION_BRL_FRAGMENT.name());
                    this.removeItem(NewColumnTypes.ACTION_WORKITEM.name());
                    this.removeItem(NewColumnTypes.ACTION_WORKITEM_UPDATE_FACT_FIELD.name());
                    this.removeItem(NewColumnTypes.ACTION_WORKITEM_INSERT_FACT_FIELD.name());
                    this.removeItem(NewColumnTypes.ACTION_BRL_FRAGMENT.name());
                }
            }

            private void addItem(int index, String item, String value) {
                for (int itemIndex = 0; itemIndex < choice.getItemCount(); ++itemIndex) {
                    if (!choice.getValue(itemIndex).equals(value)) continue;
                    return;
                }
                choice.insertItem(item, value, index);
            }

            private void addItem(String item, String value) {
                for (int itemIndex = 0; itemIndex < choice.getItemCount(); ++itemIndex) {
                    if (!choice.getValue(itemIndex).equals(value)) continue;
                    return;
                }
                choice.addItem(item, value);
            }

            private void removeItem(String value) {
                for (int itemIndex = 0; itemIndex < choice.getItemCount(); ++itemIndex) {
                    if (!choice.getValue(itemIndex).equals(value)) continue;
                    choice.removeItem(itemIndex);
                    break;
                }
            }
        });
        final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                String s = choice.getValue(choice.getSelectedIndex());
                if (s.equals(NewColumnTypes.METADATA_ATTRIBUTE.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newAttributeOrMetaDataColumn();
                } else if (s.equals(NewColumnTypes.CONDITION_SIMPLE.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newConditionColumn();
                } else if (s.equals(NewColumnTypes.CONDITION_BRL_FRAGMENT.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newConditionBRLFragment();
                } else if (s.equals(NewColumnTypes.ACTION_INSERT_FACT_FIELD.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionInsertColumn();
                } else if (s.equals(NewColumnTypes.ACTION_UPDATE_FACT_FIELD.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionSetColumn();
                } else if (s.equals(NewColumnTypes.ACTION_RETRACT_FACT.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionRetractFact();
                } else if (s.equals(NewColumnTypes.ACTION_WORKITEM.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionWorkItem();
                } else if (s.equals(NewColumnTypes.ACTION_WORKITEM_UPDATE_FACT_FIELD.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionWorkItemSetField();
                } else if (s.equals(NewColumnTypes.ACTION_WORKITEM_INSERT_FACT_FIELD.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionWorkItemInsertFact();
                } else if (s.equals(NewColumnTypes.ACTION_BRL_FRAGMENT.name())) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().newActionBRLFragment();
                }
                pop.hide();
            }
        }, new Command(){

            public void execute() {
                pop.hide();
            }
        });
        choice.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int itemIndex = choice.getSelectedIndex();
                if (itemIndex < 0) {
                    return;
                }
                footer.enableOkButton(!choice.getValue(itemIndex).equals(SECTION_SEPARATOR));
            }
        });
        pop.setTitle(GuidedDecisionTableConstants.INSTANCE.AddNewColumn());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.TypeOfColumn(), (IsWidget)choice);
        pop.addAttribute("", (IsWidget)chkIncludeAdvancedOptions);
        pop.add((Widget)footer);
        pop.show();
    }

    @Override
    public void refreshRuleInheritance(String selectedParentRuleName, Collection<String> availableParentRuleNames) {
        this.ruleSelector.setRuleName(selectedParentRuleName);
        this.ruleSelector.setRuleNames(availableParentRuleNames);
    }

    private Widget getAttributesWidget() {
        this.attributeConfigWidget = new VerticalPanel();
        return this.attributeConfigWidget;
    }

    private Widget wrapDisclosurePanelContent(Widget content) {
        SimplePanel container = new SimplePanel();
        container.getElement().getStyle().setProperty("maxHeight", "200px");
        container.getElement().getStyle().setOverflowY(Style.Overflow.SCROLL);
        container.add(content);
        return container;
    }

    @Override
    public void refreshAttributeWidget(List<AttributeCol52> attributeColumns) {
        this.attributeConfigWidget.clear();
        if (attributeColumns == null || attributeColumns.isEmpty()) {
            this.disclosurePanelAttributes.setOpen(false);
            return;
        }
        for (AttributeCol52 attributeColumn : attributeColumns) {
            AttributeColumnConfigRow attributeColumnConfigRow = new AttributeColumnConfigRow();
            attributeColumnConfigRow.init(attributeColumn, this.presenter);
            this.attributeConfigWidget.add(attributeColumnConfigRow.getView());
        }
    }

    private Widget getMetaDataWidget() {
        this.metaDataConfigWidget = new VerticalPanel();
        return this.metaDataConfigWidget;
    }

    @Override
    public void refreshMetaDataWidget(List<MetadataCol52> metaDataColumns) {
        this.metaDataConfigWidget.clear();
        if (metaDataColumns == null || metaDataColumns.isEmpty()) {
            this.disclosurePanelMetaData.setOpen(false);
            return;
        }
        boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (MetadataCol52 metaDataColumn : metaDataColumns) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            hp.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
            if (isEditable) {
                hp.add(this.removeMetaData(metaDataColumn));
            }
            SmallLabel label = this.makeColumnLabel(metaDataColumn);
            hp.add((Widget)label);
            final MetadataCol52 originalColumn = metaDataColumn;
            final CheckBox chkHideColumn = new CheckBox(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":");
            chkHideColumn.setValue(Boolean.valueOf(metaDataColumn.isHideColumn()));
            chkHideColumn.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataCol52 editedColumn = originalColumn.cloneColumn();
                    editedColumn.setHideColumn(chkHideColumn.getValue().booleanValue());
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().updateColumn(originalColumn, editedColumn);
                }
            });
            hp.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp.add((Widget)chkHideColumn);
            this.metaDataConfigWidget.add((Widget)hp);
        }
    }

    private SmallLabel makeColumnLabel(MetadataCol52 metaDataColumn) {
        SmallLabel label = new SmallLabel(metaDataColumn.getMetadata());
        ColumnUtilities.setColumnLabelStyleWhenHidden(label, metaDataColumn.isHideColumn());
        return label;
    }

    private Widget removeMetaData(final MetadataCol52 md) {
        Image image = GuidedDecisionTableImageResources508.INSTANCE.DeleteItemSmall();
        image.setAltText(GuidedDecisionTableConstants.INSTANCE.RemoveThisMetadata());
        return new ImageButton(image, GuidedDecisionTableConstants.INSTANCE.RemoveThisMetadata(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                String ms = GuidedDecisionTableConstants.INSTANCE.DeleteActionColumnWarning(md.getMetadata());
                if (Window.confirm((String)ms)) {
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().deleteColumn(md);
                }
            }
        });
    }

    private Widget getConditionsWidget() {
        this.conditionsConfigWidget = new VerticalPanel();
        return this.conditionsConfigWidget;
    }

    @Override
    public void refreshConditionsWidget(List<CompositeColumn<? extends BaseColumn>> conditionColumns) {
        this.conditionsConfigWidget.clear();
        if (conditionColumns == null || conditionColumns.isEmpty()) {
            this.disclosurePanelConditions.setOpen(false);
            return;
        }
        VerticalPanel patternsPanel = new VerticalPanel();
        this.conditionsConfigWidget.add((Widget)patternsPanel);
        boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (CompositeColumn<? extends BaseColumn> conditionColumn : conditionColumns) {
            if (conditionColumn instanceof Pattern52) {
                Pattern52 p = (Pattern52)conditionColumn;
                VerticalPanel patternPanel = new VerticalPanel();
                VerticalPanel conditionsPanel = new VerticalPanel();
                HorizontalPanel patternHeaderPanel = new HorizontalPanel();
                patternHeaderPanel.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().patternSectionHeader());
                Label patternLabel = this.makePatternLabel(p);
                patternHeaderPanel.add((Widget)patternLabel);
                patternPanel.add((Widget)patternHeaderPanel);
                patternPanel.add((Widget)conditionsPanel);
                patternsPanel.add((Widget)patternPanel);
                List conditions = p.getChildColumns();
                for (ConditionCol52 c : conditions) {
                    HorizontalPanel hp = new HorizontalPanel();
                    hp.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().patternConditionSectionHeader());
                    if (isEditable) {
                        hp.add(this.removeCondition(c));
                    }
                    hp.add(this.editCondition(p, c));
                    SmallLabel conditionLabel = this.makeColumnLabel(c);
                    hp.add((Widget)conditionLabel);
                    conditionsPanel.add((Widget)hp);
                }
                continue;
            }
            if (!(conditionColumn instanceof BRLConditionColumn)) continue;
            BRLConditionColumn brl = (BRLConditionColumn)conditionColumn;
            HorizontalPanel patternHeaderPanel = new HorizontalPanel();
            patternHeaderPanel.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().patternSectionHeader());
            HorizontalPanel patternPanel = new HorizontalPanel();
            if (isEditable) {
                patternPanel.add(this.removeCondition((ConditionCol52)brl));
            }
            patternPanel.add(this.editCondition(brl));
            Label patternLabel = this.makePatternLabel(brl);
            patternPanel.add((Widget)patternLabel);
            patternHeaderPanel.add((Widget)patternPanel);
            patternsPanel.add((Widget)patternHeaderPanel);
        }
    }

    private Label makePatternLabel(Pattern52 p) {
        StringBuilder patternLabel = new StringBuilder();
        String factType = p.getFactType();
        String boundName = p.getBoundName();
        if (factType != null && factType.length() > 0) {
            if (p.isNegated()) {
                patternLabel.append(GuidedDecisionTableConstants.INSTANCE.negatedPattern()).append(" ").append(factType);
            } else {
                patternLabel.append(factType).append(" [").append(boundName).append("]");
            }
        }
        return new Label(patternLabel.toString());
    }

    private Label makePatternLabel(BRLConditionColumn brl) {
        StringBuilder sb = new StringBuilder();
        sb.append(brl.getHeader());
        return new Label(sb.toString());
    }

    private SmallLabel makeColumnLabel(ConditionCol52 cc) {
        StringBuilder sb = new StringBuilder();
        if (cc.isBound()) {
            sb.append(cc.getBinding());
            sb.append(" : ");
        }
        sb.append(cc.getHeader());
        SmallLabel label = new SmallLabel(sb.toString());
        if (cc.isHideColumn()) {
            label.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
        return label;
    }

    private Widget editCondition(Pattern52 origPattern, ConditionCol52 origCol) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisColumnsConfiguration(), () -> this.presenter.getActiveDecisionTable().editCondition(origPattern, origCol));
    }

    private Widget editCondition(BRLConditionColumn origCol) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisColumnsConfiguration(), () -> this.presenter.getActiveDecisionTable().editCondition(origCol));
    }

    private Widget makeEditColumnWidget(String caption, Command command) {
        Image icon = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        icon.setAltText(caption);
        return new ImageButton(icon, caption, e -> command.execute());
    }

    private Widget removeCondition(ConditionCol52 column) {
        if (column instanceof BRLConditionColumn) {
            return this.makeRemoveConditionWidget(column, (ParameterizedCommand<Command>)((ParameterizedCommand)command -> {
                if (!this.presenter.getActiveDecisionTable().canConditionBeDeleted((BRLConditionColumn)column)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumn0(column.getHeader()));
                    return;
                }
                command.execute();
            }));
        }
        return this.makeRemoveConditionWidget(column, (ParameterizedCommand<Command>)((ParameterizedCommand)command -> {
            if (!this.presenter.getActiveDecisionTable().canConditionBeDeleted(column)) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumn0(column.getHeader()));
                return;
            }
            command.execute();
        }));
    }

    private Widget makeRemoveConditionWidget(ConditionCol52 column, ParameterizedCommand<Command> command) {
        Image image = GuidedDecisionTableImageResources508.INSTANCE.DeleteItemSmall();
        image.setAltText(GuidedDecisionTableConstants.INSTANCE.RemoveThisConditionColumn());
        return new ImageButton(image, GuidedDecisionTableConstants.INSTANCE.RemoveThisConditionColumn(), e -> command.execute(() -> {
            String cm = GuidedDecisionTableConstants.INSTANCE.DeleteConditionColumnWarning0(column.getHeader());
            if (Window.confirm((String)cm)) {
                this.presenter.getActiveDecisionTable().deleteColumn(column);
            }
        }));
    }

    private Widget getActionsWidget() {
        this.actionsConfigWidget = new VerticalPanel();
        return this.actionsConfigWidget;
    }

    @Override
    public void refreshActionsWidget(List<ActionCol52> actionColumns) {
        this.actionsConfigWidget.clear();
        if (actionColumns == null || actionColumns.isEmpty()) {
            this.disclosurePanelActions.setOpen(false);
            return;
        }
        VerticalPanel actionsPanel = new VerticalPanel();
        this.actionsConfigWidget.add((Widget)actionsPanel);
        boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (ActionCol52 actionColumn : actionColumns) {
            HorizontalPanel hp = new HorizontalPanel();
            if (isEditable) {
                hp.add(this.removeAction(actionColumn));
            }
            hp.add(this.editAction(actionColumn));
            SmallLabel actionLabel = this.makeColumnLabel(actionColumn);
            hp.add((Widget)actionLabel);
            actionsPanel.add((Widget)hp);
        }
    }

    private SmallLabel makeColumnLabel(ActionCol52 actionColumn) {
        SmallLabel label = new SmallLabel(actionColumn.getHeader());
        if (actionColumn.isHideColumn()) {
            label.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
        return label;
    }

    private Widget editAction(ActionCol52 actionColumn) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisActionColumnConfiguration(), () -> this.presenter.getActiveDecisionTable().editAction(actionColumn));
    }

    private Widget removeAction(ActionCol52 column) {
        Image image = GuidedDecisionTableImageResources508.INSTANCE.DeleteItemSmall();
        image.setAltText(GuidedDecisionTableConstants.INSTANCE.RemoveThisActionColumn());
        return new ImageButton(image, GuidedDecisionTableConstants.INSTANCE.RemoveThisActionColumn(), e -> {
            String cm = GuidedDecisionTableConstants.INSTANCE.DeleteActionColumnWarning(column.getHeader());
            if (Window.confirm((String)cm)) {
                this.presenter.getActiveDecisionTable().deleteColumn(column);
            }
        });
    }

    @Override
    public void refreshColumnsNote(boolean hasColumnDefinitions) {
        this.configureColumnsNote.setVisible(!hasColumnDefinitions);
    }

    @Override
    public void setZoom(int zoom) {
        Transform transform = new Transform();
        double tx = this.gridPanel.getViewport().getTransform().getTranslateX();
        double ty = this.gridPanel.getViewport().getTransform().getTranslateY();
        transform.translate(tx, ty);
        transform.scale((double)zoom / 100.0);
        this.gridPanel.getViewport().setTransform(transform);
        TransformMediator restriction = this.mousePanMediator.getTransformMediator();
        Transform newTransform = restriction.adjust(transform, this.gridLayer.getVisibleBounds());
        this.gridPanel.getViewport().setTransform(newTransform);
        this.gridPanel.getViewport().batch();
    }

    @Override
    public void onInsertColumn() {
        this.doNewColumn();
    }

    @Override
    public GridLayer getGridLayerView() {
        return this.gridLayer;
    }

    @Override
    public GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    @Override
    public Bounds getBounds() {
        if (this.presenter == null) {
            return this.boundsHelper.getBounds(Collections.emptySet());
        }
        return this.boundsHelper.getBounds(this.presenter.getAvailableDecisionTables());
    }

    public void select(GridWidget selectedGridWidget) {
        this.ruleSelector.setEnabled(true);
        this.gridLayer.select(selectedGridWidget);
    }

    public void selectLinkedColumn(GridColumn<?> link) {
        this.gridLayer.selectLinkedColumn(link);
    }

    public Set<GridWidget> getGridWidgets() {
        return this.gridLayer.getGridWidgets();
    }

    private static enum NewColumnTypes {
        METADATA_ATTRIBUTE,
        CONDITION_SIMPLE,
        CONDITION_BRL_FRAGMENT,
        ACTION_UPDATE_FACT_FIELD,
        ACTION_INSERT_FACT_FIELD,
        ACTION_RETRACT_FACT,
        ACTION_WORKITEM,
        ACTION_WORKITEM_UPDATE_FACT_FIELD,
        ACTION_WORKITEM_INSERT_FACT_FIELD,
        ACTION_BRL_FRAGMENT;

    }

    static interface GuidedDecisionTableModellerViewImplUiBinder
    extends UiBinder<Widget, GuidedDecisionTableModellerViewImpl> {
    }
}

