/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.models.datamodel.imports.HasImports;
import org.drools.workbench.models.datamodel.oracle.DateConverter;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DeleteRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.InsertRowAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.auditlog.UpdateColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.models.guided.dtable.shared.validation.HitPolicyValidation;
import org.drools.workbench.screens.guided.dtable.client.GuidedDecisionTable;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.impl.DefaultClipboard;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AnalyzerController;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssueSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLog;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableViewImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.lockmanager.GuidedDecisionTableLockManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.BaseColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.GridWidgetColumnFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.EnumLoaderUtilities;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;
import org.drools.workbench.screens.guided.rule.client.util.GWTDateConverter;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class GuidedDecisionTablePresenter
implements GuidedDecisionTableView.Presenter {
    private final User identity;
    private final GuidedDTableResourceType resourceType;
    private final Caller<RuleNamesService> ruleNameService;
    private final Event<DecisionTableSelectedEvent> decisionTableSelectedEvent;
    private final Event<DecisionTableColumnSelectedEvent> decisionTableColumnSelectedEvent;
    private final Event<DecisionTableSelectionsChangedEvent> decisionTableSelectionsChangedEvent;
    private final Event<RefreshAttributesPanelEvent> refreshAttributesPanelEvent;
    private final Event<RefreshMetaDataPanelEvent> refreshMetaDataPanelEvent;
    private final Event<RefreshConditionsPanelEvent> refreshConditionsPanelEvent;
    private final Event<RefreshActionsPanelEvent> refreshActionsPanelEvent;
    private final Event<NotificationEvent> notificationEvent;
    private final GridWidgetCellFactory gridWidgetCellFactory;
    private final GridWidgetColumnFactory gridWidgetColumnFactory;
    private final AsyncPackageDataModelOracleFactory oracleFactory;
    private final ModelSynchronizer synchronizer;
    private final SyncBeanManager beanManager;
    private final GuidedDecisionTableLockManager lockManager;
    private final GuidedDecisionTableLinkManager linkManager;
    private final Clipboard clipboard;
    private final DecisionTableAnalyzerProvider decisionTableAnalyzerProvider;
    private final EnumLoaderUtilities enumLoaderUtilities;
    private final Access access = new Access();
    private GuidedDecisionTable52 model;
    private Overview overview;
    private AsyncPackageDataModelOracle oracle;
    private GuidedDecisionTableModellerView.Presenter parent;
    private BRLRuleModel rm;
    private GuidedDecisionTableUiModel uiModel;
    private GuidedDecisionTableView view;
    private GuidedDecisionTableRenderer renderer;
    private AuditLog auditLog;
    protected CellUtilities cellUtilities;
    protected ColumnUtilities columnUtilities;
    protected DependentEnumsUtilities dependentEnumsUtilities;
    protected AnalyzerController analyzerController;
    private String version = null;
    private ObservablePath latestPath = null;
    private ObservablePath currentPath = null;
    private PlaceRequest placeRequest = null;
    private Integer originalHashCode = null;
    private ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    private EventBus eventBus = new SimpleEventBus();

    @Inject
    public GuidedDecisionTablePresenter(User identity, GuidedDTableResourceType resourceType, Caller<RuleNamesService> ruleNameService, Event<DecisionTableSelectedEvent> decisionTableSelectedEvent, Event<DecisionTableColumnSelectedEvent> decisionTableColumnSelectedEvent, Event<DecisionTableSelectionsChangedEvent> decisionTableSelectionsChangedEvent, Event<RefreshAttributesPanelEvent> refreshAttributesPanelEvent, Event<RefreshMetaDataPanelEvent> refreshMetaDataPanelEvent, Event<RefreshConditionsPanelEvent> refreshConditionsPanelEvent, Event<RefreshActionsPanelEvent> refreshActionsPanelEvent, Event<NotificationEvent> notificationEvent, GridWidgetCellFactory gridWidgetCellFactory, GridWidgetColumnFactory gridWidgetColumnFactory, AsyncPackageDataModelOracleFactory oracleFactory, ModelSynchronizer synchronizer, SyncBeanManager beanManager, @GuidedDecisionTable GuidedDecisionTableLockManager lockManager, GuidedDecisionTableLinkManager linkManager, Clipboard clipboard, DecisionTableAnalyzerProvider decisionTableAnalyzerProvider, EnumLoaderUtilities enumLoaderUtilities) {
        this.identity = identity;
        this.resourceType = resourceType;
        this.ruleNameService = ruleNameService;
        this.decisionTableSelectedEvent = decisionTableSelectedEvent;
        this.decisionTableColumnSelectedEvent = decisionTableColumnSelectedEvent;
        this.decisionTableSelectionsChangedEvent = decisionTableSelectionsChangedEvent;
        this.refreshAttributesPanelEvent = refreshAttributesPanelEvent;
        this.refreshMetaDataPanelEvent = refreshMetaDataPanelEvent;
        this.refreshConditionsPanelEvent = refreshConditionsPanelEvent;
        this.refreshActionsPanelEvent = refreshActionsPanelEvent;
        this.notificationEvent = notificationEvent;
        this.gridWidgetCellFactory = gridWidgetCellFactory;
        this.gridWidgetColumnFactory = gridWidgetColumnFactory;
        this.oracleFactory = oracleFactory;
        this.synchronizer = synchronizer;
        this.beanManager = beanManager;
        this.lockManager = lockManager;
        this.linkManager = linkManager;
        this.clipboard = clipboard;
        this.decisionTableAnalyzerProvider = decisionTableAnalyzerProvider;
        this.enumLoaderUtilities = enumLoaderUtilities;
        CellUtilities.injectDateConvertor(this.getDateConverter());
    }

    DateConverter getDateConverter() {
        return GWTDateConverter.getInstance();
    }

    @Override
    public void activate() {
        this.lockManager.fireChangeTitleEvent();
    }

    @Override
    public GuidedDecisionTable52 getModel() {
        return this.model;
    }

    GridData getUiModel() {
        return this.uiModel;
    }

    @Override
    public AsyncPackageDataModelOracle getDataModelOracle() {
        return this.oracle;
    }

    @Override
    public Overview getOverview() {
        return this.overview;
    }

    @Override
    public GuidedDecisionTableView getView() {
        return this.view;
    }

    @Override
    public GuidedDecisionTableModellerView.Presenter getModellerPresenter() {
        return this.parent;
    }

    @Override
    public void setContent(ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, GuidedDecisionTableModellerView.Presenter parent, boolean isReadOnly) {
        this.parent = parent;
        this.latestPath = path;
        this.initialiseContent(path, placeRequest, content, isReadOnly);
    }

    @Override
    public void refreshContent(ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly) {
        this.onClose();
        this.initialiseContent(path, placeRequest, content, isReadOnly);
        if (!this.isReadOnly()) {
            this.analyzerController.initialiseAnalysis();
        }
    }

    void initialiseContent(ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly) {
        GuidedDecisionTable52 model = content.getModel();
        PackageDataModelOracleBaselinePayload dataModel = content.getDataModel();
        Set workItemDefinitions = content.getWorkItemDefinitions();
        this.currentPath = path;
        this.placeRequest = placeRequest;
        this.model = model;
        this.overview = content.getOverview();
        this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)path, (HasImports)model, dataModel);
        this.access.setReadOnly(isReadOnly);
        this.rm = new BRLRuleModel(model);
        this.uiModel = this.makeUiModel();
        this.renderer = this.makeViewRenderer();
        this.view = this.makeView(workItemDefinitions);
        this.initialiseLockManager();
        this.initialiseUtilities();
        this.initialiseModels();
        this.initialiseValidationAndVerification();
        this.initialiseAuditLog();
    }

    void initialiseLockManager() {
        this.lockManager.init(new LockTarget((Path)this.currentPath, (IsWidget)this.parent.getView().asWidget(), this.placeRequest, () -> this.currentPath.getFileName() + " - " + this.resourceType.getDescription(), () -> {}), this.parent);
    }

    GuidedDecisionTableUiModel makeUiModel() {
        return new GuidedDecisionTableUiModel(this.synchronizer){

            public GridData.Range selectCell(int rowIndex, int columnIndex) {
                GridData.Range rows = super.selectCell(rowIndex, columnIndex);
                GuidedDecisionTablePresenter.this.decisionTableSelectionsChangedEvent.fire((Object)new DecisionTableSelectionsChangedEvent(GuidedDecisionTablePresenter.this));
                return rows;
            }

            public GridData.Range selectCells(int rowIndex, int columnIndex, int width, int height) {
                GridData.Range rows = super.selectCells(rowIndex, columnIndex, width, height);
                GuidedDecisionTablePresenter.this.decisionTableSelectionsChangedEvent.fire((Object)new DecisionTableSelectionsChangedEvent(GuidedDecisionTablePresenter.this));
                return rows;
            }

            public boolean isRowDraggingEnabled() {
                return GuidedDecisionTablePresenter.this.access.isEditable();
            }

            public boolean isColumnDraggingEnabled() {
                return GuidedDecisionTablePresenter.this.access.isEditable();
            }
        };
    }

    GuidedDecisionTableRenderer makeViewRenderer() {
        return new GuidedDecisionTableRenderer(this.uiModel, this.model);
    }

    GuidedDecisionTableView makeView(Set<PortableWorkDefinition> workItemDefinitions) {
        return new GuidedDecisionTableViewImpl((GridData)this.uiModel, (GridRenderer)this.renderer, this, this.model, this.oracle, workItemDefinitions, this.notificationEvent, this.eventBus, this.access);
    }

    void initialiseUtilities() {
        this.cellUtilities = new CellUtilities();
        this.columnUtilities = new ColumnUtilities(this.model, this.oracle);
        this.dependentEnumsUtilities = new DependentEnumsUtilities(this.model, this.oracle);
        this.gridWidgetColumnFactory.setConverters(this.getConverters());
        this.gridWidgetColumnFactory.initialise(this.model, this.oracle, this.columnUtilities, this);
        this.synchronizer.setSynchronizers(this.getSynchronizers());
        this.synchronizer.initialise(this.model, this.uiModel, this.cellUtilities, this.columnUtilities, this.dependentEnumsUtilities, this.gridWidgetCellFactory, this.gridWidgetColumnFactory, this.view, this.rm, this.eventBus, this.access);
    }

    void initialiseModels() {
        this.initialiseLegacyColumnDataTypes();
        List modelColumns = this.model.getExpandedColumns();
        for (BaseColumn column : modelColumns) {
            this.initialiseColumn(column);
        }
        for (List row : this.model.getData()) {
            this.initialiseRow(modelColumns, row);
        }
        this.setOriginalHashCode(this.model.hashCode());
    }

    void initialiseLegacyColumnDataTypes() {
        for (CompositeColumn column : this.model.getConditions()) {
            if (!(column instanceof Pattern52)) continue;
            Pattern52 pattern = (Pattern52)column;
            for (ConditionCol52 condition : pattern.getChildColumns()) {
                condition.setFieldType(this.oracle.getFieldType(pattern.getFactType(), condition.getFactField()));
            }
        }
    }

    void initialiseValidationAndVerification() {
        this.analyzerController = this.decisionTableAnalyzerProvider.newAnalyzer(this.placeRequest, this.oracle, this.model, this.eventBus);
    }

    void initialiseAuditLog() {
        this.auditLog = new AuditLog(this.model, this.identity);
    }

    @Override
    public void link(Set<GuidedDecisionTableView.Presenter> dtPresenters) {
        HashSet<GuidedDecisionTableView.Presenter> otherDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>();
        otherDecisionTables.addAll(dtPresenters);
        otherDecisionTables.remove(this);
        otherDecisionTables.stream().forEach(e -> this.linkManager.link(this.getModel(), e.getModel(), (sourceColumnIndex, targetColumnIndex) -> {
            GridData sourceUiModel = this.getView().getModel();
            GridData targetUiModel = e.getView().getModel();
            ((GridColumn)sourceUiModel.getColumns().get(sourceColumnIndex)).setLink((GridColumn)targetUiModel.getColumns().get(targetColumnIndex));
        }));
    }

    List<BaseColumnConverter> getConverters() {
        ArrayList<BaseColumnConverter> converters = new ArrayList<BaseColumnConverter>();
        for (SyncBeanDef bean : this.beanManager.lookupBeans(BaseColumnConverter.class)) {
            converters.add((BaseColumnConverter)bean.getInstance());
        }
        Collections.sort(converters, new Comparator<BaseColumnConverter>(){

            @Override
            public int compare(BaseColumnConverter o1, BaseColumnConverter o2) {
                return o2.priority() - o1.priority();
            }
        });
        return converters;
    }

    List<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> getSynchronizers() {
        ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> synchronizers = new ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>>();
        for (SyncBeanDef bean : this.beanManager.lookupBeans(Synchronizer.class)) {
            synchronizers.add((Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>)bean.getInstance());
        }
        return synchronizers;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    @Override
    public void onClose() {
        this.terminateAnalysis();
        if (this.uiModel != null) {
            for (GridColumn column : this.uiModel.getColumns()) {
                if (!(column.getColumnRenderer() instanceof HasDOMElementResources)) continue;
                ((HasDOMElementResources)column.getColumnRenderer()).destroyResources();
            }
        }
        this.lockManager.releaseLock();
        this.oracleFactory.destroy(this.oracle);
    }

    @Override
    public void initialiseAnalysis() {
        if (this.analyzerController != null) {
            this.analyzerController.initialiseAnalysis();
        }
    }

    @Override
    public void terminateAnalysis() {
        if (this.analyzerController != null) {
            this.analyzerController.terminateAnalysis();
        }
    }

    public void select(GridWidget selectedGridWidget) {
        this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(this));
        if (!this.isReadOnly()) {
            this.lockManager.acquireLock();
        }
    }

    void onUpdatedLockStatusEvent(@Observes UpdatedLockStatusEvent event) {
        if (this.currentPath == null) {
            return;
        }
        if (this.currentPath.equals(event.getFile())) {
            if (event.isLocked()) {
                this.access.setLock(event.isLockedByCurrentUser() ? Access.LockedBy.CURRENT_USER : Access.LockedBy.OTHER_USER);
            } else {
                this.access.setLock(Access.LockedBy.NOBODY);
            }
            this.parent.onLockStatusUpdated(this);
        }
    }

    void onIssueSelectedEvent(@Observes IssueSelectedEvent event) {
        if (event == null) {
            return;
        }
        PlaceRequest placeRequest = event.getPlaceRequest();
        Issue issue = event.getIssue();
        if (placeRequest == null || issue == null) {
            this.renderer.clearHighlights();
        } else if (!placeRequest.equals(this.getPlaceRequest())) {
            this.renderer.clearHighlights();
        } else {
            this.renderer.highlightRows(event.getIssue().getSeverity(), event.getIssue().getRowNumbers());
        }
        this.getView().draw();
    }

    public void selectLinkedColumn(GridColumn<?> column) {
        this.decisionTableColumnSelectedEvent.fire((Object)new DecisionTableColumnSelectedEvent(column));
    }

    public Set<GridWidget> getGridWidgets() {
        return this.parent.getView().getGridWidgets();
    }

    public void enterPinnedMode(GridWidget gridWidget, Command onStartCommand) {
        this.parent.enterPinnedMode(gridWidget, onStartCommand);
    }

    public void exitPinnedMode(Command onCompleteCommand) {
        this.parent.exitPinnedMode(onCompleteCommand);
    }

    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
        this.parent.updatePinnedContext(gridWidget);
    }

    public GridPinnedModeManager.PinnedContext getPinnedContext() {
        return this.parent.getPinnedContext();
    }

    public boolean isGridPinned() {
        return this.parent.isGridPinned();
    }

    public TransformMediator getDefaultTransformMediator() {
        return this.parent.getDefaultTransformMediator();
    }

    @Override
    public void getPackageParentRuleNames(final ParameterizedCommand<Collection<String>> command) {
        ((RuleNamesService)this.ruleNameService.call((RemoteCallback)new RemoteCallback<Collection<String>>(){

            public void callback(Collection<String> ruleNames) {
                command.execute(ruleNames);
            }
        })).getRuleNames((Path)this.getCurrentPath(), this.model.getPackageName());
    }

    @Override
    public void setParentRuleName(String parentName) {
        this.model.setParentName(parentName);
    }

    @Override
    public boolean hasColumnDefinitions() {
        return this.model.getAttributeCols().size() > 0 || this.model.getConditionsCount() > 0L || this.model.getActionCols().size() > 0;
    }

    public Set<String> getBindings(String className) {
        String simpleClassName = className;
        if (simpleClassName != null && simpleClassName.lastIndexOf(".") > 0) {
            simpleClassName = simpleClassName.substring(simpleClassName.lastIndexOf(".") + 1);
        }
        HashSet<String> bindings = new HashSet<String>();
        for (Pattern52 p : this.model.getPatterns()) {
            String binding;
            if ((className == null || p.getFactType().equals(simpleClassName)) && (binding = p.getBoundName()) != null && !"".equals(binding)) {
                bindings.add(binding);
            }
            for (ConditionCol52 c : p.getChildColumns()) {
                String fieldDataType;
                if (!c.isBound() || !(fieldDataType = this.oracle.getFieldClassName(p.getFactType(), c.getFactField())).equals(className)) continue;
                bindings.add(c.getBinding());
            }
        }
        return bindings;
    }

    @Override
    public List<String> getLHSBoundFacts() {
        return this.rm.getLHSBoundFacts();
    }

    @Override
    public boolean canConditionBeDeleted(ConditionCol52 col) {
        Pattern52 pattern = this.model.getPattern(col);
        if (pattern.getChildColumns().size() > 1) {
            return true;
        }
        return !this.isBindingUsed(pattern.getBoundName());
    }

    @Override
    public boolean canConditionBeDeleted(BRLConditionColumn col) {
        for (IPattern p : col.getDefinition()) {
            FactPattern fp;
            if (!(p instanceof FactPattern) || !(fp = (FactPattern)p).isBound() || !this.isBindingUsed(fp.getBoundName())) continue;
            return false;
        }
        return true;
    }

    private boolean isBindingUsed(String binding) {
        return this.rm.isBoundFactUsed(binding);
    }

    @Override
    public Map<String, String> getValueListLookups(BaseColumn column) {
        String[] dropDownItems = this.columnUtilities.getValueList(column);
        return this.enumLoaderUtilities.convertDropDownData(dropDownItems);
    }

    @Override
    public void getEnumLookups(String factType, String factField, DependentEnumsUtilities.Context context, Callback<Map<String, String>> callback) {
        DropDownData enumDefinition = this.oracle.getEnums(factType, factField, this.dependentEnumsUtilities.getCurrentValueMap(context));
        this.enumLoaderUtilities.getEnums(enumDefinition, callback, this, () -> this.view.showBusyIndicator(CommonConstants.INSTANCE.RefreshingList()), () -> this.view.hideBusyIndicator());
    }

    @Override
    public void newAttributeOrMetaDataColumn() {
        if (this.isReadOnly()) {
            return;
        }
        this.view.newAttributeOrMetaDataColumn(this.getReservedAttributeNames());
    }

    private Set<String> getReservedAttributeNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getExistingAttributeNames());
        result.addAll(HitPolicyValidation.getReservedAttributes((GuidedDecisionTable52.HitPolicy)this.model.getHitPolicy()));
        return result;
    }

    private Set<String> getExistingAttributeNames() {
        HashSet<String> existingAttributeNames = new HashSet<String>();
        for (AttributeCol52 attributeCol : this.model.getAttributeCols()) {
            existingAttributeNames.add(attributeCol.getAttribute());
        }
        return existingAttributeNames;
    }

    @Override
    public boolean isMetaDataUnique(String metaDataName) {
        for (MetadataCol52 mc : this.model.getMetadataCols()) {
            if (!metaDataName.equals(mc.getMetadata())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void newConditionColumn() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryConditionColumn();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryConditionColumn();
            }
        }
    }

    @Override
    public void newConditionBRLFragment() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryConditionBRLFragment();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryConditionBRLFragment();
            }
        }
    }

    @Override
    public void newActionInsertColumn() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryActionInsertColumn();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryActionInsertColumn();
            }
        }
    }

    @Override
    public void newActionSetColumn() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryActionSetColumn();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryActionSetColumn();
            }
        }
    }

    @Override
    public void newActionRetractFact() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryActionRetractFact();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryActionRetractFact();
            }
        }
    }

    @Override
    public void newActionWorkItem() {
        if (this.isReadOnly()) {
            return;
        }
        this.view.newActionWorkItem();
    }

    @Override
    public void newActionWorkItemSetField() {
        if (this.isReadOnly()) {
            return;
        }
        this.view.newActionWorkItemSetField();
    }

    @Override
    public void newActionWorkItemInsertFact() {
        if (this.isReadOnly()) {
            return;
        }
        this.view.newActionWorkItemInsertFact();
    }

    @Override
    public void newActionBRLFragment() {
        if (this.isReadOnly()) {
            return;
        }
        switch (this.model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                this.view.newExtendedEntryActionBRLFragment();
                break;
            }
            case LIMITED_ENTRY: {
                this.view.newLimitedEntryActionBRLFragment();
            }
        }
    }

    @Override
    public void editCondition(Pattern52 pattern, ConditionCol52 column) {
        if (this.isReadOnly()) {
            return;
        }
        this.view.editCondition(pattern, column);
    }

    @Override
    public void editCondition(BRLConditionColumn column) {
        if (this.isReadOnly()) {
            return;
        }
        if (column instanceof LimitedEntryBRLConditionColumn) {
            this.view.editLimitedEntryConditionBRLFragment((LimitedEntryBRLConditionColumn)column);
        } else {
            this.view.editExtendedEntryConditionBRLFragment(column);
        }
    }

    @Override
    public void editAction(ActionCol52 column) {
        if (this.isReadOnly()) {
            return;
        }
        if (column instanceof ActionWorkItemSetFieldCol52) {
            this.view.editActionWorkItemSetField((ActionWorkItemSetFieldCol52)column);
        } else if (column instanceof ActionSetFieldCol52) {
            this.view.editActionSetField((ActionSetFieldCol52)column);
        } else if (column instanceof ActionWorkItemInsertFactCol52) {
            this.view.editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)column);
        } else if (column instanceof ActionInsertFactCol52) {
            this.view.editActionInsertFact((ActionInsertFactCol52)column);
        } else if (column instanceof ActionRetractFactCol52) {
            this.view.editActionRetractFact((ActionRetractFactCol52)column);
        } else if (column instanceof ActionWorkItemCol52) {
            this.view.editActionWorkItem((ActionWorkItemCol52)column);
        } else if (column instanceof LimitedEntryBRLActionColumn) {
            this.view.editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)column);
        } else if (column instanceof BRLActionColumn) {
            this.view.editExtendedEntryActionBRLFragment((BRLActionColumn)column);
        }
    }

    @Override
    public void appendColumn(AttributeCol52 column) {
        this.doAppendColumn((BaseColumn)column, () -> this.synchronizer.appendColumn((BaseColumn)column), () -> this.refreshAttributesPanelEvent.fire((Object)new RefreshAttributesPanelEvent(this, this.model.getAttributeCols())));
    }

    @Override
    public void appendColumn(MetadataCol52 column) {
        this.doAppendColumn((BaseColumn)column, () -> this.synchronizer.appendColumn((BaseColumn)column), () -> this.refreshMetaDataPanelEvent.fire((Object)new RefreshMetaDataPanelEvent(this, this.model.getMetadataCols())));
    }

    @Override
    public void appendColumn(Pattern52 pattern, ConditionCol52 column) {
        this.doAppendColumn((BaseColumn)column, () -> this.synchronizer.appendColumn(pattern, column), () -> this.refreshConditionsPanelEvent.fire((Object)new RefreshConditionsPanelEvent(this, this.model.getConditions())));
    }

    @Override
    public void appendColumn(ConditionCol52 column) {
        this.doAppendColumn((BaseColumn)column, () -> this.synchronizer.appendColumn((BaseColumn)column), () -> this.refreshConditionsPanelEvent.fire((Object)new RefreshConditionsPanelEvent(this, this.model.getConditions())));
    }

    @Override
    public void appendColumn(ActionCol52 column) {
        this.doAppendColumn((BaseColumn)column, () -> this.synchronizer.appendColumn((BaseColumn)column), () -> this.refreshActionsPanelEvent.fire((Object)new RefreshActionsPanelEvent(this, this.model.getActionCols())));
    }

    private void doAppendColumn(BaseColumn column, VetoableCommand append, Command callback) {
        if (this.isReadOnly()) {
            return;
        }
        try {
            append.execute();
            this.parent.updateLinks();
            this.view.getLayer().draw();
            this.model.getAuditLog().add((AuditLogEntry)new InsertColumnAuditLogEntry(this.identity.getIdentifier(), column));
            callback.execute();
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    @Override
    public void onAppendRow() {
        if (this.isReadOnly()) {
            return;
        }
        try {
            this.synchronizer.appendRow();
            this.parent.updateLinks();
            this.view.getLayer().draw();
            this.model.getAuditLog().add((AuditLogEntry)new InsertRowAuditLogEntry(this.identity.getIdentifier(), this.model.getData().size() - 1));
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    @Override
    public void deleteColumn(AttributeCol52 column) {
        this.doDeleteColumn((BaseColumn)column, () -> this.refreshAttributesPanelEvent.fire((Object)new RefreshAttributesPanelEvent(this, this.model.getAttributeCols())));
    }

    @Override
    public void deleteColumn(MetadataCol52 column) {
        this.doDeleteColumn((BaseColumn)column, () -> this.refreshMetaDataPanelEvent.fire((Object)new RefreshMetaDataPanelEvent(this, this.model.getMetadataCols())));
    }

    @Override
    public void deleteColumn(ConditionCol52 column) {
        this.doDeleteColumn((BaseColumn)column, () -> this.refreshConditionsPanelEvent.fire((Object)new RefreshConditionsPanelEvent(this, this.model.getConditions())));
    }

    @Override
    public void deleteColumn(ActionCol52 column) {
        this.doDeleteColumn((BaseColumn)column, () -> this.refreshActionsPanelEvent.fire((Object)new RefreshActionsPanelEvent(this, this.model.getActionCols())));
    }

    private void doDeleteColumn(BaseColumn column, Command callback) {
        if (this.isReadOnly()) {
            return;
        }
        try {
            this.synchronizer.deleteColumn(column);
            this.parent.updateLinks();
            this.view.getLayer().draw();
            this.model.getAuditLog().add((AuditLogEntry)new DeleteColumnAuditLogEntry(this.identity.getIdentifier(), column));
            callback.execute();
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    @Override
    public void updateColumn(AttributeCol52 originalColumn, AttributeCol52 editedColumn) {
        this.doUpdateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn, () -> this.synchronizer.updateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn), () -> this.refreshAttributesPanelEvent.fire((Object)new RefreshAttributesPanelEvent(this, this.model.getAttributeCols())));
    }

    @Override
    public void updateColumn(MetadataCol52 originalColumn, MetadataCol52 editedColumn) {
        this.doUpdateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn, () -> this.synchronizer.updateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn), () -> this.refreshMetaDataPanelEvent.fire((Object)new RefreshMetaDataPanelEvent(this, this.model.getMetadataCols())));
    }

    @Override
    public void updateColumn(Pattern52 originalPattern, ConditionCol52 originalColumn, Pattern52 editedPattern, ConditionCol52 editedColumn) {
        this.doUpdateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn, () -> this.synchronizer.updateColumn(originalPattern, originalColumn, editedPattern, editedColumn), () -> this.refreshConditionsPanelEvent.fire((Object)new RefreshConditionsPanelEvent(this, this.model.getConditions())));
    }

    @Override
    public void updateColumn(ConditionCol52 originalColumn, ConditionCol52 editedColumn) {
        this.doUpdateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn, () -> this.synchronizer.updateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn), () -> this.refreshConditionsPanelEvent.fire((Object)new RefreshConditionsPanelEvent(this, this.model.getConditions())));
    }

    @Override
    public void updateColumn(ActionCol52 originalColumn, ActionCol52 editedColumn) {
        this.doUpdateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn, () -> this.synchronizer.updateColumn((BaseColumn)originalColumn, (BaseColumn)editedColumn), () -> this.refreshActionsPanelEvent.fire((Object)new RefreshActionsPanelEvent(this, this.model.getActionCols())));
    }

    private void doUpdateColumn(BaseColumn originalColumn, BaseColumn editedColumn, VetoableUpdateCommand update, Command callback) {
        if (this.isReadOnly()) {
            return;
        }
        try {
            List<BaseColumnFieldDiff> diffs = update.execute();
            this.parent.updateLinks();
            if (diffs != null && !diffs.isEmpty()) {
                this.view.getLayer().draw();
                this.model.getAuditLog().add((AuditLogEntry)new UpdateColumnAuditLogEntry(this.identity.getIdentifier(), originalColumn, editedColumn, diffs));
                callback.execute();
            }
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    private void initialiseColumn(BaseColumn column) {
        GridColumn<?> gridColumn = this.gridWidgetColumnFactory.convertColumn(column, this.access, this.getView());
        this.uiModel.appendColumn(gridColumn);
    }

    private void initialiseRow(List<BaseColumn> columns, List<DTCellValue52> row) {
        BaseGridRow uiModelRow = new BaseGridRow(24.0);
        int rowIndex = this.uiModel.getRowCount();
        this.uiModel.appendRow((GridRow)uiModelRow);
        for (int iModelColumn = 0; iModelColumn < row.size(); ++iModelColumn) {
            DTCellValue52 modelCell = row.get(iModelColumn);
            BaseColumn modelColumn = columns.get(iModelColumn);
            if (modelColumn instanceof RowNumberCol52) {
                modelCell.setNumericValue(Integer.valueOf(this.uiModel.getRowCount()));
            }
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellInternal(rowIndex, iModelColumn, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
            if (!(modelColumn instanceof RowNumberCol52)) continue;
            this.uiModel.getCell(rowIndex, iModelColumn).setSelectionManager(RowSelectionStrategy.INSTANCE);
        }
    }

    @Override
    public void onCut() {
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        this.copyCellsToClipboard();
        this.onDeleteSelectedCells();
        this.view.showDataCutNotificationEvent();
    }

    @Override
    public void onCopy() {
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        this.copyCellsToClipboard();
        this.view.showDataCopiedNotificationEvent();
    }

    private void copyCellsToClipboard() {
        int columnIndex;
        int rowIndex;
        List selections = this.uiModel.getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            return;
        }
        int originRowIndex = Integer.MAX_VALUE;
        int originColumnIndex = Integer.MAX_VALUE;
        HashSet<Clipboard.ClipboardData> data = new HashSet<Clipboard.ClipboardData>();
        for (GridData.SelectedCell sc : selections) {
            rowIndex = sc.getRowIndex();
            columnIndex = this.findUiColumnIndex(sc.getColumnIndex());
            originRowIndex = Math.min(rowIndex, originRowIndex);
            originColumnIndex = Math.min(columnIndex, originColumnIndex);
        }
        for (GridData.SelectedCell sc : selections) {
            rowIndex = sc.getRowIndex();
            columnIndex = this.findUiColumnIndex(sc.getColumnIndex());
            DTCellValue52 value = (DTCellValue52)((List)this.model.getData().get(rowIndex)).get(columnIndex);
            data.add(new DefaultClipboard.ClipboardDataImpl(rowIndex - originRowIndex, columnIndex - originColumnIndex, new DTCellValue52(value)));
        }
        this.clipboard.setData(data);
    }

    @Override
    public void onPaste() {
        if (!this.clipboard.hasData()) {
            return;
        }
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        Set<Clipboard.ClipboardData> data = this.clipboard.getData();
        int currentOriginRowIndex = this.uiModel.getSelectedCellsOrigin().getRowIndex();
        int currentOriginColumnIndex = this.findUiColumnIndex(this.uiModel.getSelectedCellsOrigin().getColumnIndex());
        boolean updateSystemControlledValues = false;
        for (Clipboard.ClipboardData cd : data) {
            int targetRowIndex = currentOriginRowIndex + cd.getRowIndex();
            int targetColumnIndex = currentOriginColumnIndex + cd.getColumnIndex();
            if (targetRowIndex < 0 || targetRowIndex > this.uiModel.getRowCount() - 1 || targetColumnIndex < 0 || targetColumnIndex > this.uiModel.getColumns().size() - 1) continue;
            DTCellValue52 modelCell = cd.getValue();
            BaseColumn modelColumn = (BaseColumn)this.model.getExpandedColumns().get(targetColumnIndex);
            if (modelCell.hasValue()) {
                this.uiModel.setCell(targetRowIndex, targetColumnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
            } else {
                this.uiModel.deleteCell(targetRowIndex, targetColumnIndex);
            }
            if (!(modelColumn instanceof RowNumberCol52)) continue;
            updateSystemControlledValues = true;
        }
        if (updateSystemControlledValues) {
            this.synchronizer.updateSystemControlledColumnValues();
        }
        this.view.batch();
    }

    boolean isSelectionEmpty() {
        return this.uiModel.getSelectedCells().isEmpty();
    }

    @Override
    public void onDeleteSelectedCells() {
        if (this.isReadOnly()) {
            return;
        }
        List selections = this.uiModel.getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            return;
        }
        for (GridData.SelectedCell sc : selections) {
            int rowIndex = sc.getRowIndex();
            int columnIndex = this.findUiColumnIndex(sc.getColumnIndex());
            BaseColumn column = (BaseColumn)this.model.getExpandedColumns().get(columnIndex);
            GridColumn uiColumn = (GridColumn)this.uiModel.getColumns().get(columnIndex);
            if (column instanceof RowNumberCol52) continue;
            if (uiColumn instanceof BooleanUiColumn) {
                this.uiModel.setCell(rowIndex, columnIndex, (GridCellValue<?>)new GuidedDecisionTableUiCell<Boolean>(false));
                continue;
            }
            this.uiModel.deleteCell(rowIndex, columnIndex);
        }
        this.view.getLayer().draw();
    }

    @Override
    public void onDeleteSelectedColumns() {
        if (this.isReadOnly()) {
            return;
        }
        Set<Integer> selectedColumnIndexes = this.getSelectedColumnIndexes();
        HashSet<BaseColumn> columnsToDelete = new HashSet<BaseColumn>();
        for (int selectedColumnIndex : selectedColumnIndexes) {
            int columnIndex = this.findUiColumnIndex(selectedColumnIndex);
            BaseColumn column = (BaseColumn)this.model.getExpandedColumns().get(columnIndex);
            if (column instanceof RowNumberCol52 || column instanceof DescriptionCol52) continue;
            columnsToDelete.add(column);
        }
        for (BaseColumn columnToDelete : columnsToDelete) {
            if (columnToDelete instanceof AttributeCol52) {
                this.deleteColumn((AttributeCol52)columnToDelete);
                continue;
            }
            if (columnToDelete instanceof MetadataCol52) {
                this.deleteColumn((MetadataCol52)columnToDelete);
                continue;
            }
            if (columnToDelete instanceof ConditionCol52) {
                this.deleteColumn((ConditionCol52)columnToDelete);
                continue;
            }
            if (!(columnToDelete instanceof ActionCol52)) continue;
            this.deleteColumn((ActionCol52)columnToDelete);
        }
    }

    private Set<Integer> getSelectedColumnIndexes() {
        HashSet<Integer> columnUsage = new HashSet<Integer>();
        for (GridData.SelectedCell sc : this.uiModel.getSelectedCells()) {
            columnUsage.add(sc.getColumnIndex());
        }
        return columnUsage;
    }

    private int findUiColumnIndex(int modelColumnIndex) {
        List columns = this.uiModel.getColumns();
        for (int uiColumnIndex = 0; uiColumnIndex < columns.size(); ++uiColumnIndex) {
            GridColumn c = (GridColumn)columns.get(uiColumnIndex);
            if (c.getIndex() != modelColumnIndex) continue;
            return uiColumnIndex;
        }
        throw new IllegalStateException("Column was not found!");
    }

    @Override
    public void onDeleteSelectedRows() {
        Set<Integer> selectedRowIndexes;
        if (this.isReadOnly()) {
            return;
        }
        while (!(selectedRowIndexes = this.getSelectedRowIndexes()).isEmpty()) {
            int rowIndex = selectedRowIndexes.iterator().next();
            this.deleteRow(rowIndex);
        }
    }

    private void deleteRow(int rowIndex) {
        try {
            this.synchronizer.deleteRow(rowIndex);
            this.parent.updateLinks();
            this.view.getLayer().draw();
            this.model.getAuditLog().add((AuditLogEntry)new DeleteRowAuditLogEntry(this.identity.getIdentifier(), rowIndex));
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setMerged(boolean merged) {
        this.uiModel.setMerged(merged);
        this.view.getLayer().draw();
    }

    @Override
    public boolean isMerged() {
        return this.uiModel.isMerged();
    }

    @Override
    public void showAuditLog() {
        this.auditLog.show();
    }

    @Override
    public void onInsertRowAbove() {
        this.doInsertRow((ParameterizedCommand<Integer>)((ParameterizedCommand)this::insertRow));
    }

    @Override
    public void onInsertRowBelow() {
        this.doInsertRow((ParameterizedCommand<Integer>)((ParameterizedCommand)index -> this.insertRow(index + 1)));
    }

    private void doInsertRow(ParameterizedCommand<Integer> callback) {
        if (this.isReadOnly()) {
            return;
        }
        Set<Integer> selectedRowIndexes = this.getSelectedRowIndexes();
        if (selectedRowIndexes.size() != 1) {
            return;
        }
        callback.execute((Object)selectedRowIndexes.iterator().next());
    }

    private Set<Integer> getSelectedRowIndexes() {
        HashSet<Integer> rowUsage = new HashSet<Integer>();
        for (GridData.SelectedCell sc : this.uiModel.getSelectedCells()) {
            rowUsage.add(sc.getRowIndex());
        }
        return rowUsage;
    }

    private void insertRow(int rowIndex) {
        try {
            this.synchronizer.insertRow(rowIndex);
            this.parent.updateLinks();
            this.view.getLayer().draw();
            this.model.getAuditLog().add((AuditLogEntry)new InsertRowAuditLogEntry(this.identity.getIdentifier(), rowIndex));
        }
        catch (ModelSynchronizer.MoveColumnVetoException moveColumnVetoException) {
            // empty catch block
        }
    }

    @Override
    public void onOtherwiseCell() {
        if (this.isReadOnly()) {
            return;
        }
        List selections = this.uiModel.getSelectedCells();
        if (selections.size() != 1) {
            return;
        }
        GridData.SelectedCell selection = (GridData.SelectedCell)selections.get(0);
        int columnIndex = this.findUiColumnIndex(selection.getColumnIndex());
        this.synchronizer.setCellOtherwiseState(selection.getRowIndex(), columnIndex);
        this.view.getLayer().draw();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ObservablePath getLatestPath() {
        return this.latestPath;
    }

    public void setLatestPath(ObservablePath latestPath) {
        this.latestPath = latestPath;
    }

    public ObservablePath getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(ObservablePath currentPath) {
        this.currentPath = currentPath;
    }

    public PlaceRequest getPlaceRequest() {
        return this.placeRequest;
    }

    public boolean isReadOnly() {
        return !this.access.isEditable();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.access.setReadOnly(isReadOnly);
    }

    public Integer getOriginalHashCode() {
        return this.originalHashCode;
    }

    public void setOriginalHashCode(Integer originalHashCode) {
        this.originalHashCode = originalHashCode;
    }

    public ObservablePath.OnConcurrentUpdateEvent getConcurrentUpdateSessionInfo() {
        return this.concurrentUpdateSessionInfo;
    }

    public void setConcurrentUpdateSessionInfo(ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo) {
        this.concurrentUpdateSessionInfo = concurrentUpdateSessionInfo;
    }

    private static interface VetoableUpdateCommand {
        public List<BaseColumnFieldDiff> execute() throws ModelSynchronizer.MoveColumnVetoException;
    }

    private static interface VetoableCommand {
        public void execute() throws ModelSynchronizer.MoveColumnVetoException;
    }

    public static class Access {
        private LockedBy lock = LockedBy.NOBODY;
        private boolean isReadOnly = false;

        public LockedBy getLock() {
            return this.lock;
        }

        public void setLock(LockedBy lock) {
            this.lock = lock;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        public boolean isEditable() {
            return this.lock != LockedBy.OTHER_USER && !this.isReadOnly;
        }

        public static enum LockedBy {
            CURRENT_USER,
            OTHER_USER,
            NOBODY;

        }
    }
}

